
/************************************************************************
 *
 *  sys_platform.c
 *
 *  Platform specific system functions
 *
 * ######################################################################
 *
 * mips_start_of_legal_notice
 * 
 * Copyright (c) 2003 MIPS Technologies, Inc. All rights reserved.
 *
 *
 * Unpublished rights (if any) reserved under the copyright laws of the
 * United States of America and other countries.
 *
 * This code is proprietary to MIPS Technologies, Inc. ("MIPS
 * Technologies"). Any copying, reproducing, modifying or use of this code
 * (in whole or in part) that is not expressly permitted in writing by MIPS
 * Technologies or an authorized third party is strictly prohibited. At a
 * minimum, this code is protected under unfair competition and copyright
 * laws. Violations thereof may result in criminal penalties and fines.
 *
 * MIPS Technologies reserves the right to change this code to improve
 * function, design or otherwise. MIPS Technologies does not assume any
 * liability arising out of the application or use of this code, or of any
 * error or omission in such code. Any warranties, whether express,
 * statutory, implied or otherwise, including but not limited to the implied
 * warranties of merchantability or fitness for a particular purpose, are
 * excluded. Except as expressly provided in any written license agreement
 * from MIPS Technologies or an authorized third party, the furnishing of
 * this code does not give recipient any license to any intellectual
 * property rights, including any patent rights, that cover this code.
 *
 * This code shall not be exported or transferred for the purpose of
 * reexporting in violation of any U.S. or non-U.S. regulation, treaty,
 * Executive Order, law, statute, amendment or supplement thereto.
 *
 * This code constitutes one or more of the following: commercial computer
 * software, commercial computer software documentation or other commercial
 * items. If the user of this code, or any related documentation of any
 * kind, including related technical data or manuals, is an agency,
 * department, or other entity of the United States government
 * ("Government"), the use, duplication, reproduction, release,
 * modification, disclosure, or transfer of this code, or any related
 * documentation of any kind, is restricted in accordance with Federal
 * Acquisition Regulation 12.212 for civilian agencies and Defense Federal
 * Acquisition Regulation Supplement 227.7202 for military agencies. The use
 * of this code by the Government is further restricted in accordance with
 * the terms of the license agreement(s) and/or applicable contract terms
 * and conditions covering this code from MIPS Technologies or an authorized
 * third party.
 *
 * 
 * mips_end_of_legal_notice
 * 
 *
 ************************************************************************/


/************************************************************************
 *  Include files
 ************************************************************************/

#include <sysdefs.h>
#include <sysdev.h>
#if defined(Board_LAN_8139CP)
  #include <net_api.h>
#endif
#include <sys_api.h>
#include <io_api.h>

#if defined(Board_LAN_8139CP)
  #include <lan_api.h>
#endif

#include <product.h>
#include <project_config.h>

/************************************************************************
 *  Definitions
 ************************************************************************/

/************************************************************************
 *  Public variables
 ************************************************************************/

/************************************************************************
 *  Static variables
 ************************************************************************/

static bool poll_enable = TRUE;

/************************************************************************
 *  Static function prototypes
 ************************************************************************/


/************************************************************************
 *  Implementation : Public functions
 ************************************************************************/


/************************************************************************
 *
 *                          sys_dma_enable
 *  Description :
 *  -------------
 *
 *  Platform specific handling of DMA (enable/disable)
 *
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
void
sys_dma_enable(
    bool enable )  /* TRUE -> Enable DMA devices, FALSE -> Disable  */
{
#if defined(Board_LAN_8139CP) //cylee add for modulized

    t_LAN_CTRL_desc ctrl;

    ctrl.data    = NULL;
    ctrl.command = enable ? 
               LAN_CTRL_START_CONTROLLER :
               LAN_CTRL_STOP_CONTROLLER;

    switch( sys_platform )
    {
        case PRODUCT_MALTA_ID :
            IO_ctrl( SYS_MAJOR_LAN_8139CPLUS, 0, (void *)&ctrl );
            break;
    
        default :
            break;
    }
#endif
}


/************************************************************************
 *
 *                          sys_poll
 *  Description :
 *  -------------
 *
 *  Poll drivers that need to be polled.
 *
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
void
sys_poll( void )
{
    if( poll_enable )
    {
#if 0    	
        NET_poll();
#endif      
    }
}


/************************************************************************
 *
 *                          sys_poll_enable
 *  Description :
 *  -------------
 *
 *  Enable/disable non-critical polling done by function sys_poll
 *
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
void
sys_poll_enable( 
    bool enable )	/* TRUE -> poll enabled, FALSE -> poll disabled */
{
    poll_enable = enable;
}


/************************************************************************
 *  Implementation : static functions
 ************************************************************************/


