// rec.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <winbase.h>
#include "rec.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only application object

CWinApp theApp;

using namespace std;

void swap(char *src, char *dst)
{
	dst[0] = src[3];
	dst[1] = src[2];
	dst[2] = src[1];
	dst[3] = src[0];
}

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
#define tag_start		char0
#define tag_end			char0

	FILE *fd_Param;
	unsigned int in_reg, in_val;
	unsigned int in_reg_swap, in_val_swap;

	DCB		comDcb;
	HANDLE	hCom;
	COMMTIMEOUTS     CommTOuts;

	const unsigned char char0 = 0x0;
	const unsigned char char80 = 0x80;  //update both register and image
	const unsigned char char81 = 0x81;  //update only register
	const unsigned char charFF = 0xff;
	const unsigned char charESC = 0x1b;

	unsigned long read_data_len;
	unsigned long writed_data_len;

	unsigned char rxBuf[128];
	unsigned int *pInt;

	unsigned char cmd = char80;


	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
		return -1;
	}

	/******************************************
	 * get input file
	 ******************************************/

	if ( argc < 2 )
	{
		printf("Input Register-Value pair to target device via COM1 port\n" \
			   "\n" \
			   "USAGE : rec filename [noimage]\n" \
			   "\n" \
			   "        filename: file that contain register-value pairs\n" \
               "        noimage : do not update image, only update register setting\n" \
			   "\n" );
		return -1;
	}

	if (argc >= 3)
	{
		if (strncmp(argv[2], "noimage", 7) != 0)
		{
			printf("error with parameter '%s' !!\n", argv[2]);
			return 0;
		}
		else
		{
			cmd = char81;
		}
	}
	
	/* open parameter file */
	if ((fd_Param = fopen(argv[1], "r")) == NULL)
	{
		printf("ERROR !! no parameter file existing!!\n" \
			   "         Please input a correct filename");
		return -1;
	}
	else
		printf("\nOpen parameter file %s\n", argv[1]);

	/******************************************
	 * create and setup COM port object
	 ******************************************/
	hCom = CreateFile("COM1",GENERIC_READ | GENERIC_WRITE,0,  
		NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);  

	if(hCom==INVALID_HANDLE_VALUE)
	{
		hCom = CreateFile("\\\\.\\COM1",GENERIC_READ | GENERIC_WRITE,0,  
			NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);  

		if(hCom==INVALID_HANDLE_VALUE)
		{
			printf("ERROR !! Open COM1 Port fail!! \n"
			   "    Please close other COM Port communication program \n");
			fclose(fd_Param);
			return -1;
		}
	}

	printf("Open COM1 Port\n");
	
	//set TX/RX buffer
	if (!SetupComm(hCom, 100, 100))
	{
		printf("ERROR !! setup com port FIFO fail!! \n"
		   "    Please close other hyper-terminal program \n");
		//stop all TX/RX operations and purge TX/RX buffer
		PurgeComm(hCom, PURGE_TXABORT || PURGE_RXABORT ||
						PURGE_TXCLEAR || PURGE_RXCLEAR);
		fclose(fd_Param);
		return -1;
	}
	memset(&comDcb, 0x0, sizeof (DCB));
	
	comDcb.DCBlength = sizeof(DCB);
	comDcb.ByteSize = 8;
	comDcb.BaudRate = 115200;
	//ComDcb.fRtsControl=0;//RTS control
	//ComDcb.fDtrControl=0;//data terminate ready control
	//ComDcb.fOutX=1;      //XON/XOFF out flow control
	//ComDcb.fInX=1;       //XON/XOFF in flow control
	comDcb.Parity   = 0;   //0-4=no,odd,even,mark,space
	comDcb.StopBits = ONESTOPBIT;
	comDcb.fAbortOnError = 1;
	comDcb.fBinary  = TRUE;

	//set monitor event
//	SetCommMask(hCom,	EV_RXCHAR);

	//config communication device according to specified DCB
	if (!SetCommState(hCom, &comDcb))
	{
		printf("ERROR !! Setup COM device parameter fail !!\n");
		//stop all TX/RX operations and purge TX/RX buffer
		PurgeComm(hCom, PURGE_TXABORT || PURGE_RXABORT ||
						PURGE_TXCLEAR || PURGE_RXCLEAR);
		fclose(fd_Param);
		return -1;
	}

	memset(&CommTOuts, 0x0, sizeof (COMMTIMEOUTS));
	//setup TX/RX timeout
	CommTOuts.ReadIntervalTimeout = MAXDWORD;

	if ( !GetCommTimeouts(hCom ,&CommTOuts ) ) 
	{
		printf("get COM device timeout fail !!\n");
		//stop all TX/RX operations and purge TX/RX buffer
		PurgeComm(hCom, PURGE_TXABORT || PURGE_RXABORT ||
						PURGE_TXCLEAR || PURGE_RXCLEAR);
		fclose(fd_Param);
		return -1;
    }

    /* set the max. time between consecutive received characters */
    CommTOuts.ReadIntervalTimeout = 1000L * comDcb.ByteSize * 5 / comDcb.BaudRate;

	CommTOuts.WriteTotalTimeoutConstant   =
    CommTOuts. ReadTotalTimeoutConstant   = 2 * CommTOuts.ReadIntervalTimeout;
    CommTOuts.WriteTotalTimeoutMultiplier =
    CommTOuts. ReadTotalTimeoutMultiplier = 1000L * (comDcb.ByteSize + 4) / comDcb.BaudRate;
		
	/* prevent the null timeouts that might occur at high baud rates */
    if ( CommTOuts.ReadIntervalTimeout         < 1 )
	 CommTOuts.ReadIntervalTimeout         = 1;
    if ( CommTOuts.WriteTotalTimeoutConstant   < 1 )
	 CommTOuts.WriteTotalTimeoutConstant   = 1;
    if ( CommTOuts.ReadTotalTimeoutConstant    < 1 )
	 CommTOuts.ReadTotalTimeoutConstant    = 1;
    if ( CommTOuts.WriteTotalTimeoutMultiplier < 1 )
	 CommTOuts.WriteTotalTimeoutMultiplier = 1;
    if ( CommTOuts.ReadTotalTimeoutMultiplier  < 1 )
	 CommTOuts.ReadTotalTimeoutMultiplier  = 1;
	
	//set TX/RX timeout parameters
	if (!SetCommTimeouts(hCom, &CommTOuts))
	{
		printf("setup COM device timeout fail !!\n");
		//stop all TX/RX operations and purge TX/RX buffer
		PurgeComm(hCom, PURGE_TXABORT || PURGE_RXABORT ||
						PURGE_TXCLEAR || PURGE_RXCLEAR);
		fclose(fd_Param);
		return -1;
	}

	/******************************************
	 * pollig COM port to recovery mode
	 ******************************************/
	while (1)
	{
		memset(rxBuf, 0x0, 128);
		
		//write escape char '0x80' to COM1 to enter recovery mode
		WriteFile(hCom, &cmd, 1, &writed_data_len, NULL);

		if (writed_data_len == 0)
		{
			printf("ERROR !! write init char fail \n");
			//stop all TX/RX operations and purge TX/RX buffer
			PurgeComm(hCom, PURGE_TXABORT || PURGE_RXABORT ||
							PURGE_TXCLEAR || PURGE_RXCLEAR);
			fclose(fd_Param);
			return -1;
		}

		//read COM1 port to determine the target was entered recovery mode
		ReadFile(hCom, rxBuf, 127, &read_data_len, NULL);
		
		if (read_data_len != 0)
		{
			if (rxBuf[0] == cmd)
			{
				printf ("Start input register-value pairs to device\n");
				break;
			}
			else
			{
				printf("TX = %02x, RX => %02x\n", cmd, rxBuf[0]);
			}
		}
	}

	/******************************************
	 * write register-value pairs to com port
	 ******************************************/

	//stop all TX/RX operations and purge TX/RX buffer
	PurgeComm(hCom, PURGE_TXABORT || PURGE_RXABORT ||
					PURGE_TXCLEAR || PURGE_RXCLEAR);

	while (fscanf(fd_Param, "%x %x", &in_reg, &in_val) != EOF)
	{
		if (in_reg == 0)
		{
			Sleep(in_val);						
		}
		else
		{
			swap((char *)&in_reg, (char *)&in_reg_swap);
			swap((char *)&in_val, (char *)&in_val_swap);

			memset(rxBuf, 0x0, 128);
			printf("tx: 00-%08x-%08x-00\nrx: ", in_reg, in_val);

			WriteFile(hCom, &tag_start,  1, &writed_data_len, NULL);
			Sleep(50);
			ReadFile(hCom, rxBuf, 127, &read_data_len, NULL);

			WriteFile(hCom, &in_reg_swap, 4, &writed_data_len, NULL);
			Sleep(50);
			ReadFile(hCom, &rxBuf[1], 127, &read_data_len, NULL);

			WriteFile(hCom, &in_val_swap, 4, &writed_data_len, NULL);
			Sleep(50);
			ReadFile(hCom, &rxBuf[5], 127, &read_data_len, NULL);

			WriteFile(hCom, &tag_end,  1, &writed_data_len, NULL);
			Sleep(50);
			ReadFile(hCom, &rxBuf[9], 127, &read_data_len, NULL);

			pInt = (unsigned int *)(rxBuf + 1);

			printf ("%02x-%08x-%08x-%02x\n\n", rxBuf[0], *pInt, *(pInt + 1), rxBuf[9]);
		}
	}

	/****************************************************
	 * write terminate tag com port and terminate program
	 ****************************************************/

	//write terminate char 0xff to COM1 to leave register setting
	WriteFile(hCom, &charFF, 1, &writed_data_len, NULL);

	//stop all TX/RX operations and purge TX/RX buffer
	PurgeComm(hCom, PURGE_TXABORT || PURGE_RXABORT ||
					PURGE_TXCLEAR || PURGE_RXCLEAR);

	//write 'ESC' to COM1 to let bootcode entering 'shell'
	if (cmd == char81)
	{
		for (int idx = 0; idx < 1000; idx++)
		{
			WriteFile(hCom, &charESC, 1, &writed_data_len, NULL);
			Sleep(1);
		}
	}
	
    CloseHandle(hCom);
	fclose(fd_Param);

	printf ("\n Now Register setting is done!!\n " \
		    " Please execute 'hyper-terminal' to upload bootcode image to device\n\n");



	return 0;
}
