/************************************************
 Comments in Big5:				
	ɴyz Flash Memory 
	ʧ@ɩһݪ禡				

	
						
************************************************/
#ifndef __FLASHDEV_P_H__
#define __FLASHDEV_P_H__

#define FLASH_ADDR_BASE		0xbfcfffff

 
#define MXIC        0xc2
#define SPANSION    0x01
#define ATMEL       0x1f
#define AMIC        0x37
#define EON         0x7f
#define EON         0x7f
#define FUJITSU     0x04

#define MX29LV160C_BOTTOM     0x000049
#define MX29LV160C_TOP        0x0000c4


#define MX29LV320C_BOTTOM     0x0000a8
#define MX29LV320C_TOP        0x0000a7

#define MX29LV640B_BOTTOM     0x0000cb
#define MX29LV640B_TOP        0x0000c9

#define MX29LV320M_BOTTOM     0x001a7e
#define MX29LV320M_TOP        0x011a7e
#define MX29LV640M_BOTTOM     0x00107e
#define MX29LV640M_TOP        0x01107e
#define MX29LV128M_BOTTOM     0x00117e
#define MX29LV128M_TOP        0x01117e
#define MX29LV128D_BOTTOM     0x00007a
#define MX29LV128D_TOP        0x00007e
 
#define S29AL016D_BOTTOM      0x000049
#define S29AL016D_TOP         0x0000c4

#define S29GL32M_R4_BOTTOM    0x001a7e
#define S29GL32M_R3_TOP       0x011a7e
#define S29GL64M_R4_BOTTOM    0x00107e
#define S29GL64M_R3_TOP       0x01107e
#define S29GL128N             0x01217e
	
#define AT49BV163AT           0xc2	
#define AT49BV163A            0xc0 
#define A29L160A_BOTTOM       0x000049
#define A29L160A_TOP          0x0000c4

#define EN29LV640B_TOP        0x0000c9
#define EN29LV640B_BOTTOM     0x0000cb

#define MBM29DL640E_TOP       0x00007e


typedef struct 
{
    unsigned char              mid ;
    unsigned char         did_cycle;
    unsigned int               did ;
    unsigned int    *flash_sectors ;
    unsigned int      total_sector ;
    unsigned int        flash_size ;
    
}
p_device_type;

/**********************************************
	UCsectors }uw糧flash memory,
	pGw馳Ҳ, Udatasheetҧ
************************************************/
static unsigned int at16_top_flash_sectors[ 39 ] = 
{
	0x000000,  0x010000, 
	0x020000,  0x030000,  
	0x040000,  0x050000, 
	0x060000,  0x070000,  
	0x080000,  0x090000,  
	0x0a0000,  0x0b0000, 
	0x0c0000,  0x0d0000,  
	0x0e0000,  0x0f0000, 
	0x100000,  0x110000,  
	0x120000,  0x130000,  
	0x140000,  0x150000, 
	0x160000,  0x170000,  
	0x180000,  0x190000,  
	0x1a0000,  0x1b0000, 
	0x1c0000,  0x1d0000,  
	0x1e0000,  0x1f0000, 	  
	0x1f2000,  0x1f4000,
	0x1f6000,  0x1f8000,
	0x1fa000,  0x1fc000,
	0x1fe000
};


static unsigned int at16_bottom_flash_sectors[ 39 ] = 
{
	0x000000,  0x002000, 
	0x004000,  0x006000,  
	0x008000,  0x00a000, 
	0x00c000,  0x00e000,  
	0x010000,  0x020000,  
	0x030000,  0x040000,
	0x050000,  0x060000,  
	0x070000,  0x080000,
	0x090000,  0x0a0000,  
	0x0b0000,  0x0c0000,
	0x0d0000,  0x0e0000,  
	0x0f0000,  0x100000,
	 
        0x110000,  
	0x120000,  0x130000,  
	0x140000,  0x150000, 
	0x160000,  0x170000,  
	0x180000,  0x190000,  
	0x1a0000,  0x1b0000, 
	0x1c0000,  0x1d0000,  
	0x1e0000,  0x1f0000 	  
	
};


static unsigned int mx16_top_flash_sectors[ 35 ] = 
{
	0x000000,  0x010000, 
	0x020000,  0x030000,  
	0x040000,  0x050000, 
	0x060000,  0x070000,  
	0x080000,  0x090000,  
	0x0a0000,  0x0b0000, 
	0x0c0000,  0x0d0000,  
	0x0e0000,  0x0f0000, 
	0x100000,  0x110000,  
	0x120000,  0x130000,  
	0x140000,  0x150000, 
	0x160000,  0x170000,  
	0x180000,  0x190000,  
	0x1a0000,  0x1b0000, 
	0x1c0000,  0x1d0000,  
	0x1e0000,  0x1f0000, 	  
	0x1f8000, 
	0x1fa000,  0x1fc000
};


static unsigned int mx16_bottom_flash_sectors[ 35 ] = 
{
	0x000000, 
	0x004000,  0x006000,  
	0x008000, 
	0x010000,  0x020000,  
	0x030000,  0x040000, 
	0x050000,  0x060000,  
	0x070000,  0x080000, 
	0x090000,  0x0a0000,  
	0x0b0000,  0x0c0000,  
	0x0d0000,  0x0e0000, 
	0x0f0000,  0x100000,  
	0x110000,  0x120000,  
	0x130000,  0x140000, 
	0x150000,  0x160000,  
	0x170000,  0x180000, 
	0x190000,  0x1a0000, 
	0x1b0000,  0x1c0000,  
	0x1d0000,  0x1e0000, 
	0x1f0000 
	
};


static unsigned int sp32_top_flash_sectors[ 71 ] = 
{
	0x000000,  0x010000, 
	0x020000,  0x030000,  
	0x040000,  0x050000, 
	0x060000,  0x070000,  
	0x080000,  0x090000,  
	0x0a0000,  0x0b0000, 
	0x0c0000,  0x0d0000,  
	0x0e0000,  0x0f0000, 
	0x100000,  0x110000,  
	0x120000,  0x130000,  
	0x140000,  0x150000, 
	0x160000,  0x170000,  
	0x180000,  0x190000,  
	0x1a0000,  0x1b0000, 
	0x1c0000,  0x1d0000,  
	0x1e0000,  0x1f0000, 
	0x200000,  0x210000, 
	0x220000,  0x230000,  
	0x240000,  0x250000, 
	0x260000,  0x270000,  
	0x280000,  0x290000,  
	0x2a0000,  0x2b0000, 
	0x2c0000,  0x2d0000,  
	0x2e0000,  0x2f0000, 
	0x300000,  0x310000,  
	0x320000,  0x330000,  
	0x340000,  0x350000, 
	0x360000,  0x370000,  
	0x380000,  0x390000,  
	0x3a0000,  0x3b0000, 
	0x3c0000,  0x3d0000,  
	0x3e0000,  0x3f0000,
	0x3f2000,  0x3f4000,  
	0x3f6000,  0x3f8000, 
	0x3fa000,  0x3fc000,  
	0x3fe000
};

static unsigned int sp32_bottom_flash_sectors[ 71 ] = 
{
	0x000000,  0x002000, 
	0x004000,  0x006000,  
	0x008000,  0x00a000, 
	0x00c000,  0x00e000,  
	0x010000,  0x020000,  
	0x030000,  0x040000, 
	0x050000,  0x060000,  
	0x070000,  0x080000, 
	0x090000,  0x0a0000,  
	0x0b0000,  0x0c0000,  
	0x0d0000,  0x0e0000, 
	0x0f0000,  0x100000,  
	0x110000,  0x120000,  
	0x130000,  0x140000, 
	0x150000,  0x160000,  
	0x170000,  0x180000, 
	0x190000,  0x1a0000, 
	0x1b0000,  0x1c0000,  
	0x1d0000,  0x1e0000, 
	0x1f0000,  0x200000,  
	0x210000,  0x220000,  
	0x230000,  0x240000, 
	0x250000,  0x260000,  
	0x270000,  0x280000, 
	0x290000,  0x2a0000,  
	0x2b0000,  0x2c0000,  
	0x2d0000,  0x2e0000, 
	0x2f0000,  0x300000,  
	0x310000,  0x320000,  
	0x330000,  0x340000, 
	0x350000,  0x360000,  
	0x370000,  0x380000,
	0x390000,  0x3a0000,  
	0x3b0000,  0x3c0000, 
	0x3d0000,  0x3e0000,  
	0x3f0000
};

static unsigned int fujitsu64_top_flash_sectors[ 142 ] = 
{
	0x000000,  0x002000, 0x004000,  0x006000,
	0x008000,  0x00a000, 0x00c000,  0x00e000,

	0x010000,  0x020000, 0x030000,
	0x040000,  0x050000, 0x060000,  0x070000,
	0x080000,  0x090000, 0x0a0000,  0x0b0000,
	0x0c0000,  0x0d0000, 0x0e0000,  0x0f0000,
	0x100000,  0x110000, 0x120000,  0x130000,
	0x140000,  0x150000, 0x160000,  0x170000,
	0x180000,  0x190000, 0x1a0000,  0x1b0000,
	0x1c0000,  0x1d0000, 0x1e0000,  0x1f0000,
	0x200000,  0x210000, 0x220000,  0x230000,
	0x240000,  0x250000, 0x260000,  0x270000,
	0x280000,  0x290000, 0x2a0000,  0x2b0000,
	0x2c0000,  0x2d0000, 0x2e0000,  0x2f0000,
	0x300000,  0x310000, 0x320000,  0x330000,
	0x340000,  0x350000, 0x360000,  0x370000,
	0x380000,  0x390000, 0x3a0000,  0x3b0000,
	0x3c0000,  0x3d0000, 0x3e0000,  0x3f0000,
	0x400000,  0x410000, 0x420000,  0x430000,
	0x440000,  0x450000, 0x460000,  0x470000,
	0x480000,  0x490000, 0x4a0000,  0x4b0000,
	0x4c0000,  0x4d0000, 0x4e0000,  0x4f0000,
	0x500000,  0x510000, 0x520000,  0x530000,
	0x540000,  0x550000, 0x560000,  0x570000,
	0x580000,  0x590000, 0x5a0000,  0x5b0000,
	0x5c0000,  0x5d0000, 0x5e0000,  0x5f0000,
	0x600000,  0x610000, 0x620000,  0x630000,
	0x640000,  0x650000, 0x660000,  0x670000,
	0x680000,  0x690000, 0x6a0000,  0x6b0000,
	0x6c0000,  0x6d0000, 0x6e0000,  0x6f0000,
	0x700000,  0x710000, 0x720000,  0x730000,
	0x740000,  0x750000, 0x760000,  0x770000,
	0x780000,  0x790000, 0x7a0000,  0x7b0000,
	0x7c0000,  0x7d0000, 0x7e0000,  0x7f0000,

	0x7f2000,  0x7f4000, 0x7f6000,  0x7f8000,
	0x7fa000,  0x7fc000, 0x7fe000,
};

static unsigned int mx64_top_flash_sectors[ 135 ] = 
{
	0x000000,  0x010000, 0x020000,  0x030000,	  
	0x040000,  0x050000, 0x060000,  0x070000, 	 
	0x080000,  0x090000, 0x0a0000,  0x0b0000,	 
	0x0c0000,  0x0d0000, 0x0e0000,  0x0f0000, 	 
	0x100000,  0x110000, 0x120000,  0x130000, 	  
	0x140000,  0x150000, 0x160000,  0x170000,	  
	0x180000,  0x190000, 0x1a0000,  0x1b0000, 	 
	0x1c0000,  0x1d0000, 0x1e0000,  0x1f0000, 	 
	0x200000,  0x210000, 0x220000,  0x230000,	  
	0x240000,  0x250000, 0x260000,  0x270000,	  
	0x280000,  0x290000, 0x2a0000,  0x2b0000, 	 
	0x2c0000,  0x2d0000, 0x2e0000,  0x2f0000, 	 
	0x300000,  0x310000, 0x320000,  0x330000, 	  
	0x340000,  0x350000, 0x360000,  0x370000,	  
	0x380000,  0x390000, 0x3a0000,  0x3b0000, 	 
	0x3c0000,  0x3d0000, 0x3e0000,  0x3f0000,
	
	0x400000,  0x410000, 0x420000,  0x430000,	  
	0x440000,  0x450000, 0x460000,  0x470000, 	 
	0x480000,  0x490000, 0x4a0000,  0x4b0000,	 
	0x4c0000,  0x4d0000, 0x4e0000,  0x4f0000, 	 
	0x500000,  0x510000, 0x520000,  0x530000, 	  
	0x540000,  0x550000, 0x560000,  0x570000,	  
	0x580000,  0x590000, 0x5a0000,  0x5b0000, 	 
	0x5c0000,  0x5d0000, 0x5e0000,  0x5f0000, 	 
	0x600000,  0x610000, 0x620000,  0x630000,	  
	0x640000,  0x650000, 0x660000,  0x670000,	  
	0x680000,  0x690000, 0x6a0000,  0x6b0000, 	 
	0x6c0000,  0x6d0000, 0x6e0000,  0x6f0000, 	 
	0x700000,  0x710000, 0x720000,  0x730000, 	  
	0x740000,  0x750000, 0x760000,  0x770000,	  
	0x780000,  0x790000, 0x7a0000,  0x7b0000, 	 
	0x7c0000,  0x7d0000, 0x7e0000,  0x7f0000,  
	
	0x7f2000,  0x7f4000, 0x7f6000,  0x7f8000, 	 
	0x7fa000,  0x7fc000, 0x7fe000 
	
};

static unsigned int mx64_bottom_flash_sectors[ 135 ] = 
{
	0x000000,  0x002000, 0x004000,  0x006000,
	0x008000,  0x00a000, 0x00c000,  0x00e000, 
	  
	0x010000,  0x020000, 0x030000,	  
	0x040000,  0x050000, 0x060000,  0x070000, 	 
	0x080000,  0x090000, 0x0a0000,  0x0b0000,	 
	0x0c0000,  0x0d0000, 0x0e0000,  0x0f0000, 	 
	0x100000,  0x110000, 0x120000,  0x130000, 	  
	0x140000,  0x150000, 0x160000,  0x170000,	  
	0x180000,  0x190000, 0x1a0000,  0x1b0000, 	 
	0x1c0000,  0x1d0000, 0x1e0000,  0x1f0000, 	 
	0x200000,  0x210000, 0x220000,  0x230000,	  
	0x240000,  0x250000, 0x260000,  0x270000,	  
	0x280000,  0x290000, 0x2a0000,  0x2b0000, 	 
	0x2c0000,  0x2d0000, 0x2e0000,  0x2f0000, 	 
	0x300000,  0x310000, 0x320000,  0x330000, 	  
	0x340000,  0x350000, 0x360000,  0x370000,	  
	0x380000,  0x390000, 0x3a0000,  0x3b0000, 	 
	0x3c0000,  0x3d0000, 0x3e0000,  0x3f0000,
	
	0x400000,  0x410000, 0x420000,  0x430000,	  
	0x440000,  0x450000, 0x460000,  0x470000, 	 
	0x480000,  0x490000, 0x4a0000,  0x4b0000,	 
	0x4c0000,  0x4d0000, 0x4e0000,  0x4f0000, 	 
	0x500000,  0x510000, 0x520000,  0x530000, 	  
	0x540000,  0x550000, 0x560000,  0x570000,	  
	0x580000,  0x590000, 0x5a0000,  0x5b0000, 	 
	0x5c0000,  0x5d0000, 0x5e0000,  0x5f0000, 	 
	0x600000,  0x610000, 0x620000,  0x630000,	  
	0x640000,  0x650000, 0x660000,  0x670000,	  
	0x680000,  0x690000, 0x6a0000,  0x6b0000, 	 
	0x6c0000,  0x6d0000, 0x6e0000,  0x6f0000, 	 
	0x700000,  0x710000, 0x720000,  0x730000, 	  
	0x740000,  0x750000, 0x760000,  0x770000,	  
	0x780000,  0x790000, 0x7a0000,  0x7b0000, 	 
	0x7c0000,  0x7d0000, 0x7e0000,  0x7f0000,  
	
	
};

static unsigned int mx128_top_flash_sectors[ 263 ] = 
{
	0x000000,  0x010000, 0x020000,  0x030000,	  
	0x040000,  0x050000, 0x060000,  0x070000, 	 
	0x080000,  0x090000, 0x0a0000,  0x0b0000,	 
	0x0c0000,  0x0d0000, 0x0e0000,  0x0f0000, 	 
	0x100000,  0x110000, 0x120000,  0x130000, 	  
	0x140000,  0x150000, 0x160000,  0x170000,	  
	0x180000,  0x190000, 0x1a0000,  0x1b0000, 	 
	0x1c0000,  0x1d0000, 0x1e0000,  0x1f0000, 	 
	0x200000,  0x210000, 0x220000,  0x230000,	  
	0x240000,  0x250000, 0x260000,  0x270000,	  
	0x280000,  0x290000, 0x2a0000,  0x2b0000, 	 
	0x2c0000,  0x2d0000, 0x2e0000,  0x2f0000, 	 
	0x300000,  0x310000, 0x320000,  0x330000, 	  
	0x340000,  0x350000, 0x360000,  0x370000,	  
	0x380000,  0x390000, 0x3a0000,  0x3b0000, 	 
	0x3c0000,  0x3d0000, 0x3e0000,  0x3f0000,
	
	0x400000,  0x410000, 0x420000,  0x430000,	  
	0x440000,  0x450000, 0x460000,  0x470000, 	 
	0x480000,  0x490000, 0x4a0000,  0x4b0000,	 
	0x4c0000,  0x4d0000, 0x4e0000,  0x4f0000, 	 
	0x500000,  0x510000, 0x520000,  0x530000, 	  
	0x540000,  0x550000, 0x560000,  0x570000,	  
	0x580000,  0x590000, 0x5a0000,  0x5b0000, 	 
	0x5c0000,  0x5d0000, 0x5e0000,  0x5f0000, 	 
	0x600000,  0x610000, 0x620000,  0x630000,	  
	0x640000,  0x650000, 0x660000,  0x670000,	  
	0x680000,  0x690000, 0x6a0000,  0x6b0000, 	 
	0x6c0000,  0x6d0000, 0x6e0000,  0x6f0000, 	 
	0x700000,  0x710000, 0x720000,  0x730000, 	  
	0x740000,  0x750000, 0x760000,  0x770000,	  
	0x780000,  0x790000, 0x7a0000,  0x7b0000, 	 
	0x7c0000,  0x7d0000, 0x7e0000,  0x7f0000, 
	
	0x800000,  0x810000, 0x820000,  0x830000,	  
	0x840000,  0x850000, 0x860000,  0x870000, 	 
	0x880000,  0x890000, 0x8a0000,  0x8b0000,	 
	0x8c0000,  0x8d0000, 0x8e0000,  0x8f0000, 	 
	0x900000,  0x910000, 0x920000,  0x930000, 	  
	0x940000,  0x950000, 0x960000,  0x970000,	  
	0x980000,  0x990000, 0x9a0000,  0x9b0000, 	 
	0x9c0000,  0x9d0000, 0x9e0000,  0x9f0000, 	 
	0xa00000,  0xa10000, 0xa20000,  0xa30000,	  
	0xa40000,  0xa50000, 0xa60000,  0xa70000,	  
	0xa80000,  0xa90000, 0xaa0000,  0xab0000, 	 
	0xac0000,  0xad0000, 0xae0000,  0xaf0000, 	 
	0xb00000,  0xb10000, 0xb20000,  0xb30000, 	  
	0xb40000,  0xb50000, 0xb60000,  0xb70000,	  
	0xb80000,  0xb90000, 0xba0000,  0xbb0000, 	 
	0xbc0000,  0xbd0000, 0xbe0000,  0xbf0000,
	
	0xc00000,  0xc10000, 0xc20000,  0xc30000,	  
	0xc40000,  0xc50000, 0xc60000,  0xc70000, 	 
	0xc80000,  0xc90000, 0xca0000,  0xcb0000,	 
	0xcc0000,  0xcd0000, 0xce0000,  0xcf0000, 	 
	0xd00000,  0xd10000, 0xd20000,  0xd30000, 	  
	0xd40000,  0xd50000, 0xd60000,  0xd70000,	  
	0xd80000,  0xd90000, 0xda0000,  0xdb0000, 	 
	0xdc0000,  0xdd0000, 0xde0000,  0xdf0000, 	 
	0xe00000,  0xe10000, 0xe20000,  0xe30000,	  
	0xe40000,  0xe50000, 0xe60000,  0xe70000,	  
	0xe80000,  0xe90000, 0xea0000,  0xeb0000, 	 
	0xec0000,  0xed0000, 0xee0000,  0xef0000, 	 
	0xf00000,  0xf10000, 0xf20000,  0xf30000, 	  
	0xf40000,  0xf50000, 0xf60000,  0xf70000,	  
	0xf80000,  0xf90000, 0xfa0000,  0xfb0000, 	 
	0xfc0000,  0xfd0000, 0xfe0000,  0xff0000,   
	
	0xff2000,  0xff4000, 0xff6000,  0xff8000, 	 
	0xffa000,  0xffc000, 0xffe000 
	
};

static unsigned int mx128_bottom_flash_sectors[ 263 ] = 
{
	0x000000,  0x002000, 0x004000,  0x006000,  
	0x008000,  0x00a000, 0x00c000,  0x00e000,
	0x010000,  0x020000, 0x030000,	  
	0x040000,  0x050000, 0x060000,  0x070000, 	 
	0x080000,  0x090000, 0x0a0000,  0x0b0000,	 
	0x0c0000,  0x0d0000, 0x0e0000,  0x0f0000, 	 
	0x100000,  0x110000, 0x120000,  0x130000, 	  
	0x140000,  0x150000, 0x160000,  0x170000,	  
	0x180000,  0x190000, 0x1a0000,  0x1b0000, 	 
	0x1c0000,  0x1d0000, 0x1e0000,  0x1f0000, 	 
	0x200000,  0x210000, 0x220000,  0x230000,	  
	0x240000,  0x250000, 0x260000,  0x270000,	  
	0x280000,  0x290000, 0x2a0000,  0x2b0000, 	 
	0x2c0000,  0x2d0000, 0x2e0000,  0x2f0000, 	 
	0x300000,  0x310000, 0x320000,  0x330000, 	  
	0x340000,  0x350000, 0x360000,  0x370000,	  
	0x380000,  0x390000, 0x3a0000,  0x3b0000, 	 
	0x3c0000,  0x3d0000, 0x3e0000,  0x3f0000,
	
	0x400000,  0x410000, 0x420000,  0x430000,	  
	0x440000,  0x450000, 0x460000,  0x470000, 	 
	0x480000,  0x490000, 0x4a0000,  0x4b0000,	 
	0x4c0000,  0x4d0000, 0x4e0000,  0x4f0000, 	 
	0x500000,  0x510000, 0x520000,  0x530000, 	  
	0x540000,  0x550000, 0x560000,  0x570000,	  
	0x580000,  0x590000, 0x5a0000,  0x5b0000, 	 
	0x5c0000,  0x5d0000, 0x5e0000,  0x5f0000, 	 
	0x600000,  0x610000, 0x620000,  0x630000,	  
	0x640000,  0x650000, 0x660000,  0x670000,	  
	0x680000,  0x690000, 0x6a0000,  0x6b0000, 	 
	0x6c0000,  0x6d0000, 0x6e0000,  0x6f0000, 	 
	0x700000,  0x710000, 0x720000,  0x730000, 	  
	0x740000,  0x750000, 0x760000,  0x770000,	  
	0x780000,  0x790000, 0x7a0000,  0x7b0000, 	 
	0x7c0000,  0x7d0000, 0x7e0000,  0x7f0000, 
	
	0x800000,  0x810000, 0x820000,  0x830000,	  
	0x840000,  0x850000, 0x860000,  0x870000, 	 
	0x880000,  0x890000, 0x8a0000,  0x8b0000,	 
	0x8c0000,  0x8d0000, 0x8e0000,  0x8f0000, 	 
	0x900000,  0x910000, 0x920000,  0x930000, 	  
	0x940000,  0x950000, 0x960000,  0x970000,	  
	0x980000,  0x990000, 0x9a0000,  0x9b0000, 	 
	0x9c0000,  0x9d0000, 0x9e0000,  0x9f0000, 	 
	0xa00000,  0xa10000, 0xa20000,  0xa30000,	  
	0xa40000,  0xa50000, 0xa60000,  0xa70000,	  
	0xa80000,  0xa90000, 0xaa0000,  0xab0000, 	 
	0xac0000,  0xad0000, 0xae0000,  0xaf0000, 	 
	0xb00000,  0xb10000, 0xb20000,  0xb30000, 	  
	0xb40000,  0xb50000, 0xb60000,  0xb70000,	  
	0xb80000,  0xb90000, 0xba0000,  0xbb0000, 	 
	0xbc0000,  0xbd0000, 0xbe0000,  0xbf0000,
	
	0xc00000,  0xc10000, 0xc20000,  0xc30000,	  
	0xc40000,  0xc50000, 0xc60000,  0xc70000, 	 
	0xc80000,  0xc90000, 0xca0000,  0xcb0000,	 
	0xcc0000,  0xcd0000, 0xce0000,  0xcf0000, 	 
	0xd00000,  0xd10000, 0xd20000,  0xd30000, 	  
	0xd40000,  0xd50000, 0xd60000,  0xd70000,	  
	0xd80000,  0xd90000, 0xda0000,  0xdb0000, 	 
	0xdc0000,  0xdd0000, 0xde0000,  0xdf0000, 	 
	0xe00000,  0xe10000, 0xe20000,  0xe30000,	  
	0xe40000,  0xe50000, 0xe60000,  0xe70000,	  
	0xe80000,  0xe90000, 0xea0000,  0xeb0000, 	 
	0xec0000,  0xed0000, 0xee0000,  0xef0000, 	 
	0xf00000,  0xf10000, 0xf20000,  0xf30000, 	  
	0xf40000,  0xf50000, 0xf60000,  0xf70000,	  
	0xf80000,  0xf90000, 0xfa0000,  0xfb0000, 	 
	0xfc0000,  0xfd0000, 0xfe0000,  0xff0000,   
	
	
	
	
};

static unsigned int sp128_flash_sectors[ 128 ] = 
{
	0x000000,  0x020000,  0x040000, 0x060000, 
	0x080000,  0x0a0000,  0x0c0000, 0x0e0000,
	0x100000,  0x120000,  0x140000, 0x160000, 
	0x180000,  0x1a0000,  0x1c0000, 0x1e0000,
	0x200000,  0x220000,  0x240000, 0x260000, 
	0x280000,  0x2a0000,  0x2c0000, 0x2e0000,
	0x300000,  0x320000,  0x340000, 0x360000, 
	0x380000,  0x3a0000,  0x3c0000, 0x3e0000,
	0x400000,  0x420000,  0x440000, 0x460000, 
	0x480000,  0x4a0000,  0x4c0000, 0x4e0000,
	0x500000,  0x520000,  0x540000, 0x560000, 
	0x580000,  0x5a0000,  0x5c0000, 0x5e0000,
	0x600000,  0x620000,  0x640000, 0x660000, 
	0x680000,  0x6a0000,  0x6c0000, 0x6e0000,
	0x700000,  0x720000,  0x740000, 0x760000, 
	0x780000,  0x7a0000,  0x7c0000, 0x7e0000,
	0x800000,  0x820000,  0x840000, 0x860000, 
	0x880000,  0x8a0000,  0x8c0000, 0x8e0000,
	0x900000,  0x920000,  0x940000, 0x960000, 
	0x980000,  0x9a0000,  0x9c0000, 0x9e0000,
	0xa00000,  0xa20000,  0xa40000, 0xa60000, 
	0xa80000,  0xaa0000,  0xac0000, 0xae0000,
	0xb00000,  0xb20000,  0xb40000, 0xb60000, 
	0xb80000,  0xba0000,  0xbc0000, 0xbe0000,
	0xc00000,  0xc20000,  0xc40000, 0xc60000, 
	0xc80000,  0xca0000,  0xcc0000, 0xce0000,
	0xd00000,  0xd20000,  0xd40000, 0xd60000, 
	0xd80000,  0xda0000,  0xdc0000, 0xde0000,
	0xe00000,  0xe20000,  0xe40000, 0xe60000, 
	0xe80000,  0xea0000,  0xec0000, 0xee0000,
	0xf00000,  0xf20000,  0xf40000, 0xf60000, 
	0xf80000,  0xfa0000,  0xfc0000, 0xfe0000
	
	
};


static p_device_type p_device[] = 
{
 {MXIC    ,  3,  MX29LV160C_BOTTOM  ,  mx16_bottom_flash_sectors  , 35     ,0x200000}  ,
 {MXIC    ,  3,  MX29LV160C_TOP     ,  mx16_top_flash_sectors     , 35     ,0x200000}  ,
 {MXIC    ,  1,  MX29LV320C_BOTTOM  ,  sp32_bottom_flash_sectors  , 71     ,0x400000}  ,
 {MXIC    ,  1,  MX29LV320C_TOP     ,  sp32_top_flash_sectors     , 71     ,0x400000}  ,
 {MXIC    ,  1,  MX29LV640B_BOTTOM  ,  mx64_bottom_flash_sectors  , 135    ,0x800000}  ,
 {MXIC    ,  1,  MX29LV640B_TOP     ,  mx64_top_flash_sectors     , 135    ,0x800000}  ,
 {MXIC    ,  3,  MX29LV320M_BOTTOM  ,  sp32_bottom_flash_sectors  , 71     ,0x400000}  ,
 {MXIC    ,  3,  MX29LV320M_TOP     ,  sp32_top_flash_sectors     , 71     ,0x400000}  ,
 {MXIC    ,  3,  MX29LV640M_BOTTOM  ,  mx64_bottom_flash_sectors  , 135    ,0x800000}  ,
 {MXIC    ,  3,  MX29LV640M_TOP     ,  mx64_top_flash_sectors     , 135    ,0x800000}  ,
 {MXIC    ,  3,  MX29LV128M_BOTTOM  ,  mx128_bottom_flash_sectors , 263    ,0x1000000} ,
 {MXIC    ,  3,  MX29LV128M_TOP     ,  mx128_top_flash_sectors    , 263    ,0x1000000} ,
 {MXIC    ,  1,  MX29LV128D_BOTTOM  ,  mx128_bottom_flash_sectors , 263    ,0x1000000} ,
 {MXIC    ,  1,  MX29LV128D_TOP     ,  mx128_top_flash_sectors    , 263    ,0x1000000} ,
 {SPANSION,  3,  S29AL016D_BOTTOM   ,   mx16_bottom_flash_sectors , 35     ,0x200000}  ,
 {SPANSION,  3,  S29AL016D_TOP      ,   mx16_top_flash_sectors    , 35     ,0x200000}  ,
 {SPANSION,  3,  S29GL64M_R4_BOTTOM ,  mx64_bottom_flash_sectors  , 135    ,0x800000}  ,
 {SPANSION,  3,  S29GL64M_R3_TOP    ,  mx64_top_flash_sectors     , 135    ,0x800000}  ,
 {SPANSION,  3,  S29GL32M_R4_BOTTOM ,  sp32_bottom_flash_sectors  , 71     ,0x400000}  ,
 {SPANSION,  3,  S29GL32M_R3_TOP    ,  sp32_top_flash_sectors     , 71     ,0x400000}  ,
 {SPANSION,  3,  S29GL128N          ,  sp128_flash_sectors        , 128    ,0x1000000} ,
 {ATMEL   ,  1,  AT49BV163A         ,  at16_bottom_flash_sectors  , 39     ,0x200000}  ,
 {ATMEL   ,  1,  AT49BV163AT        ,  at16_top_flash_sectors     , 39     ,0x200000}  ,
 {AMIC    ,  1,  A29L160A_BOTTOM    ,  mx16_bottom_flash_sectors  , 35     ,0x200000}  ,
 {AMIC    ,  1,  A29L160A_TOP       ,  mx16_top_flash_sectors     , 35     ,0x200000}  ,
 {EON     ,  1,  EN29LV640B_BOTTOM  ,  mx64_bottom_flash_sectors  , 135    ,0x800000}  ,
 {EON     ,  1,  EN29LV640B_TOP     ,  mx64_top_flash_sectors     , 135    ,0x800000}  ,
 {FUJITSU ,  1,  MBM29DL640E_TOP    ,  fujitsu64_top_flash_sectors, 142    ,0x800000}  ,
} ; 


#define DEV_SIZE_P	(sizeof(p_device)/sizeof(p_device_type))


/************************************************************************
 *  Public function
 ************************************************************************/
int do_erase_p(void  *dev,
               unsigned char* dest,
               unsigned int   rem_size);

int do_write_p(void *dev,
               unsigned char* array_ptr,
               unsigned char* dest,
               unsigned int   rem_size);

int do_identify_p(void **dev);

void do_init_p();

void do_exit_p();

#endif
