#! /usr/bin/perl

$file_start = 
"/************************************************************************
 *
 *  project_config.h
 *
 *  external parameters was included in this file
 * 
 *
 ************************************************************************/

#ifndef PROJECT_CONFIG_H
#define PROJECT_CONFIG_H
";
#remove this part since we should not include anything to project_config.h
#/************************************************************************
# *  Include files
# ************************************************************************/
#
##include <sysdefs.h>
#
#";

$file_end = "
#endif //#ifndef EXTERN_PARAM_H	
";




#################################################################

#check include file state and name
(-e $ARGV[1]) || die "error!! input file not exists\n";
($ARGV[1] =~ /.*inc\b/) || die "error!! input file is not a config file\n";
($ARGV[0] =~ /.*h\b/) || die "error!! output file is not a header file\n";

#open include config file and output 

print "Config convert to header file \n\n";


open (CONFIG_FILE1, "$ARGV[1]");
print "Input Config File     : "  . substr( $ARGV[1], rindex($ARGV[1], "/") + 1) . "\n";

open (CONFIG_FILE2, "$ARGV[2]");
print "Input Logo1 Info File : "  . substr( $ARGV[2], rindex($ARGV[2], "/") + 1) . "\n";

if(defined $ARGV[3])
{
	open (CONFIG_FILE3, "$ARGV[3]");
	print "Input Logo2 Info File : "  . substr( $ARGV[3], rindex($ARGV[3], "/") + 1) . "\n";
}

if(defined $ARGV[4])
{
	open (CONFIG_FILE4, "$ARGV[4]");
	print "Input Logo3 Info File : "  . substr( $ARGV[4], rindex($ARGV[4], "/") + 1) . "\n";
}

open (HEADER_FILE, ">$ARGV[0]");
print "Output Header File    : "  . substr( $ARGV[0], rindex($ARGV[0], "/") + 1) . "\n";

print HEADER_FILE $file_start;

$tmp1 = 0;
$tmp2 = 0;
$dram_block = 0;
$dram_number  = 0;
$dram_size = 0;

while (<CONFIG_FILE1>){
	
	# display segment header
	if (/^# .*/)
	{
		s/^# /\/\//;
		print HEADER_FILE;
	}

	# Board setup segment
	if (/^Board/)
	{
		if (/^Board_DRAM_Block/)
		{
			($tmp1, $tmp2, $dram_block) = split(/ +/);
			chomp($dram_block);
		}
		
		if (/^Board_DRAM_Number/)
		{
			($tmp1, $tmp2, $dram_number) = split(/ +/);
			chomp($dram_number);
		}
		
		if ((/Size/) || (/Number/) || (/Block/))
		{
			s/ *= */			/; # replace with three TAB space
		}
		else
		{
			s/ *= */_/;
		}
		print HEADER_FILE "#define " . $_;
		
		if (($dram_number != 0) && ($dram_block != 0))
		{
			$dram_size = $dram_block * $dram_number;			
			print HEADER_FILE "#define Board_DRAM_Size				$dram_size\n";
			
			$dram_number = ($dram_block = 0);
		}
	}

	# Cmd setup segment
	if (/^Cmd/)
	{
		s/ *= */_/;
		print HEADER_FILE "#define " . $_;
	}
	
	# GPIO and Param setup segment
	if ((/^GPIO/) || (/^Param/))
	{
		s/ *= */			/; # replace with three TAB space
		print HEADER_FILE "#define " . $_;
	}

	# Logo setup segment
	if (/^Logo/)
	{
		if ((/Source/) || (/Type/))
		{
			s/ *= */_/;
		}
		else
		{
			s/ *= */			/; # replace with three TAB space
		}

		print HEADER_FILE "#define " . $_;
		
		if (/Logo_Source_FLASH/)
		{
			while (<CONFIG_FILE2>){
				s/ *= */			/; # replace with three TAB space
				print HEADER_FILE "#define " . $_;
			}
		}
		
		if (/Logo2_Source_FLASH/)
		{	
			while (<CONFIG_FILE3>)
			{
				s/ *= */			/; # replace with three TAB space
				s/Logo/Logo2/;
				print HEADER_FILE "#define " . $_;
			}
		}
		
		if (/Logo3_Source_FLASH/)
		{	
			while (<CONFIG_FILE4>)
			{
				s/ *= */			/; # replace with three TAB space
				s/Logo/Logo3/;
				print HEADER_FILE "#define " . $_;
			}
		}
	}

	# Rescue and Linux setup segment
	if ((/^Rescue/) || (/^Linux/))
	{
		if (/Source/)
		{
			s/ *= */_/;
		}
		else
		{
			s/ *= */			/; # replace with three TAB space
		}
		print HEADER_FILE "#define " . $_;
	}
	
	# Shell setup segment
	if (/^Shell/)
	{
		if (/Enable/)
		{
			s/ *= */_/;
		}
		else
		{
			s/ *= */			/; # replace with three TAB space
		}
		print HEADER_FILE "#define " . $_;
	}
	
	#Config setup segment
	if (/^Config/)
	{
	if ((/Prog/) || (/Position/) || (/Evaluation/) || (/Cache/))
		{
			s/ *= */_/;
		}
		else
		{
			s/ *= */			/; # replace with three TAB space
		}
		print HEADER_FILE "#define " . $_;
		
	}
	
	#User_Defined setup segment
	if (/^User_Defined/)
	{
		s/User_Defined *= *//;
		print HEADER_FILE "#define " . $_;
		
	}
	
}


print HEADER_FILE $file_end;

close (HEADER_FILE);
close (CONFIG_FILE1);
close (CONFIG_FILE2);
if(defined $ARGV[3])
{
	close (CONFIG_FILE3);
}
if(defined $ARGV[4])
{
	close (CONFIG_FILE4);
}


print "convert config file to header file: done \n";



#while (defined($textd = <WORDLIST>)){
#	if($textd[0] ne "#')
#		print "$textd";
#}


#close(INC)


#while (<>) {
#    print $_;
#}
