#include "mdct.h"
#include <stdio.h>
#include <stdlib.h>
extern FILE *fpny;



#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXc16[16] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xc16") =
#else
DATA_TYPE VorbisdecXc16[16] =
#endif /* RADIAX && AE && DMA */
{
0x7ffd885a, 0x7f3857f6, 0x7d3980ec, 0x7a05eead, 0x75a585cf, 0x7023109a, 0x698c246c, 0x61f1003f, 
0x59646498, 0x4ffb654d, 0x45cd358f, 0x3af2eeb7, 0x2f875262, 0x23a6887f, 0x176dd9de, 0x0afb6805 
};

#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXc32[32] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xc32") =
#else
DATA_TYPE VorbisdecXc32[32] =
#endif /* RADIAX && AE && DMA */
{
0x7fff6216, 0x7fce0c3e, 0x7f4de451, 0x7e7f3957, 0x7d628ac6, 0x7bf88830, 0x7a4210d8, 0x78403329, 
0x75f42c0b, 0x735f6626, 0x708378ff, 0x6d6227fa, 0x69fd614a, 0x66573cbb, 0x6271fa69, 0x5e50015d, 
0x59f3de12, 0x556040e2, 0x5097fc5e, 0x4b9e0390, 0x46756828, 0x4121589b, 0x3ba51e29, 0x36041ad9, 
0x3041c761, 0x2a61b101, 0x24677758, 0x1e56ca1e, 0x183366e9, 0x120116d5, 0x0bc3ac35, 0x057f0035
};

#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXc64[64] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xc64") =
#else
DATA_TYPE VorbisdecXc64[64] =
#endif /* RADIAX && AE && DMA */
{
0x7fffd886, 0x7ff38274, 0x7fd37153, 0x7f9faa15, 0x7f5834b7, 0x7efd1c3c, 0x7e8e6eb2, 0x7e0c3d29, 
0x7d769bb5, 0x7ccda169, 0x7c116853, 0x7b420d7a, 0x7a5fb0d8, 0x796a7554, 0x786280bf, 0x7747fbce, 
0x761b1211, 0x74dbf1ef, 0x738acc9e, 0x7227d61c, 0x70b34525, 0x6f2d532c, 0x6d963c54, 0x6bee3f62, 
0x6a359db9, 0x686c9b4b, 0x66937e91, 0x64aa907f, 0x62b21c7b, 0x60aa7050, 0x5e93dc1f, 0x5c6eb258, 
0x5a3b47ab, 0x57f9f2f8, 0x55ab0d46, 0x534ef1b5, 0x50e5fd6d, 0x4e708f8f, 0x4bef092d, 0x4961cd33, 
0x46c9405c, 0x4425c923, 0x4177cfb1, 0x3ebfbdcd, 0x3bfdfecd, 0x3932ff87, 0x365f2e3b, 0x3382fa88, 
0x309ed556, 0x2db330c7, 0x2ac08026, 0x27c737d3, 0x24c7cd33, 0x21c2b69c, 0x1eb86b46, 0x1ba96335, 
0x18961728, 0x157f0086, 0x1264994e, 0x0f475bff, 0x0c27c389, 0x09064b3a, 0x05e36ea9, 0x02bfa9a4
};

#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXc128[128] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xc128") =
#else
DATA_TYPE VorbisdecXc128[128] =
#endif /* RADIAX && AE && DMA */
{
0x7ffff621, 0x7ffce093, 0x7ff4dbd9, 0x7fe7e841, 0x7fd6064c, 0x7fbf36aa, 0x7fa37a3c, 0x7f82d214, 
0x7f5d3f75, 0x7f32c3d1, 0x7f0360cb, 0x7ecf1837, 0x7e95ec1a, 0x7e57dea7, 0x7e14f242, 0x7dcd2981, 
0x7d808728, 0x7d2f0e2b, 0x7cd8c1ae, 0x7c7da505, 0x7c1dbbb3, 0x7bb9096b, 0x7b4f920e, 0x7ae159ae, 
0x7a6e648a, 0x79f6b711, 0x797a55e0, 0x78f945c3, 0x78738bb3, 0x77e92cd9, 0x775a2e89, 0x76c69647, 
0x762e69c4, 0x7591aedd, 0x74f06b9e, 0x744aa63f, 0x73a06522, 0x72f1aed9, 0x723e8a20, 0x7186fdde, 
0x70cb1128, 0x700acb3c, 0x6f463383, 0x6e7d5193, 0x6db02d29, 0x6cdece2f, 0x6c093cb6, 0x6b2f80fb, 
0x6a51a361, 0x696fac78, 0x6889a4f6, 0x679f95b7, 0x66b187c3, 0x65bf8447, 0x64c99498, 0x63cfc231, 
0x62d216b3, 0x61d09be5, 0x60cb5bb7, 0x5fc26038, 0x5eb5b3a2, 0x5da5604f, 0x5c9170bf, 0x5b79ef96, 
0x5a5ee79a, 0x594063b5, 0x581e6ef1, 0x56f9147e, 0x55d05faa, 0x54a45be6, 0x537514c2, 0x524295f0, 
0x510ceb40, 0x4fd420a4, 0x4e984229, 0x4d595bfe, 0x4c177a6e, 0x4ad2a9e2, 0x498af6df, 0x48406e08, 
0x46f31c1a, 0x45a30df0, 0x4450507e, 0x42faf0d4, 0x41a2fc1a, 0x40487f94, 0x3eeb889c, 0x3d8c24a8, 
0x3c2a6142, 0x3ac64c0f, 0x395ff2c9, 0x37f76341, 0x368cab5c, 0x351fd918, 0x33b0fa84, 0x32401dc6, 
0x30cd5115, 0x2f58a2be, 0x2de2211e, 0x2c69daa6, 0x2aefddd8, 0x29743946, 0x27f6fb92, 0x26783370, 
0x24f7efa2, 0x23763ef7, 0x21f3304f, 0x206ed295, 0x1ee934c3, 0x1d6265dd, 0x1bda74f6, 0x1a517128, 
0x18c7699b, 0x173c6d80, 0x15b08c12, 0x1423d492, 0x1296564d, 0x11082096, 0x0f7942c7, 0x0de9cc40, 
0x0c59cc68, 0x0ac952aa, 0x09386e78, 0x07a72f45, 0x0615a48b, 0x0483ddc3, 0x02f1ea6c, 0x015fda03 
};

#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXc256[256] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xc256") =
#else
DATA_TYPE VorbisdecXc256[256] =
#endif /* RADIAX && AE && DMA */
{
0x7ffffd88, 0x7fff3824, 0x7ffd36ee, 0x7ff9f9ec, 0x7ff58125, 0x7fefcca4, 0x7fe8dc78, 0x7fe0b0b1, 
0x7fd74964, 0x7fcca6a7, 0x7fc0c896, 0x7fb3af4e, 0x7fa55aee, 0x7f95cb9a, 0x7f850179, 0x7f72fcb4, 
0x7f5fbd77, 0x7f4b43f2, 0x7f359057, 0x7f1ea2dc, 0x7f067bba, 0x7eed1b2c, 0x7ed28171, 0x7eb6aeca, 
0x7e99a37c, 0x7e7b5fce, 0x7e5be40c, 0x7e3b3083, 0x7e194584, 0x7df62362, 0x7dd1ca75, 0x7dac3b15, 
0x7d85759f, 0x7d5d7a74, 0x7d3449f5, 0x7d09e489, 0x7cde4a98, 0x7cb17c8d, 0x7c837ad8, 0x7c5445e9, 
0x7c23de35, 0x7bf24434, 0x7bbf7860, 0x7b8b7b36, 0x7b564d36, 0x7b1feee5, 0x7ae860c7, 0x7aafa367, 
0x7a75b74f, 0x7a3a9d0f, 0x79fe5539, 0x79c0e062, 0x79823f20, 0x79427210, 0x790179cd, 0x78bf56f9, 
0x787c0a36, 0x7837942b, 0x77f1f581, 0x77ab2ee2, 0x776340ff, 0x771a2c88, 0x76cff232, 0x768492b4, 
0x76380ec8, 0x75ea672a, 0x759b9c9b, 0x754bafdc, 0x74faa1b3, 0x74a872e8, 0x74552446, 0x7400b69a, 
0x73ab2ab4, 0x73548168, 0x72fcbb8c, 0x72a3d9f7, 0x7249dd86, 0x71eec716, 0x71929789, 0x71354fc0, 
0x70d6f0a4, 0x70777b1c, 0x7016f014, 0x6fb5507a, 0x6f529d40, 0x6eeed758, 0x6e89ffb9, 0x6e24175c, 
0x6dbd1f3c, 0x6d551858, 0x6cec03af, 0x6c81e245, 0x6c16b521, 0x6baa7d49, 0x6b3d3bcb, 0x6acef1b2, 
0x6a5fa010, 0x69ef47f6, 0x697dea7b, 0x690b88b5, 0x689823bf, 0x6823bcb7, 0x67ae54ba, 0x6737ecea, 
0x66c0866d, 0x66482267, 0x65cec204, 0x6554666d, 0x64d910d1, 0x645cc260, 0x63df7c4d, 0x63613fcd, 
0x62e20e17, 0x6261e866, 0x61e0cff5, 0x615ec603, 0x60dbcbd1, 0x6057e2a2, 0x5fd30bbc, 0x5f4d4865, 
0x5ec699e9, 0x5e3f0194, 0x5db680b4, 0x5d2d189a, 0x5ca2ca99, 0x5c179806, 0x5b8b8239, 0x5afe8a8b, 
0x5a70b258, 0x59e1faff, 0x595265df, 0x58c1f45b, 0x5830a7d6, 0x579e81b8, 0x570b8369, 0x5677ae54, 
0x55e303e6, 0x554d858d, 0x54b734ba, 0x542012e1, 0x53882175, 0x52ef61ee, 0x5255d5c5, 0x51bb7e75, 
0x51205d7b, 0x50847454, 0x4fe7c483, 0x4f4a4f89, 0x4eac16eb, 0x4e0d1c30, 0x4d6d60df, 0x4ccce684, 
0x4c2baea9, 0x4b89badd, 0x4ae70caf, 0x4a43a5b0, 0x499f8774, 0x48fab391, 0x48552b9b, 0x47aef12c, 
0x470805df, 0x46606b4e, 0x45b82318, 0x450f2edb, 0x44659039, 0x43bb48d4, 0x43105a50, 0x4264c653, 
0x41b88e84, 0x410bb48c, 0x405e3a16, 0x3fb020ce, 0x3f016a61, 0x3e52187f, 0x3da22cd7, 0x3cf1a91c, 
0x3c408f03, 0x3b8ee03e, 0x3adc9e86, 0x3a29cb91, 0x39766919, 0x38c278d9, 0x380dfc8d, 0x3758f5f2, 
0x36a366c6, 0x35ed50c9, 0x3536b5be, 0x347f9766, 0x33c7f785, 0x330fd7e1, 0x32573a3f, 0x319e2067, 
0x30e48c22, 0x302a7f3a, 0x2f6ffb7a, 0x2eb502ae, 0x2df996a3, 0x2d3db928, 0x2c816c0c, 0x2bc4b120, 
0x2b078a36, 0x2a49f920, 0x298bffb2, 0x28cd9fc1, 0x280edb23, 0x274fb3ae, 0x26902b39, 0x25d0439f, 
0x250ffeb7, 0x244f5e5c, 0x238e646a, 0x22cd12bd, 0x220b6b32, 0x21496fa7, 0x208721f9, 0x1fc4840a, 
0x1f0197b8, 0x1e3e5ee5, 0x1d7adb73, 0x1cb70f43, 0x1bf2fc3a, 0x1b2ea43a, 0x1a6a0929, 0x19a52ceb, 
0x18e01167, 0x181ab881, 0x17552422, 0x168f5632, 0x15c95097, 0x1503153a, 0x143ca605, 0x137604e2, 
0x12af33ba, 0x11e83478, 0x11210907, 0x1059b352, 0x0f923546, 0x0eca90ce, 0x0e02c7d7, 0x0d3adc4e, 
0x0c72d020, 0x0baaa53b, 0x0ae25d8d, 0x0a19fb04, 0x09517f8f, 0x0888ed1b, 0x07c04598, 0x06f78af6, 
0x062ebf22, 0x0565e40d, 0x049cfba7, 0x03d407df, 0x030b0aa4, 0x024205e8, 0x0178fb99, 0x00afeda8 
};

#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXs16[16] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xs16") =
#else
DATA_TYPE VorbisdecXs16[16] =
#endif /* RADIAX && AE && DMA */
{
0x01921d20, 0x0e1bc2e4, 0x1a82a026, 0x26a82186, 0x326e54c7, 0x3db832a6, 0x4869e665, 0x5269126e, 
0x5b9d1154, 0x63ef3290, 0x6b4af279, 0x719e2cd2, 0x76d94989, 0x7aef6323, 0x7dd6668f, 0x7f872bf3 
};

#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXs32[32] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xs32") =
#else
DATA_TYPE VorbisdecXs32[32] =
#endif /* RADIAX && AE && DMA */
{
0x00c90f88, 0x0710a345, 0x0d53db92, 0x138edbb1, 0x19bdcbf3, 0x1fdcdc1b, 0x25e845b6, 0x2bdc4e6f, 
0x31b54a5e, 0x376f9e46, 0x3d07c1d6, 0x427a41d0, 0x47c3c22f, 0x4ce10034, 0x51ced46e, 0x568a34a9, 
0x5b1035cf, 0x5f5e0db3, 0x637114cc, 0x6746c7d8, 0x6adcc964, 0x6e30e34a, 0x71410805, 0x740b53fb, 
0x768e0ea6, 0x78c7aba2, 0x7ab6cba4, 0x7c5a3d50, 0x7db0fdf8, 0x7eba3a39, 0x7f754e80, 0x7fe1c76b 
};

#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXs64[64] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xs64") =
#else
DATA_TYPE VorbisdecXs64[64] =
#endif /* RADIAX && AE && DMA */
{
0x006487e3, 0x0388a9ea, 0x06ac406f, 0x09cecf89, 0x0cefdb76, 0x100ee8ad, 0x132b7bf9, 0x16451a83, 
0x195b49ea, 0x1c6d9053, 0x1f7b7481, 0x22847de0, 0x2588349d, 0x288621b9, 0x2b7dcf17, 0x2e6ec792, 
0x3158970e, 0x343aca87, 0x3714f02a, 0x39e6975e, 0x3caf50da, 0x3f6eaeb8, 0x42244481, 0x44cfa740, 
0x47706d93, 0x4a062fbd, 0x4c9087b1, 0x4f0f1126, 0x518169a5, 0x53e73097, 0x56400758, 0x588b9140, 
0x5ac973b5, 0x5cf95638, 0x5f1ae274, 0x612dc447, 0x6331a9d4, 0x6526438f, 0x670b4444, 0x68e06129, 
0x6aa551e9, 0x6c59d0a9, 0x6dfd9a1c, 0x6f906d84, 0x71120cc5, 0x72823c67, 0x73e0c3a3, 0x752d6c6c, 
0x76680376, 0x7790583e, 0x78a63d11, 0x79a98715, 0x7a9a0e50, 0x7b77ada8, 0x7c4242f2, 0x7cf9aef0, 
0x7d9dd55a, 0x7e2e9cdf, 0x7eabef2c, 0x7f15b8ee, 0x7f6be9d4, 0x7fae7495, 0x7fdd4eec, 0x7ff871a2
};

#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXs128[128] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xs128") =
#else
DATA_TYPE VorbisdecXs128[128] =
#endif /* RADIAX && AE && DMA */
{
0x003243f5, 0x01c45ffe, 0x03566a96, 0x04e8543e, 0x067a0d76, 0x080b86c2, 0x099cb0a7, 0x0b2d7baf, 
0x0cbdd865, 0x0e4db75b, 0x0fdd0926, 0x116bbe60, 0x12f9c7aa, 0x148715ae, 0x16139918, 0x179f429f, 
0x192a0304, 0x1ab3cb0d, 0x1c3c8b8c, 0x1dc4355e, 0x1f4ab968, 0x20d0089c, 0x225413f8, 0x23d6cc87, 
0x2558235f, 0x26d809a5, 0x2856708d, 0x29d34958, 0x2b4e8558, 0x2cc815ee, 0x2e3fec8b, 0x2fb5fab2, 
0x312a31f8, 0x329c8402, 0x340ce28b, 0x357b3f5d, 0x36e78c5b, 0x3851bb77, 0x39b9bebc, 0x3b1f8848, 
0x3c830a50, 0x3de4371f, 0x3f430119, 0x409f5ab6, 0x41f93689, 0x4350873c, 0x44a53f93, 0x45f7526b, 
0x4746b2bc, 0x48935397, 0x49dd282a, 0x4b2423be, 0x4c6839b7, 0x4da95d96, 0x4ee782fb, 0x50229da1, 
0x515aa162, 0x528f8238, 0x53c13439, 0x54efab9c, 0x561adcb9, 0x5742bc06, 0x58673e1b, 0x598857b2, 
0x5aa5fda5, 0x5bc024f0, 0x5cd6c2b5, 0x5de9cc33, 0x5ef936d1, 0x6004f819, 0x610d05b7, 0x6211557e, 
0x6311dd64, 0x640e9386, 0x65076e25, 0x65fc63a9, 0x66ed6aa1, 0x67da79c3, 0x68c387e9, 0x69a88c19, 
0x6a897d7d, 0x6b66536b, 0x6c3f055d, 0x6d138afb, 0x6de3dc11, 0x6eaff099, 0x6f77c0b3, 0x703b44ad, 
0x70fa74fc, 0x71b54a41, 0x726bbd48, 0x731dc70a, 0x73cb60a8, 0x74748371, 0x751928e0, 0x75b94a9c, 
0x7654e279, 0x76ebea77, 0x777e5cc3, 0x780c33b8, 0x789569df, 0x7919f9ec, 0x7999dec4, 0x7a151378, 
0x7a8b9348, 0x7afd59a4, 0x7b6a6227, 0x7bd2a89e, 0x7c362904, 0x7c94df83, 0x7ceec873, 0x7d43e05e, 
0x7d9423fc, 0x7ddf9034, 0x7e26221f, 0x7e67d703, 0x7ea4ac58, 0x7edc9fc6, 0x7f0faf25, 0x7f3dd87c, 
0x7f671a05, 0x7f8b7227, 0x7faadf7c, 0x7fc560cf, 0x7fdaf519, 0x7feb9b85, 0x7ff75370, 0x7ffe1c65
};

#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXs256[256] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xs256") =
#else
DATA_TYPE VorbisdecXs256[256] =
#endif /* RADIAX && AE && DMA */
{
0x001921fb, 0x00e23160, 0x01ab3e97, 0x027447b0, 0x033d4abb, 0x040645c7, 0x04cf36e5, 0x05981c26, 
0x0660f398, 0x0729bb4e, 0x07f27157, 0x08bb13c5, 0x0983a0a7, 0x0a4c1610, 0x0b147211, 0x0bdcb2bb, 
0x0ca4d620, 0x0d6cda53, 0x0e34bd66, 0x0efc7d6b, 0x0fc41876, 0x108b8c9b, 0x1152d7ed, 0x1219f880, 
0x12e0ec6a, 0x13a7b1bf, 0x146e4694, 0x1534a901, 0x15fad71b, 0x16c0cef9, 0x17868eb3, 0x184c1461, 
0x19115e1c, 0x19d669fc, 0x1a9b361d, 0x1b5fc097, 0x1c240786, 0x1ce80906, 0x1dabc334, 0x1e6f342c, 
0x1f325a0b, 0x1ff532f2, 0x20b7bcfe, 0x2179f64f, 0x223bdd08, 0x22fd6f48, 0x23beab33, 0x247f8eec, 
0x25401896, 0x26004657, 0x26c01655, 0x277f86b5, 0x283e95a1, 0x28fd4140, 0x29bb87bd, 0x2a796740, 
0x2b36ddf7, 0x2bf3ea0d, 0x2cb089b1, 0x2d6cbb10, 0x2e287c5a, 0x2ee3cbc1, 0x2f9ea775, 0x30590dab, 
0x3112fc95, 0x31cc7269, 0x32856d5e, 0x333debab, 0x33f5eb89, 0x34ad6b32, 0x356468e2, 0x361ae2d3, 
0x36d0d746, 0x37864477, 0x383b28a9, 0x38ef821c, 0x39a34f13, 0x3a568dd4, 0x3b093ca3, 0x3bbb59c7, 
0x3c6ce38a, 0x3d1dd835, 0x3dce3614, 0x3e7dfb73, 0x3f2d26a0, 0x3fdbb5ec, 0x4089a7a8, 0x4136fa27, 
0x41e3abbc, 0x428fbabe, 0x433b2585, 0x43e5ea68, 0x449007c4, 0x45397bf4, 0x45e24556, 0x468a624a, 
0x4731d131, 0x47d8906d, 0x487e9e64, 0x4923f97b, 0x49c8a01b, 0x4a6c90ad, 0x4b0fc99d, 0x4bb24958, 
0x4c540e4e, 0x4cf516ee, 0x4d9561ac, 0x4e34ecfc, 0x4ed3b755, 0x4f71bf2e, 0x500f0302, 0x50ab814d, 
0x5147388c, 0x51e22740, 0x527c4bea, 0x5315a50e, 0x53ae3131, 0x5445eedb, 0x54dcdc96, 0x5572f8ed, 
0x5608426e, 0x569cb7a8, 0x5730572e, 0x57c31f92, 0x58550f6c, 0x58e62552, 0x59765fde, 0x5a05bdae, 
0x5a943d5e, 0x5b21dd90, 0x5bae9ce7, 0x5c3a7a05, 0x5cc57394, 0x5d4f883b, 0x5dd8b6a7, 0x5e60fd84, 
0x5ee85b82, 0x5f6ecf53, 0x5ff457ad, 0x6078f344, 0x60fca0d2, 0x617f5f12, 0x62012cc2, 0x628208a1, 
0x6301f171, 0x6380e5f6, 0x63fee4f8, 0x647bed3f, 0x64f7fd98, 0x657314cf, 0x65ed31b5, 0x6666531d, 
0x66de77dc, 0x67559eca, 0x67cbc6c0, 0x6840ee9b, 0x68b5153a, 0x6928397e, 0x699a5a4c, 0x6a0b7689, 
0x6a7b8d1e, 0x6aea9cf8, 0x6b58a503, 0x6bc5a431, 0x6c319975, 0x6c9c83c3, 0x6d066215, 0x6d6f3365, 
0x6dd6f6b1, 0x6e3daaf8, 0x6ea34f3d, 0x6f07e285, 0x6f6b63d8, 0x6fcdd241, 0x702f2ccd, 0x708f728b, 
0x70eea28e, 0x714cbbeb, 0x71a9bdba, 0x7205a716, 0x7260771b, 0x72ba2cea, 0x7312c7a5, 0x736a4671, 
0x73c0a878, 0x7415ece2, 0x746a12df, 0x74bd199f, 0x750f0054, 0x755fc635, 0x75af6a7b, 0x75fdec60, 
0x764b4b23, 0x76978605, 0x76e29c4b, 0x772c8d3a, 0x7775581d, 0x77bcfc3f, 0x780378f1, 0x7848cd83, 
0x788cf94c, 0x78cffba3, 0x7911d3e2, 0x79528167, 0x79920392, 0x79d059c8, 0x7a0d836d, 0x7a497feb, 
0x7a844eae, 0x7abdef25, 0x7af660c2, 0x7b2da2fa, 0x7b63b543, 0x7b989719, 0x7bcc47fa, 0x7bfec765, 
0x7c3014de, 0x7c602fec, 0x7c8f1817, 0x7cbcccec, 0x7ce94dfb, 0x7d149ad5, 0x7d3eb30f, 0x7d679642, 
0x7d8f4409, 0x7db5bc02, 0x7ddafdce, 0x7dff0911, 0x7e21dd73, 0x7e437a9c, 0x7e63e03b, 0x7e830dff, 
0x7ea1039b, 0x7ebdc0c6, 0x7ed94538, 0x7ef390ae, 0x7f0ca2e7, 0x7f247ba5, 0x7f3b1aad, 0x7f507fc7, 
0x7f64aabf, 0x7f779b62, 0x7f895182, 0x7f99ccf4, 0x7fa90d8e, 0x7fb7132b, 0x7fc3dda9, 0x7fcf6ce8, 
0x7fd9c0ca, 0x7fe2d938, 0x7feab61a, 0x7ff1575d, 0x7ff6bcf0, 0x7ffae6c7, 0x7ffdd4d7, 0x7fff8719
};

#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXc512[512] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xc512") =
#else
DATA_TYPE VorbisdecXc512[512] = 
#endif /* RADIAX && AE && DMA */
{
/* IMDCT pre and post twiddle cos() table (N/4=512) */
    0x7fffff62,0x7fffce09,0x7fff4dbb,0x7ffe7e79,0x7ffd6042,0x7ffbf319,0x7ffa36fc,0x7ff82bef,
    0x7ff5d1f1,0x7ff32905,0x7ff0312c,0x7fecea67,0x7fe954ba,0x7fe57025,0x7fe13cac,0x7fdcba51,
    0x7fd7e917,0x7fd2c900,0x7fcd5a11,0x7fc79c4b,0x7fc18fb4,0x7fbb344e,0x7fb48a1e,0x7fad9127,
    0x7fa6496e,0x7f9eb2f8,0x7f96cdc9,0x7f8e99e6,0x7f861753,0x7f7d4617,0x7f742637,0x7f6ab7b8,
    0x7f60faa0,0x7f56eef5,0x7f4c94be,0x7f41ec01,0x7f36f4c3,0x7f2baf0d,0x7f201ae5,0x7f143852,
    0x7f08075c,0x7efb8809,0x7eeeba62,0x7ee19e6f,0x7ed43438,0x7ec67bc5,0x7eb8751e,0x7eaa204c,
    0x7e9b7d58,0x7e8c8c4b,0x7e7d4d2f,0x7e6dc00c,0x7e5de4ec,0x7e4dbbd9,0x7e3d44dd,0x7e2c8002,
    0x7e1b6d53,0x7e0a0cd9,0x7df85ea0,0x7de662b3,0x7dd4191d,0x7dc181e8,0x7dae9d21,0x7d9b6ad3,
    0x7d87eb0a,0x7d741dd2,0x7d600338,0x7d4b9b46,0x7d36e60b,0x7d21e393,0x7d0c93eb,0x7cf6f720,
    0x7ce10d3f,0x7ccad656,0x7cb45272,0x7c9d81a3,0x7c8663f4,0x7c6ef976,0x7c574236,0x7c3f3e42,
    0x7c26edab,0x7c0e507e,0x7bf566cb,0x7bdc30a1,0x7bc2ae10,0x7ba8df28,0x7b8ec3f8,0x7b745c91,
    0x7b59a902,0x7b3ea95d,0x7b235db2,0x7b07c612,0x7aebe28d,0x7acfb336,0x7ab3381d,0x7a967153,
    0x7a795eec,0x7a5c00f9,0x7a3e578b,0x7a2062b5,0x7a02228a,0x79e3971c,0x79c4c07e,0x79a59ec3,
    0x798631ff,0x79667a44,0x794677a6,0x79262a3a,0x79059212,0x78e4af44,0x78c381e2,0x78a20a03,
    0x788047ba,0x785e3b1c,0x783be43e,0x78194336,0x77f65819,0x77d322fc,0x77afa3f5,0x778bdb19,
    0x7767c880,0x77436c40,0x771ec66e,0x76f9d721,0x76d49e70,0x76af1c72,0x7689513f,0x76633ced,
    0x763cdf94,0x7616394c,0x75ef4a2c,0x75c8124d,0x75a091c6,0x7578c8b0,0x7550b725,0x75285d3b,
    0x74ffbb0d,0x74d6d0b2,0x74ad9e46,0x748423e0,0x745a619b,0x74305790,0x740605d9,0x73db6c91,
    0x73b08bd1,0x738563b5,0x7359f456,0x732e3dcf,0x7302403c,0x72d5fbb7,0x72a9705c,0x727c9e47,
    0x724f8593,0x7222265b,0x71f480bc,0x71c694d2,0x719862b9,0x7169ea8f,0x713b2c6e,0x710c2875,
    0x70dcdec0,0x70ad4f6d,0x707d7a98,0x704d6060,0x701d00e1,0x6fec5c3b,0x6fbb728a,0x6f8a43ed,
    0x6f58d082,0x6f271868,0x6ef51bbe,0x6ec2daa2,0x6e905534,0x6e5d8b91,0x6e2a7ddb,0x6df72c30,
    0x6dc396b0,0x6d8fbd7a,0x6d5ba0b0,0x6d274070,0x6cf29cdc,0x6cbdb613,0x6c888c36,0x6c531f67,
    0x6c1d6fc6,0x6be77d74,0x6bb14892,0x6b7ad142,0x6b4417a6,0x6b0d1bdf,0x6ad5de0f,0x6a9e5e58,
    0x6a669cdd,0x6a2e99c0,0x69f65523,0x69bdcf29,0x698507f6,0x694bffab,0x6912b66c,0x68d92c5d,
    0x689f61a1,0x6865565c,0x682b0ab1,0x67f07ec5,0x67b5b2bb,0x677aa6b8,0x673f5ae0,0x6703cf58,
    0x66c80445,0x668bf9cb,0x664fb010,0x66132738,0x65d65f69,0x659958c9,0x655c137d,0x651e8faa,
    0x64e0cd78,0x64a2cd0c,0x64648e8c,0x6426121e,0x63e757ea,0x63a86015,0x63692ac7,0x6329b827,
    0x62ea085c,0x62aa1b8d,0x6269f1e1,0x62298b81,0x61e8e893,0x61a80940,0x6166edb0,0x6125960a,
    0x60e40278,0x60a23322,0x6060282f,0x601de1ca,0x5fdb601b,0x5f98a34a,0x5f55ab82,0x5f1278eb,
    0x5ecf0baf,0x5e8b63f7,0x5e4781ed,0x5e0365bb,0x5dbf0f8c,0x5d7a7f88,0x5d35b5db,0x5cf0b2af,
    0x5cab762f,0x5c660084,0x5c2051db,0x5bda6a5d,0x5b944a37,0x5b4df193,0x5b07609d,0x5ac09781,
    0x5a799669,0x5a325d82,0x59eaecf8,0x59a344f6,0x595b65aa,0x59134f3e,0x58cb01e1,0x58827dbe,
    0x5839c302,0x57f0d1da,0x57a7aa73,0x575e4cfa,0x5714b99d,0x56caf088,0x5680f1ea,0x5636bdef,
    0x55ec54c6,0x55a1b69d,0x5556e3a1,0x550bdc01,0x54c09feb,0x54752f8d,0x54298b17,0x53ddb2b6,
    0x5391a699,0x534566f0,0x52f8f3e9,0x52ac4db4,0x525f7480,0x5212687b,0x51c529d7,0x5177b8c2,
    0x512a156b,0x50dc4005,0x508e38bd,0x503fffc4,0x4ff1954b,0x4fa2f981,0x4f542c98,0x4f052ec0,
    0x4eb60029,0x4e66a105,0x4e171184,0x4dc751d8,0x4d776231,0x4d2742c2,0x4cd6f3bb,0x4c86754e,
    0x4c35c7ac,0x4be4eb08,0x4b93df93,0x4b42a580,0x4af13d00,0x4a9fa645,0x4a4de182,0x49fbeeea,
    0x49a9ceaf,0x49578103,0x4905061a,0x48b25e25,0x485f8959,0x480c87e8,0x47b95a06,0x4765ffe6,
    0x471279ba,0x46bec7b8,0x466aea12,0x4616e0fc,0x45c2acaa,0x456e4d4f,0x4519c321,0x44c50e53,
    0x44702f19,0x441b25a8,0x43c5f234,0x437094f1,0x431b0e15,0x42c55dd4,0x426f8463,0x421981f7,
    0x41c356c5,0x416d0302,0x411686e4,0x40bfe29f,0x40691669,0x40122278,0x3fbb0702,0x3f63c43b,
    0x3f0c5a5a,0x3eb4c995,0x3e5d1222,0x3e053437,0x3dad300b,0x3d5505d2,0x3cfcb5c4,0x3ca44018,
    0x3c4ba504,0x3bf2e4be,0x3b99ff7d,0x3b40f579,0x3ae7c6e7,0x3a8e7400,0x3a34fcf9,0x39db620b,
    0x3981a36d,0x3927c155,0x38cdbbfc,0x38739399,0x38194864,0x37beda93,0x37644a60,0x37099802,
    0x36aec3b0,0x3653cda3,0x35f8b614,0x359d7d39,0x3542234c,0x34e6a885,0x348b0d1c,0x342f5149,
    0x33d37546,0x3377794b,0x331b5d91,0x32bf2250,0x3262c7c1,0x32064e1e,0x31a9b5a0,0x314cfe7f,
    0x30f028f4,0x3093353a,0x30362389,0x2fd8f41b,0x2f7ba729,0x2f1e3ced,0x2ec0b5a0,0x2e63117c,
    0x2e0550bb,0x2da77397,0x2d497a4a,0x2ceb650d,0x2c8d341a,0x2c2ee7ad,0x2bd07ffe,0x2b71fd48,
    0x2b135fc6,0x2ab4a7b1,0x2a55d545,0x29f6e8bb,0x2997e24f,0x2938c23a,0x28d988b8,0x287a3604,
    0x281aca57,0x27bb45ed,0x275ba901,0x26fbf3ce,0x269c268f,0x263c417f,0x25dc44d9,0x257c30d8,
    0x251c05b8,0x24bbc3b4,0x245b6b07,0x23fafbec,0x239a76a0,0x2339db5e,0x22d92a61,0x227863e5,
    0x22178826,0x21b6975f,0x215591cc,0x20f477aa,0x20934933,0x203206a4,0x1fd0b03a,0x1f6f462f,
    0x1f0dc8c0,0x1eac3829,0x1e4a94a7,0x1de8de75,0x1d8715d0,0x1d253af5,0x1cc34e1f,0x1c614f8b,
    0x1bff3f75,0x1b9d1e1a,0x1b3aebb6,0x1ad8a887,0x1a7654c8,0x1a13f0b6,0x19b17c8f,0x194ef88e,
    0x18ec64f0,0x1889c1f3,0x18270fd3,0x17c44ecd,0x17617f1d,0x16fea102,0x169bb4b7,0x1638ba7a,
    0x15d5b288,0x15729d1f,0x150f7a7a,0x14ac4ad7,0x14490e74,0x13e5c58e,0x13827062,0x131f0f2c,
    0x12bba22b,0x1258299c,0x11f4a5bd,0x119116c9,0x112d7d00,0x10c9d89e,0x106629e1,0x10027107,
    0x0f9eae4c,0x0f3ae1ee,0x0ed70c2c,0x0e732d42,0x0e0f456f,0x0dab54ef,0x0d475c00,0x0ce35ae1,
    0x0c7f51cf,0x0c1b4107,0x0bb728c7,0x0b53094d,0x0aeee2d7,0x0a8ab5a2,0x0a2681ed,0x09c247f5,
    0x095e07f8,0x08f9c233,0x089576e5,0x0831264c,0x07ccd0a5,0x0768762e,0x07041726,0x069fb3c9,
    0x063b4c57,0x05d6e10c,0x05727228,0x050dffe7,0x04a98a88,0x04451249,0x03e09767,0x037c1a22,
    0x03179ab5,0x02b31961,0x024e9662,0x01ea11f7,0x01858c5e,0x012105d5,0x00bc7e99,0x0057f6e9,
};

#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXs512[512] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xs512") =
#else
DATA_TYPE VorbisdecXs512[512]=
#endif /* RADIAX && AE && DMA */
{
/* IMDCT pre and post twiddle sin() table (N/4=512) */
    0x000c90fe,0x007118dc,0x00d5a075,0x013a278a,0x019eaddd,0x02033331,0x0267b747,0x02cc39e1,
    0x0330bac1,0x039539a9,0x03f9b65b,0x045e309a,0x04c2a827,0x05271cc4,0x058b8e34,0x05effc38,
    0x06546692,0x06b8cd05,0x071d2f52,0x07818d3c,0x07e5e685,0x084a3aee,0x08ae8a3a,0x0912d42c,
    0x09771884,0x09db5706,0x0a3f8f73,0x0aa3c18e,0x0b07ed19,0x0b6c11d5,0x0bd02f87,0x0c3445ee,
    0x0c9854cf,0x0cfc5bea,0x0d605b03,0x0dc451dc,0x0e284036,0x0e8c25d5,0x0ef0027b,0x0f53d5ea,
    0x0fb79fe4,0x101b602d,0x107f1686,0x10e2c2b2,0x11466473,0x11a9fb8d,0x120d87c1,0x127108d2,
    0x12d47e83,0x1337e897,0x139b46d0,0x13fe98f1,0x1461debc,0x14c517f4,0x1528445d,0x158b63b9,
    0x15ee75cb,0x16517a55,0x16b4711b,0x171759df,0x177a3466,0x17dd0070,0x183fbdc3,0x18a26c20,
    0x19050b4b,0x19679b07,0x19ca1b17,0x1a2c8b3f,0x1a8eeb42,0x1af13ae3,0x1b5379e5,0x1bb5a80c,
    0x1c17c51b,0x1c79d0d6,0x1cdbcb00,0x1d3db35e,0x1d9f89b1,0x1e014dbf,0x1e62ff4a,0x1ec49e17,
    0x1f2629ea,0x1f87a285,0x1fe907ae,0x204a5927,0x20ab96b5,0x210cc01d,0x216dd521,0x21ced586,
    0x222fc111,0x22909785,0x22f158a7,0x2352043b,0x23b29a05,0x241319ca,0x2473834f,0x24d3d657,
    0x253412a8,0x25943806,0x25f44635,0x26543cfb,0x26b41c1d,0x2713e35f,0x27739285,0x27d32956,
    0x2832a796,0x28920d0a,0x28f15978,0x29508ca4,0x29afa654,0x2a0ea64d,0x2a6d8c55,0x2acc5831,
    0x2b2b09a6,0x2b89a07b,0x2be81c74,0x2c467d58,0x2ca4c2ed,0x2d02ecf7,0x2d60fb3e,0x2dbeed86,
    0x2e1cc397,0x2e7a7d36,0x2ed81a29,0x2f359a37,0x2f92fd26,0x2ff042bd,0x304d6ac1,0x30aa74fa,
    0x3107612e,0x31642f23,0x31c0dea1,0x321d6f6e,0x3279e151,0x32d63412,0x33326776,0x338e7b46,
    0x33ea6f48,0x34464345,0x34a1f702,0x34fd8a48,0x3558fcde,0x35b44e8c,0x360f7f19,0x366a8e4d,
    0x36c57bf0,0x372047ca,0x377af1a3,0x37d57943,0x382fde72,0x388a20f8,0x38e4409e,0x393e3d2c,
    0x3998166a,0x39f1cc21,0x3a4b5e1b,0x3aa4cc1e,0x3afe15f6,0x3b573b69,0x3bb03c42,0x3c091849,
    0x3c61cf48,0x3cba6107,0x3d12cd51,0x3d6b13ee,0x3dc334a9,0x3e1b2f4a,0x3e73039d,0x3ecab169,
    0x3f22387a,0x3f799899,0x3fd0d191,0x4027e32b,0x407ecd32,0x40d58f71,0x412c29b1,0x41829bbe,
    0x41d8e561,0x422f0667,0x4284fe99,0x42dacdc3,0x433073b0,0x4385f02a,0x43db42fe,0x44306bf6,
    0x44856adf,0x44da3f83,0x452ee9ae,0x4583692c,0x45d7bdc9,0x462be751,0x467fe590,0x46d3b852,
    0x47275f63,0x477ada91,0x47ce29a7,0x48214c71,0x487442be,0x48c70c59,0x4919a90f,0x496c18ae,
    0x49be5b02,0x4a106fda,0x4a625701,0x4ab41046,0x4b059b77,0x4b56f861,0x4ba826d1,0x4bf92697,
    0x4c49f77f,0x4c9a9958,0x4ceb0bf0,0x4d3b4f16,0x4d8b6298,0x4ddb4644,0x4e2af9ea,0x4e7a7d58,
    0x4ec9d05e,0x4f18f2c9,0x4f67e46a,0x4fb6a510,0x5005348a,0x505392a8,0x50a1bf39,0x50efba0d,
    0x513d82f4,0x518b19bf,0x51d87e3c,0x5225b03d,0x5272af92,0x52bf7c0b,0x530c1579,0x53587bad,
    0x53a4ae77,0x53f0adaa,0x543c7914,0x54881089,0x54d373d9,0x551ea2d6,0x55699d51,0x55b4631d,
    0x55fef40a,0x56494fec,0x56937694,0x56dd67d4,0x5727237f,0x5770a968,0x57b9f960,0x5803133c,
    0x584bf6cd,0x5894a3e7,0x58dd1a5d,0x59255a02,0x596d62a9,0x59b53427,0x59fcce4f,0x5a4430f5,
    0x5a8b5bec,0x5ad24f09,0x5b190a20,0x5b5f8d06,0x5ba5d78e,0x5bebe98e,0x5c31c2db,0x5c776348,
    0x5cbccaac,0x5d01f8dc,0x5d46edac,0x5d8ba8f3,0x5dd02a85,0x5e147239,0x5e587fe5,0x5e9c535e,
    0x5edfec7b,0x5f234b12,0x5f666ef9,0x5fa95807,0x5fec0613,0x602e78f4,0x6070b080,0x60b2ac8f,
    0x60f46cf9,0x6135f193,0x61773a37,0x61b846bc,0x61f916f9,0x6239aac7,0x627a01fe,0x62ba1c77,
    0x62f9fa09,0x63399a8d,0x6378fddc,0x63b823cf,0x63f70c3f,0x6435b706,0x647423fb,0x64b252fa,
    0x64f043dc,0x652df679,0x656b6aae,0x65a8a052,0x65e59742,0x66224f56,0x665ec86b,0x669b0259,
    0x66d6fcfd,0x6712b831,0x674e33d0,0x67896fb6,0x67c46bbe,0x67ff27c4,0x6839a3a4,0x6873df38,
    0x68adda5f,0x68e794f3,0x69210ed1,0x695a47d6,0x69933fde,0x69cbf6c7,0x6a046c6c,0x6a3ca0ad,
    0x6a749365,0x6aac4472,0x6ae3b3b2,0x6b1ae103,0x6b51cc42,0x6b88754f,0x6bbedc06,0x6bf50047,
    0x6c2ae1f0,0x6c6080e0,0x6c95dcf6,0x6ccaf610,0x6cffcc0f,0x6d345ed1,0x6d68ae37,0x6d9cba1f,
    0x6dd0826a,0x6e0406f8,0x6e3747a9,0x6e6a445d,0x6e9cfcf5,0x6ecf7152,0x6f01a155,0x6f338cde,
    0x6f6533ce,0x6f969608,0x6fc7b36d,0x6ff88bde,0x70291f3e,0x70596d6d,0x70897650,0x70b939c7,
    0x70e8b7b5,0x7117effe,0x7146e284,0x71758f29,0x71a3f5d2,0x71d21662,0x71fff0bc,0x722d84c4,
    0x725ad25d,0x7287d96c,0x72b499d6,0x72e1137d,0x730d4648,0x7339321b,0x7364d6da,0x7390346b,
    0x73bb4ab3,0x73e61997,0x7410a0fe,0x743ae0cc,0x7464d8e8,0x748e8938,0x74b7f1a1,0x74e1120c,
    0x7509ea5d,0x75327a7d,0x755ac251,0x7582c1c2,0x75aa78b6,0x75d1e715,0x75f90cc7,0x761fe9b3,
    0x76467dc2,0x766cc8db,0x7692cae8,0x76b883d0,0x76ddf37c,0x770319d6,0x7727f6c6,0x774c8a36,
    0x7770d40f,0x7794d43b,0x77b88aa3,0x77dbf732,0x77ff19d1,0x7821f26b,0x784480ea,0x7866c53a,
    0x7888bf45,0x78aa6ef5,0x78cbd437,0x78eceef6,0x790dbf1d,0x792e4497,0x794e7f52,0x796e6f39,
    0x798e1438,0x79ad6e3c,0x79cc7d31,0x79eb4105,0x7a09b9a4,0x7a27e6fb,0x7a45c8f9,0x7a635f8a,
    0x7a80aa9c,0x7a9daa1d,0x7aba5dfc,0x7ad6c626,0x7af2e28b,0x7b0eb318,0x7b2a37bc,0x7b457068,
    0x7b605d09,0x7b7afd8f,0x7b9551ea,0x7baf5a09,0x7bc915dd,0x7be28556,0x7bfba863,0x7c147ef6,
    0x7c2d08ff,0x7c45466f,0x7c5d3737,0x7c74db48,0x7c8c3294,0x7ca33d0c,0x7cb9faa2,0x7cd06b48,
    0x7ce68ef0,0x7cfc658d,0x7d11ef11,0x7d272b6e,0x7d3c1a98,0x7d50bc82,0x7d65111f,0x7d791862,
    0x7d8cd240,0x7da03eab,0x7db35d98,0x7dc62efc,0x7dd8b2ca,0x7deae8f7,0x7dfcd178,0x7e0e6c42,
    0x7e1fb94a,0x7e30b885,0x7e4169e9,0x7e51cd6c,0x7e61e303,0x7e71aaa4,0x7e812447,0x7e904fe0,
    0x7e9f2d68,0x7eadbcd4,0x7ebbfe1c,0x7ec9f137,0x7ed7961c,0x7ee4ecc3,0x7ef1f524,0x7efeaf36,
    0x7f0b1af2,0x7f173850,0x7f230749,0x7f2e87d6,0x7f39b9ee,0x7f449d8c,0x7f4f32a9,0x7f59793e,
    0x7f637144,0x7f6d1ab6,0x7f76758e,0x7f7f81c6,0x7f883f58,0x7f90ae3f,0x7f98ce76,0x7fa09ff7,
    0x7fa822bf,0x7faf56c7,0x7fb63c0d,0x7fbcd28b,0x7fc31a3d,0x7fc91320,0x7fcebd31,0x7fd4186a,
    0x7fd924ca,0x7fdde24d,0x7fe250ef,0x7fe670b0,0x7fea418b,0x7fedc37e,0x7ff0f688,0x7ff3daa6,
    0x7ff66fd7,0x7ff8b619,0x7ffaad6a,0x7ffc55ca,0x7ffdaf37,0x7ffeb9b0,0x7fff7536,0x7fffe1c6,
};


#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXc1024[1024] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xc1024") =
#else
DATA_TYPE VorbisdecXc1024[1024]=
#endif /* RADIAX && AE && DMA */
{
0x7fffffd9, 0x7ffff382, 0x7fffd36f, 0x7fff9f9e, 0x7fff5810, 0x7ffefcc5, 0x7ffe8dbd, 0x7ffe0af8, 
0x7ffd7476, 0x7ffcca37, 0x7ffc0c3b, 0x7ffb3a83, 0x7ffa550e, 0x7ff95bdd, 0x7ff84ef0, 0x7ff72e46, 
0x7ff5f9e1, 0x7ff4b1c0, 0x7ff355e4, 0x7ff1e64c, 0x7ff062f9, 0x7feecbec, 0x7fed2123, 0x7feb62a1, 
0x7fe99064, 0x7fe7aa6e, 0x7fe5b0be, 0x7fe3a355, 0x7fe18233, 0x7fdf4d59, 0x7fdd04c6, 0x7fdaa87c, 
0x7fd8387a, 0x7fd5b4c1, 0x7fd31d51, 0x7fd0722b, 0x7fcdb34f, 0x7fcae0bd, 0x7fc7fa77, 0x7fc5007c, 
0x7fc1f2cc, 0x7fbed16a, 0x7fbb9c53, 0x7fb8538b, 0x7fb4f710, 0x7fb186e3, 0x7fae0305, 0x7faa6b77, 
0x7fa6c039, 0x7fa3014b, 0x7f9f2eae, 0x7f9b4863, 0x7f974e6a, 0x7f9340c4, 0x7f8f1f72, 0x7f8aea74, 
0x7f86a1ca, 0x7f824577, 0x7f7dd579, 0x7f7951d2, 0x7f74ba83, 0x7f700f8c, 0x7f6b50ed, 0x7f667ea9, 
0x7f6198bf, 0x7f5c9f30, 0x7f5791fd, 0x7f527127, 0x7f4d3caf, 0x7f47f494, 0x7f4298d9, 0x7f3d297e, 
0x7f37a684, 0x7f320feb, 0x7f2c65b5, 0x7f26a7e2, 0x7f20d674, 0x7f1af16a, 0x7f14f8c7, 0x7f0eec8b, 
0x7f08ccb7, 0x7f02994b, 0x7efc524a, 0x7ef5f7b3, 0x7eef8988, 0x7ee907ca, 0x7ee2727a, 0x7edbc998, 
0x7ed50d26, 0x7ece3d25, 0x7ec75996, 0x7ec0627a, 0x7eb957d2, 0x7eb239a0, 0x7eab07e3, 0x7ea3c29e, 
0x7e9c69d1, 0x7e94fd7e, 0x7e8d7da6, 0x7e85ea49, 0x7e7e436a, 0x7e768908, 0x7e6ebb27, 0x7e66d9c6, 
0x7e5ee4e6, 0x7e56dc8a, 0x7e4ec0b2, 0x7e469160, 0x7e3e4e95, 0x7e35f851, 0x7e2d8e97, 0x7e251168, 
0x7e1c80c5, 0x7e13dcaf, 0x7e0b2528, 0x7e025a31, 0x7df97bcb, 0x7df089f8, 0x7de784b9, 0x7dde6c0f, 
0x7dd53ffc, 0x7dcc0082, 0x7dc2ada2, 0x7db9475c, 0x7dafcdb3, 0x7da640a9, 0x7d9ca03e, 0x7d92ec73, 
0x7d89254c, 0x7d7f4ac8, 0x7d755cea, 0x7d6b5bb4, 0x7d614725, 0x7d571f41, 0x7d4ce409, 0x7d42957e, 
0x7d3833a2, 0x7d2dbe77, 0x7d2335fe, 0x7d189a38, 0x7d0deb28, 0x7d0328cf, 0x7cf8532f, 0x7ced6a49, 
0x7ce26e1f, 0x7cd75eb3, 0x7ccc3c06, 0x7cc1061a, 0x7cb5bcf2, 0x7caa608e, 0x7c9ef0f0, 0x7c936e1b, 
0x7c87d810, 0x7c7c2ed0, 0x7c70725e, 0x7c64a2bb, 0x7c58bfe9, 0x7c4cc9ea, 0x7c40c0c1, 0x7c34a46d, 
0x7c2874f3, 0x7c1c3253, 0x7c0fdc8f, 0x7c0373a9, 0x7bf6f7a4, 0x7bea6880, 0x7bddc641, 0x7bd110e8, 
0x7bc44876, 0x7bb76cef, 0x7baa7e53, 0x7b9d7ca5, 0x7b9067e7, 0x7b83401b, 0x7b760542, 0x7b68b760, 
0x7b5b5676, 0x7b4de286, 0x7b405b92, 0x7b32c19c, 0x7b2514a6, 0x7b1754b3, 0x7b0981c5, 0x7afb9bdd, 
0x7aeda2fe, 0x7adf972a, 0x7ad17863, 0x7ac346ac, 0x7ab50206, 0x7aa6aa74, 0x7a983ff7, 0x7a89c293, 
0x7a7b3249, 0x7a6c8f1c, 0x7a5dd90e, 0x7a4f1021, 0x7a403457, 0x7a3145b3, 0x7a224437, 0x7a132fe6, 
0x7a0408c1, 0x79f4cecb, 0x79e58207, 0x79d62276, 0x79c6b01b, 0x79b72af9, 0x79a79312, 0x7997e868, 
0x79882afd, 0x79785ad5, 0x796877f1, 0x79588255, 0x79487a01, 0x79385efa, 0x79283141, 0x7917f0d9, 
0x79079dc5, 0x78f73806, 0x78e6bfa0, 0x78d63495, 0x78c596e7, 0x78b4e69a, 0x78a423af, 0x78934e2a, 
0x7882660c, 0x78716b59, 0x78605e13, 0x784f3e3c, 0x783e0bd9, 0x782cc6ea, 0x781b6f72, 0x780a0575, 
0x77f888f6, 0x77e6f9f6, 0x77d55878, 0x77c3a47f, 0x77b1de0f, 0x77a00529, 0x778e19d0, 0x777c1c08, 
0x776a0bd3, 0x7757e933, 0x7745b42c, 0x77336cc0, 0x772112f2, 0x770ea6c5, 0x76fc283c, 0x76e9975a, 
0x76d6f421, 0x76c43e95, 0x76b176b8, 0x769e9c8d, 0x768bb017, 0x7678b159, 0x7665a056, 0x76527d11, 
0x763f478d, 0x762bffcd, 0x7618a5d3, 0x760539a3, 0x75f1bb40, 0x75de2aac, 0x75ca87ec, 0x75b6d301, 
0x75a30bef, 0x758f32b9, 0x757b4762, 0x756749ec, 0x75533a5c, 0x753f18b4, 0x752ae4f8, 0x75169f2a, 
0x7502474d, 0x74eddd65, 0x74d96175, 0x74c4d380, 0x74b03389, 0x749b8193, 0x7486bda2, 0x7471e7b8, 
0x745cffda, 0x7448060a, 0x7432fa4b, 0x741ddca0, 0x7408ad0e, 0x73f36b97, 0x73de183e, 0x73c8b307, 
0x73b33bf5, 0x739db30b, 0x7388184d, 0x73726bbe, 0x735cad61, 0x7346dd3a, 0x7330fb4d, 0x731b079b, 
0x73050229, 0x72eeeafb, 0x72d8c213, 0x72c28775, 0x72ac3b25, 0x7295dd25, 0x727f6d7a, 0x7268ec27, 
0x7252592f, 0x723bb496, 0x7224fe5f, 0x720e368d, 0x71f75d25, 0x71e0722a, 0x71c9759f, 0x71b26788, 
0x719b47e9, 0x718416c4, 0x716cd41e, 0x71557ffa, 0x713e1a5c, 0x7126a348, 0x710f1ac0, 0x70f780c9, 
0x70dfd566, 0x70c8189b, 0x70b04a6b, 0x70986adb, 0x708079ee, 0x706877a7, 0x7050640b, 0x70383f1d, 
0x702008e0, 0x7007c159, 0x6fef688b, 0x6fd6fe7a, 0x6fbe832a, 0x6fa5f69e, 0x6f8d58db, 0x6f74a9e4, 
0x6f5be9bc, 0x6f431869, 0x6f2a35ed, 0x6f11424c, 0x6ef83d8a, 0x6edf27ac, 0x6ec600b5, 0x6eacc8a8, 
0x6e937f8a, 0x6e7a255f, 0x6e60ba2a, 0x6e473df0, 0x6e2db0b4, 0x6e14127b, 0x6dfa6348, 0x6de0a31f, 
0x6dc6d204, 0x6daceffb, 0x6d92fd09, 0x6d78f931, 0x6d5ee477, 0x6d44bedf, 0x6d2a886e, 0x6d104126, 
0x6cf5e90d, 0x6cdb8027, 0x6cc10677, 0x6ca67c01, 0x6c8be0cb, 0x6c7134d7, 0x6c56782a, 0x6c3baac7, 
0x6c20ccb4, 0x6c05ddf5, 0x6beade8c, 0x6bcfce80, 0x6bb4add3, 0x6b997c8a, 0x6b7e3aa9, 0x6b62e834, 
0x6b478530, 0x6b2c11a1, 0x6b108d8b, 0x6af4f8f2, 0x6ad953db, 0x6abd9e49, 0x6aa1d841, 0x6a8601c8, 
0x6a6a1ae2, 0x6a4e2392, 0x6a321bdd, 0x6a1603c8, 0x69f9db57, 0x69dda28f, 0x69c15973, 0x69a50007, 
0x69889651, 0x696c1c55, 0x694f9217, 0x6932f79b, 0x69164ce7, 0x68f991fd, 0x68dcc6e4, 0x68bfeb9e, 
0x68a30031, 0x688604a2, 0x6868f8f4, 0x684bdd2c, 0x682eb14e, 0x68117560, 0x67f42965, 0x67d6cd62, 
0x67b9615c, 0x679be557, 0x677e5957, 0x6760bd62, 0x6743117c, 0x672555a9, 0x670789ee, 0x66e9ae4f, 
0x66cbc2d2, 0x66adc77b, 0x668fbc4e, 0x6671a14f, 0x66537685, 0x66353bf3, 0x6616f19e, 0x65f8978b, 
0x65da2dbd, 0x65bbb43b, 0x659d2b09, 0x657e922b, 0x655fe9a7, 0x65413180, 0x652269bc, 0x6503925f, 
0x64e4ab6e, 0x64c5b4ef, 0x64a6aee4, 0x64879955, 0x64687444, 0x64493fb8, 0x6429fbb5, 0x640aa83f, 
0x63eb455c, 0x63cbd310, 0x63ac5160, 0x638cc051, 0x636d1fe9, 0x634d702b, 0x632db11c, 0x630de2c3, 
0x62ee0523, 0x62ce1841, 0x62ae1c23, 0x628e10cc, 0x626df643, 0x624dcc8d, 0x622d93ad, 0x620d4baa, 
0x61ecf487, 0x61cc8e4b, 0x61ac18f9, 0x618b9498, 0x616b012c, 0x614a5eba, 0x6129ad46, 0x6108ecd8, 
0x60e81d72, 0x60c73f1b, 0x60a651d7, 0x608555ab, 0x60644a9d, 0x604330b1, 0x602207ee, 0x6000d057, 
0x5fdf89f2, 0x5fbe34c4, 0x5f9cd0d2, 0x5f7b5e22, 0x5f59dcb8, 0x5f384c9a, 0x5f16adcc, 0x5ef50055, 
0x5ed34439, 0x5eb1797e, 0x5e8fa028, 0x5e6db83d, 0x5e4bc1c2, 0x5e29bcbd, 0x5e07a932, 0x5de58727, 
0x5dc356a1, 0x5da117a5, 0x5d7eca39, 0x5d5c6e62, 0x5d3a0426, 0x5d178b89, 0x5cf50490, 0x5cd26f42, 
0x5cafcba4, 0x5c8d19ba, 0x5c6a598b, 0x5c478b1b, 0x5c24ae70, 0x5c01c38f, 0x5bdeca7f, 0x5bbbc343, 
0x5b98ade2, 0x5b758a60, 0x5b5258c4, 0x5b2f1913, 0x5b0bcb52, 0x5ae86f87, 0x5ac505b7, 0x5aa18de7, 
0x5a7e081d, 0x5a5a745f, 0x5a36d2b2, 0x5a13231b, 0x59ef65a1, 0x59cb9a47, 0x59a7c115, 0x5983da10, 
0x595fe53c, 0x593be2a0, 0x5917d242, 0x58f3b426, 0x58cf8852, 0x58ab4ecc, 0x5887079a, 0x5862b2c1, 
0x583e5047, 0x5819e030, 0x57f56284, 0x57d0d747, 0x57ac3e80, 0x57879833, 0x5762e467, 0x573e2320, 
0x57195466, 0x56f4783d, 0x56cf8eab, 0x56aa97b7, 0x56859364, 0x566081ba, 0x563b62be, 0x56163676, 
0x55f0fce7, 0x55cbb617, 0x55a6620c, 0x558100cc, 0x555b925c, 0x553616c2, 0x55108e05, 0x54eaf829, 
0x54c55535, 0x549fa52e, 0x5479e81a, 0x54541e00, 0x542e46e4, 0x540862cd, 0x53e271c0, 0x53bc73c4, 
0x539668de, 0x53705114, 0x534a2c6c, 0x5323faec, 0x52fdbc9a, 0x52d7717b, 0x52b11996, 0x528ab4f1, 
0x52644390, 0x523dc57b, 0x52173ab8, 0x51f0a34b, 0x51c9ff3c, 0x51a34e8f, 0x517c914c, 0x5155c778, 
0x512ef119, 0x51080e35, 0x50e11ed2, 0x50ba22f5, 0x50931aa6, 0x506c05ea, 0x5044e4c7, 0x501db743, 
0x4ff67d64, 0x4fcf3731, 0x4fa7e4af, 0x4f8085e4, 0x4f591ad6, 0x4f31a38c, 0x4f0a200b, 0x4ee2905a, 
0x4ebaf47f, 0x4e934c80, 0x4e6b9862, 0x4e43d82d, 0x4e1c0be6, 0x4df43393, 0x4dcc4f3b, 0x4da45ee3, 
0x4d7c6293, 0x4d545a4f, 0x4d2c461e, 0x4d042607, 0x4cdbfa0f, 0x4cb3c23d, 0x4c8b7e97, 0x4c632f23, 
0x4c3ad3e7, 0x4c126cea, 0x4be9fa32, 0x4bc17bc5, 0x4b98f1a9, 0x4b705be4, 0x4b47ba7e, 0x4b1f0d7b, 
0x4af654e3, 0x4acd90bb, 0x4aa4c10b, 0x4a7be5d7, 0x4a52ff27, 0x4a2a0d01, 0x4a010f6b, 0x49d8066b, 
0x49aef208, 0x4985d248, 0x495ca732, 0x493370cb, 0x490a2f1a, 0x48e0e227, 0x48b789f5, 0x488e268e, 
0x4864b7f5, 0x483b3e33, 0x4811b94d, 0x47e8294a, 0x47be8e31, 0x4794e807, 0x476b36d3, 0x47417a9b, 
0x4717b367, 0x46ede13b, 0x46c40420, 0x469a1c1b, 0x46702933, 0x46462b6d, 0x461c22d2, 0x45f20f67, 
0x45c7f132, 0x459dc83b, 0x45739487, 0x4549561d, 0x451f0d04, 0x44f4b943, 0x44ca5adf, 0x449ff1df, 
0x44757e4a, 0x444b0026, 0x4420777b, 0x43f5e44d, 0x43cb46a5, 0x43a09e89, 0x4375ebfe, 0x434b2f0c, 
0x432067ba, 0x42f5960e, 0x42caba0e, 0x429fd3c1, 0x4274e32e, 0x4249e85c, 0x421ee350, 0x41f3d413, 
0x41c8baa9, 0x419d971b, 0x4172696e, 0x414731a9, 0x411befd3, 0x40f0a3f3, 0x40c54e0f, 0x4099ee2e, 
0x406e8457, 0x40431090, 0x401792e0, 0x3fec0b4e, 0x3fc079e0, 0x3f94de9e, 0x3f69398d, 0x3f3d8ab5, 
0x3f11d21d, 0x3ee60fca, 0x3eba43c4, 0x3e8e6e12, 0x3e628ebb, 0x3e36a5c4, 0x3e0ab336, 0x3ddeb716, 
0x3db2b16b, 0x3d86a23d, 0x3d5a8992, 0x3d2e6771, 0x3d023be0, 0x3cd606e7, 0x3ca9c88c, 0x3c7d80d6, 
0x3c512fcc, 0x3c24d575, 0x3bf871d8, 0x3bcc04fb, 0x3b9f8ee5, 0x3b730f9e, 0x3b46872c, 0x3b19f595, 
0x3aed5ae1, 0x3ac0b717, 0x3a940a3d, 0x3a67545b, 0x3a3a9577, 0x3a0dcd99, 0x39e0fcc6, 0x39b42307, 
0x39874061, 0x395a54dd, 0x392d6080, 0x39006352, 0x38d35d59, 0x38a64e9d, 0x38793725, 0x384c16f7, 
0x381eee1b, 0x37f1bc97, 0x37c48273, 0x37973fb5, 0x3769f464, 0x373ca088, 0x370f4427, 0x36e1df48, 
0x36b471f3, 0x3686fc2e, 0x36597e00, 0x362bf771, 0x35fe6887, 0x35d0d14a, 0x35a331c0, 0x357589f0, 
0x3547d9e2, 0x351a219c, 0x34ec6127, 0x34be9887, 0x3490c7c6, 0x3462eee9, 0x34350df8, 0x340724fb, 
0x33d933f7, 0x33ab3af4, 0x337d39f9, 0x334f310e, 0x33212039, 0x32f30782, 0x32c4e6ef, 0x3296be88, 
0x32688e54, 0x323a565a, 0x320c16a1, 0x31ddcf30, 0x31af800e, 0x31812943, 0x3152cad5, 0x312464cd, 
0x30f5f730, 0x30c78206, 0x30990557, 0x306a8129, 0x303bf584, 0x300d626e, 0x2fdec7f0, 0x2fb0260f, 
0x2f817cd4, 0x2f52cc46, 0x2f24146b, 0x2ef5554b, 0x2ec68eed, 0x2e97c159, 0x2e68ec95, 0x2e3a10aa, 
0x2e0b2d9d, 0x2ddc4376, 0x2dad523d, 0x2d7e59f9, 0x2d4f5ab1, 0x2d20546b, 0x2cf14731, 0x2cc23308, 
0x2c9317f8, 0x2c63f609, 0x2c34cd40, 0x2c059da7, 0x2bd66744, 0x2ba72a1e, 0x2b77e63d, 0x2b489ba8, 
0x2b194a66, 0x2ae9f27e, 0x2aba93f9, 0x2a8b2edc, 0x2a5bc330, 0x2a2c50fc, 0x29fcd847, 0x29cd5918, 
0x299dd377, 0x296e476b, 0x293eb4fb, 0x290f1c2f, 0x28df7d0e, 0x28afd7a0, 0x28802beb, 0x285079f7, 
0x2820c1cc, 0x27f10371, 0x27c13eec, 0x27917447, 0x2761a387, 0x2731ccb4, 0x2701efd7, 0x26d20cf5, 
0x26a22416, 0x26723543, 0x26424082, 0x261245da, 0x25e24553, 0x25b23ef5, 0x258232c6, 0x255220cf, 
0x25220916, 0x24f1eba4, 0x24c1c87f, 0x24919fae, 0x2461713a, 0x24313d2a, 0x24010385, 0x23d0c453, 
0x23a07f9a, 0x23703564, 0x233fe5b6, 0x230f9098, 0x22df3613, 0x22aed62c, 0x227e70ed, 0x224e065c, 
0x221d9680, 0x21ed2162, 0x21bca708, 0x218c277a, 0x215ba2c0, 0x212b18e1, 0x20fa89e5, 0x20c9f5d3, 
0x20995cb2, 0x2068be8a, 0x20381b63, 0x20077344, 0x1fd6c634, 0x1fa6143b, 0x1f755d61, 0x1f44a1ad, 
0x1f13e127, 0x1ee31bd6, 0x1eb251c1, 0x1e8182f1, 0x1e50af6c, 0x1e1fd73a, 0x1deefa63, 0x1dbe18ef, 
0x1d8d32e4, 0x1d5c484b, 0x1d2b592a, 0x1cfa658a, 0x1cc96d72, 0x1c9870e9, 0x1c676ff8, 0x1c366aa5, 
0x1c0560f8, 0x1bd452f9, 0x1ba340b0, 0x1b722a23, 0x1b410f5b, 0x1b0ff05f, 0x1adecd37, 0x1aada5e9, 
0x1a7c7a7f, 0x1a4b4aff, 0x1a1a1771, 0x19e8dfdc, 0x19b7a449, 0x198664be, 0x19552144, 0x1923d9e1, 
0x18f28e9e, 0x18c13f82, 0x188fec95, 0x185e95de, 0x182d3b65, 0x17fbdd32, 0x17ca7b4c, 0x179915ba, 
0x1767ac85, 0x17363fb4, 0x1704cf4e, 0x16d35b5c, 0x16a1e3e5, 0x167068f0, 0x163eea86, 0x160d68ad, 
0x15dbe36d, 0x15aa5acf, 0x1578ced9, 0x15473f94, 0x1515ad06, 0x14e41738, 0x14b27e32, 0x1480e1fa, 
0x144f4299, 0x141da016, 0x13ebfa79, 0x13ba51ca, 0x1388a60f, 0x1356f752, 0x13254599, 0x12f390ec, 
0x12c1d953, 0x12901ed5, 0x125e617b, 0x122ca14b, 0x11fade4e, 0x11c9188b, 0x1197500a, 0x116584d3, 
0x1133b6ed, 0x1101e65f, 0x10d01333, 0x109e3d6e, 0x106c651a, 0x103a8a3d, 0x1008acdf, 0x0fd6cd08, 
0x0fa4eac0, 0x0f73060f, 0x0f411efb, 0x0f0f358e, 0x0edd49ce, 0x0eab5bc3, 0x0e796b74, 0x0e4778eb, 
0x0e15842e, 0x0de38d44, 0x0db19437, 0x0d7f990c, 0x0d4d9bcd, 0x0d1b9c81, 0x0ce99b2f, 0x0cb797e0, 
0x0c85929a, 0x0c538b66, 0x0c21824c, 0x0bef7752, 0x0bbd6a82, 0x0b8b5be1, 0x0b594b7a, 0x0b273952, 
0x0af52571, 0x0ac30fe1, 0x0a90f8a7, 0x0a5edfcc, 0x0a2cc558, 0x09faa952, 0x09c88bc2, 0x09966cb0, 
0x09644c23, 0x09322a24, 0x090006ba, 0x08cde1ec, 0x089bbbc3, 0x08699445, 0x08376b7c, 0x0805416e, 
0x07d31624, 0x07a0e9a5, 0x076ebbf9, 0x073c8d27, 0x070a5d37, 0x06d82c32, 0x06a5fa1e, 0x0673c704, 
0x064192eb, 0x060f5ddc, 0x05dd27dd, 0x05aaf0f6, 0x0578b930, 0x05468092, 0x05144723, 0x04e20cec, 
0x04afd1f4, 0x047d9643, 0x044b59e1, 0x04191cd5, 0x03e6df28, 0x03b4a0e0, 0x03826207, 0x035022a2, 
0x031de2bb, 0x02eba259, 0x02b96184, 0x02872042, 0x0254de9e, 0x02229c9d, 0x01f05a48, 0x01be17a6, 
0x018bd4bf, 0x0159919c, 0x01274e43, 0x00f50abd, 0x00c2c711, 0x00908346, 0x005e3f66, 0x002bfb77, 
};

#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXs1024[1024] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xs1024") =
#else
DATA_TYPE VorbisdecXs1024[1024]=
#endif /* RADIAX && AE && DMA */
{
0x0006487f, 0x00388c74, 0x006ad060, 0x009d143b, 0x00cf57ff, 0x01019ba2, 0x0133df1e, 0x0166226a, 
0x0198657f, 0x01caa855, 0x01fceae4, 0x022f2d25, 0x02616f10, 0x0293b09c, 0x02c5f1c3, 0x02f8327d, 
0x032a72c1, 0x035cb288, 0x038ef1ca, 0x03c13080, 0x03f36ea2, 0x0425ac28, 0x0457e90a, 0x048a2540, 
0x04bc60c4, 0x04ee9b8c, 0x0520d592, 0x05530ecd, 0x05854736, 0x05b77ec5, 0x05e9b572, 0x061beb36, 
0x064e2009, 0x068053e3, 0x06b286bc, 0x06e4b88d, 0x0716e94e, 0x074918f6, 0x077b4780, 0x07ad74e1, 
0x07dfa114, 0x0811cc10, 0x0843f5cd, 0x08761e44, 0x08a8456d, 0x08da6b40, 0x090c8fb6, 0x093eb2c6, 
0x0970d46a, 0x09a2f498, 0x09d5134b, 0x0a073079, 0x0a394c1b, 0x0a6b662a, 0x0a9d7e9d, 0x0acf956d, 
0x0b01aa92, 0x0b33be05, 0x0b65cfbe, 0x0b97dfb5, 0x0bc9ede2, 0x0bfbfa3d, 0x0c2e04c0, 0x0c600d61, 
0x0c92141a, 0x0cc418e3, 0x0cf61bb4, 0x0d281c85, 0x0d5a1b4f, 0x0d8c1809, 0x0dbe12ad, 0x0df00b32, 
0x0e220191, 0x0e53f5c2, 0x0e85e7be, 0x0eb7d77c, 0x0ee9c4f5, 0x0f1bb021, 0x0f4d98f9, 0x0f7f7f75, 
0x0fb1638d, 0x0fe34539, 0x10152472, 0x10470130, 0x1078db6c, 0x10aab31d, 0x10dc883c, 0x110e5ac2, 
0x11402aa6, 0x1171f7e2, 0x11a3c26c, 0x11d58a3e, 0x12074f50, 0x1239119b, 0x126ad116, 0x129c8dba, 
0x12ce477f, 0x12fffe5d, 0x1331b24e, 0x13636349, 0x13951146, 0x13c6bc3f, 0x13f8642a, 0x142a0902, 
0x145baabd, 0x148d4954, 0x14bee4c0, 0x14f07cf9, 0x152211f8, 0x1553a3b4, 0x15853226, 0x15b6bd47, 
0x15e8450e, 0x1619c975, 0x164b4a73, 0x167cc801, 0x16ae4217, 0x16dfb8ae, 0x17112bbd, 0x17429b3e, 
0x17740729, 0x17a56f76, 0x17d6d41d, 0x18083518, 0x1839925d, 0x186aebe6, 0x189c41ab, 0x18cd93a5, 
0x18fee1cb, 0x19302c17, 0x19617280, 0x1992b4ff, 0x19c3f38d, 0x19f52e22, 0x1a2664b5, 0x1a579741, 
0x1a88c5bc, 0x1ab9f020, 0x1aeb1665, 0x1b1c3883, 0x1b4d5672, 0x1b7e702c, 0x1baf85a9, 0x1be096e0, 
0x1c11a3cb, 0x1c42ac62, 0x1c73b09d, 0x1ca4b075, 0x1cd5abe3, 0x1d06a2dd, 0x1d37955e, 0x1d68835e, 
0x1d996cd4, 0x1dca51ba, 0x1dfb3208, 0x1e2c0db6, 0x1e5ce4be, 0x1e8db716, 0x1ebe84b8, 0x1eef4d9d, 
0x1f2011bc, 0x1f50d10e, 0x1f818b8d, 0x1fb2412f, 0x1fe2f1ee, 0x20139dc2, 0x204444a4, 0x2074e68c, 
0x20a58373, 0x20d61b51, 0x2106ae1e, 0x21373bd4, 0x2167c46b, 0x219847da, 0x21c8c61c, 0x21f93f27, 
0x2229b2f6, 0x225a217f, 0x228a8abd, 0x22baeea7, 0x22eb4d36, 0x231ba662, 0x234bfa24, 0x237c4875, 
0x23ac914d, 0x23dcd4a4, 0x240d1274, 0x243d4ab4, 0x246d7d5e, 0x249daa6a, 0x24cdd1d0, 0x24fdf389, 
0x252e0f8e, 0x255e25d7, 0x258e365d, 0x25be4118, 0x25ee4601, 0x261e4511, 0x264e3e40, 0x267e3186, 
0x26ae1edd, 0x26de063d, 0x270de79f, 0x273dc2fa, 0x276d9849, 0x279d6783, 0x27cd30a1, 0x27fcf39c, 
0x282cb06c, 0x285c670a, 0x288c176e, 0x28bbc192, 0x28eb656e, 0x291b02fa, 0x294a9a30, 0x297a2b07, 
0x29a9b579, 0x29d9397f, 0x2a08b710, 0x2a382e25, 0x2a679eb8, 0x2a9708c1, 0x2ac66c39, 0x2af5c917, 
0x2b251f56, 0x2b546eee, 0x2b83b7d7, 0x2bb2fa0a, 0x2be2357f, 0x2c116a31, 0x2c409816, 0x2c6fbf29, 
0x2c9edf61, 0x2ccdf8b8, 0x2cfd0b26, 0x2d2c16a4, 0x2d5b1b2b, 0x2d8a18b3, 0x2db90f35, 0x2de7feaa, 
0x2e16e70b, 0x2e45c850, 0x2e74a272, 0x2ea3756b, 0x2ed24132, 0x2f0105c1, 0x2f2fc310, 0x2f5e7919, 
0x2f8d27d3, 0x2fbbcf38, 0x2fea6f41, 0x301907e6, 0x30479920, 0x307622e8, 0x30a4a537, 0x30d32006, 
0x3101934d, 0x312fff05, 0x315e6328, 0x318cbfad, 0x31bb148f, 0x31e961c5, 0x3217a748, 0x3245e512, 
0x32741b1c, 0x32a2495d, 0x32d06fd0, 0x32fe8e6d, 0x332ca52c, 0x335ab407, 0x3388baf7, 0x33b6b9f4, 
0x33e4b0f8, 0x34129ffb, 0x344086f6, 0x346e65e3, 0x349c3cb9, 0x34ca0b73, 0x34f7d208, 0x35259073, 
0x355346ab, 0x3580f4aa, 0x35ae9a69, 0x35dc37e0, 0x3609cd0a, 0x363759de, 0x3664de55, 0x36925a69, 
0x36bfce13, 0x36ed394b, 0x371a9c0b, 0x3747f64c, 0x37754806, 0x37a29132, 0x37cfd1cb, 0x37fd09c8, 
0x382a3922, 0x38575fd4, 0x38847dd5, 0x38b1931e, 0x38de9faa, 0x390ba371, 0x39389e6b, 0x39659092, 
0x399279e0, 0x39bf5a4d, 0x39ec31d1, 0x3a190068, 0x3a45c608, 0x3a7282ac, 0x3a9f364d, 0x3acbe0e3, 
0x3af88269, 0x3b251ad6, 0x3b51aa24, 0x3b7e304c, 0x3baaad48, 0x3bd72110, 0x3c038b9e, 0x3c2fecea, 
0x3c5c44ee, 0x3c8893a4, 0x3cb4d904, 0x3ce11507, 0x3d0d47a6, 0x3d3970dc, 0x3d6590a0, 0x3d91a6ed, 
0x3dbdb3ba, 0x3de9b703, 0x3e15b0bf, 0x3e41a0e8, 0x3e6d8778, 0x3e996467, 0x3ec537ae, 0x3ef10148, 
0x3f1cc12c, 0x3f487756, 0x3f7423bc, 0x3f9fc65a, 0x3fcb5f28, 0x3ff6ee1f, 0x4022733a, 0x404dee70, 
0x40795fbc, 0x40a4c716, 0x40d02478, 0x40fb77dc, 0x4126c13a, 0x4152008c, 0x417d35cb, 0x41a860f1, 
0x41d381f7, 0x41fe98d6, 0x4229a588, 0x4254a806, 0x427fa049, 0x42aa8e4b, 0x42d57205, 0x43004b71, 
0x432b1a87, 0x4355df42, 0x4380999b, 0x43ab498a, 0x43d5ef0a, 0x44008a14, 0x442b1aa2, 0x4455a0ac, 
0x44801c2d, 0x44aa8d1d, 0x44d4f376, 0x44ff4f32, 0x4529a04b, 0x4553e6b8, 0x457e2275, 0x45a8537a, 
0x45d279c2, 0x45fc9545, 0x4626a5fd, 0x4650abe3, 0x467aa6f2, 0x46a49722, 0x46ce7c6d, 0x46f856cd, 
0x4722263b, 0x474beab1, 0x4775a428, 0x479f529a, 0x47c8f601, 0x47f28e56, 0x481c1b92, 0x48459daf, 
0x486f14a8, 0x48988074, 0x48c1e10f, 0x48eb3672, 0x49148095, 0x493dbf74, 0x4966f307, 0x49901b48, 
0x49b93832, 0x49e249bc, 0x4a0b4fe2, 0x4a344a9d, 0x4a5d39e6, 0x4a861db8, 0x4aaef60b, 0x4ad7c2da, 
0x4b00841f, 0x4b2939d2, 0x4b51e3ee, 0x4b7a826d, 0x4ba31548, 0x4bcb9c79, 0x4bf417f9, 0x4c1c87c3, 
0x4c44ebd1, 0x4c6d441b, 0x4c95909c, 0x4cbdd14e, 0x4ce6062a, 0x4d0e2f2a, 0x4d364c48, 0x4d5e5d7e, 
0x4d8662c6, 0x4dae5c19, 0x4dd64971, 0x4dfe2ac9, 0x4e260019, 0x4e4dc95c, 0x4e75868c, 0x4e9d37a3, 
0x4ec4dc99, 0x4eec756b, 0x4f140210, 0x4f3b8284, 0x4f62f6bf, 0x4f8a5ebd, 0x4fb1ba76, 0x4fd909e5, 
0x50004d04, 0x502783cd, 0x504eae39, 0x5075cc43, 0x509cdde4, 0x50c3e317, 0x50eadbd6, 0x5111c81a, 
0x5138a7dd, 0x515f7b1a, 0x518641cb, 0x51acfbe9, 0x51d3a96f, 0x51fa4a56, 0x5220de99, 0x52476631, 
0x526de11a, 0x52944f4c, 0x52bab0c2, 0x52e10576, 0x53074d62, 0x532d8880, 0x5353b6cb, 0x5379d83c, 
0x539feccd, 0x53c5f479, 0x53ebef3a, 0x5411dd0a, 0x5437bde3, 0x545d91bf, 0x54835898, 0x54a91269, 
0x54cebf2c, 0x54f45edb, 0x5519f16f, 0x553f76e4, 0x5564ef34, 0x558a5a58, 0x55afb84c, 0x55d50909, 
0x55fa4c89, 0x561f82c7, 0x5644abbc, 0x5669c765, 0x568ed5b9, 0x56b3d6b5, 0x56d8ca51, 0x56fdb08a, 
0x57228957, 0x574754b5, 0x576c129d, 0x5790c30a, 0x57b565f6, 0x57d9fb5c, 0x57fe8335, 0x5822fd7c, 
0x58476a2c, 0x586bc93f, 0x58901aaf, 0x58b45e76, 0x58d89490, 0x58fcbcf6, 0x5920d7a3, 0x5944e492, 
0x5968e3bc, 0x598cd51d, 0x59b0b8ae, 0x59d48e6a, 0x59f8564c, 0x5a1c104f, 0x5a3fbc6b, 0x5a635a9d, 
0x5a86eadf, 0x5aaa6d2b, 0x5acde17b, 0x5af147ca, 0x5b14a014, 0x5b37ea51, 0x5b5b267e, 0x5b7e5493, 
0x5ba1748d, 0x5bc48666, 0x5be78a17, 0x5c0a7f9c, 0x5c2d66f0, 0x5c50400d, 0x5c730aed, 0x5c95c78b, 
0x5cb875e3, 0x5cdb15ee, 0x5cfda7a7, 0x5d202b09, 0x5d42a00e, 0x5d6506b2, 0x5d875eef, 0x5da9a8bf, 
0x5dcbe41d, 0x5dee1105, 0x5e102f71, 0x5e323f5b, 0x5e5440be, 0x5e763395, 0x5e9817dc, 0x5eb9ed8b, 
0x5edbb49f, 0x5efd6d13, 0x5f1f16e0, 0x5f40b202, 0x5f623e73, 0x5f83bc2f, 0x5fa52b31, 0x5fc68b72, 
0x5fe7dcee, 0x60091fa0, 0x602a5383, 0x604b7891, 0x606c8ec5, 0x608d961b, 0x60ae8e8d, 0x60cf7817, 
0x60f052b2, 0x61111e5b, 0x6131db0b, 0x615288be, 0x61732770, 0x6193b719, 0x61b437b7, 0x61d4a944, 
0x61f50bba, 0x62155f16, 0x6235a351, 0x6255d866, 0x6275fe52, 0x6296150f, 0x62b61c98, 0x62d614e7, 
0x62f5fdf9, 0x6315d7c8, 0x6335a24f, 0x63555d8a, 0x63750973, 0x6394a606, 0x63b4333d, 0x63d3b114, 
0x63f31f86, 0x64127e8f, 0x6431ce28, 0x64510e4f, 0x64703efc, 0x648f602d, 0x64ae71dc, 0x64cd7404, 
0x64ec66a0, 0x650b49ac, 0x652a1d23, 0x6548e101, 0x6567953f, 0x658639db, 0x65a4cece, 0x65c35415, 
0x65e1c9aa, 0x66002f89, 0x661e85ad, 0x663ccc12, 0x665b02b3, 0x6679298a, 0x66974095, 0x66b547cd, 
0x66d33f2e, 0x66f126b4, 0x670efe5a, 0x672cc61c, 0x674a7df4, 0x676825de, 0x6785bdd6, 0x67a345d8, 
0x67c0bddd, 0x67de25e3, 0x67fb7de5, 0x6818c5dd, 0x6835fdc7, 0x685325a0, 0x68703d62, 0x688d4509, 
0x68aa3c90, 0x68c723f4, 0x68e3fb2e, 0x6900c23c, 0x691d7919, 0x693a1fc0, 0x6956b62d, 0x69733c5b, 
0x698fb246, 0x69ac17e9, 0x69c86d41, 0x69e4b249, 0x6a00e6fc, 0x6a1d0b57, 0x6a391f54, 0x6a5522ef, 
0x6a711625, 0x6a8cf8f1, 0x6aa8cb4e, 0x6ac48d39, 0x6ae03eac, 0x6afbdfa4, 0x6b17701d, 0x6b32f012, 
0x6b4e5f7f, 0x6b69be5f, 0x6b850caf, 0x6ba04a6a, 0x6bbb778d, 0x6bd69412, 0x6bf19ff6, 0x6c0c9b35, 
0x6c2785ca, 0x6c425fb1, 0x6c5d28e6, 0x6c77e165, 0x6c92892a, 0x6cad2031, 0x6cc7a676, 0x6ce21bf4, 
0x6cfc80a7, 0x6d16d48c, 0x6d31179e, 0x6d4b49da, 0x6d656b3a, 0x6d7f7bbc, 0x6d997b5b, 0x6db36a14, 
0x6dcd47e1, 0x6de714c0, 0x6e00d0ac, 0x6e1a7ba1, 0x6e34159b, 0x6e4d9e97, 0x6e671690, 0x6e807d83, 
0x6e99d36b, 0x6eb31845, 0x6ecc4c0d, 0x6ee56ebe, 0x6efe8056, 0x6f1780cf, 0x6f307027, 0x6f494e5a, 
0x6f621b62, 0x6f7ad73e, 0x6f9381e9, 0x6fac1b5f, 0x6fc4a39c, 0x6fdd1a9c, 0x6ff5805d, 0x700dd4da, 
0x7026180e, 0x703e49f8, 0x70566a92, 0x706e79d9, 0x708677ca, 0x709e6460, 0x70b63f99, 0x70ce096f, 
0x70e5c1e1, 0x70fd68e9, 0x7114fe84, 0x712c82b0, 0x7143f567, 0x715b56a7, 0x7172a66c, 0x7189e4b2, 
0x71a11175, 0x71b82cb3, 0x71cf3667, 0x71e62e8f, 0x71fd1525, 0x7213ea28, 0x722aad93, 0x72415f63, 
0x7257ff94, 0x726e8e23, 0x72850b0d, 0x729b764d, 0x72b1cfe1, 0x72c817c6, 0x72de4df6, 0x72f47270, 
0x730a8530, 0x73208632, 0x73367572, 0x734c52ef, 0x73621ea4, 0x7377d88d, 0x738d80a8, 0x73a316f2, 
0x73b89b66, 0x73ce0e01, 0x73e36ec1, 0x73f8bda2, 0x740dfaa0, 0x742325b9, 0x74383ee9, 0x744d462c, 
0x74623b80, 0x74771ee2, 0x748bf04d, 0x74a0afc0, 0x74b55d36, 0x74c9f8ad, 0x74de8221, 0x74f2f990, 
0x75075ef5, 0x751bb24f, 0x752ff399, 0x754422d0, 0x75583ff3, 0x756c4afc, 0x758043ea, 0x75942ab9, 
0x75a7ff67, 0x75bbc1ef, 0x75cf7250, 0x75e31086, 0x75f69c8d, 0x760a1664, 0x761d7e06, 0x7630d372, 
0x764416a4, 0x76574798, 0x766a664d, 0x767d72bf, 0x76906ceb, 0x76a354cf, 0x76b62a66, 0x76c8edb0, 
0x76db9ea7, 0x76ee3d4b, 0x7700c997, 0x77134389, 0x7725ab1f, 0x77380054, 0x774a4327, 0x775c7395, 
0x776e919a, 0x77809d35, 0x77929661, 0x77a47d1d, 0x77b65166, 0x77c81339, 0x77d9c293, 0x77eb5f71, 
0x77fce9d2, 0x780e61b1, 0x781fc70d, 0x783119e2, 0x78425a2f, 0x785387ef, 0x7864a322, 0x7875abc3, 
0x7886a1d1, 0x78978549, 0x78a85628, 0x78b9146c, 0x78c9c012, 0x78da5917, 0x78eadf79, 0x78fb5336, 
0x790bb44a, 0x791c02b4, 0x792c3e70, 0x793c677d, 0x794c7dd7, 0x795c817d, 0x796c726c, 0x797c50a1, 
0x798c1c1a, 0x799bd4d4, 0x79ab7ace, 0x79bb0e04, 0x79ca8e75, 0x79d9fc1d, 0x79e956fb, 0x79f89f0c, 
0x7a07d44e, 0x7a16f6be, 0x7a26065b, 0x7a350321, 0x7a43ed0e, 0x7a52c421, 0x7a618857, 0x7a7039ad, 
0x7a7ed821, 0x7a8d63b2, 0x7a9bdc5c, 0x7aaa421e, 0x7ab894f6, 0x7ac6d4e0, 0x7ad501dc, 0x7ae31be6, 
0x7af122fd, 0x7aff171e, 0x7b0cf848, 0x7b1ac678, 0x7b2881ac, 0x7b3629e1, 0x7b43bf17, 0x7b51414a, 
0x7b5eb079, 0x7b6c0ca2, 0x7b7955c2, 0x7b868bd7, 0x7b93aee0, 0x7ba0beda, 0x7badbbc3, 0x7bbaa59a, 
0x7bc77c5d, 0x7bd44008, 0x7be0f09b, 0x7bed8e14, 0x7bfa1870, 0x7c068fae, 0x7c12f3cb, 0x7c1f44c6, 
0x7c2b829d, 0x7c37ad4e, 0x7c43c4d7, 0x7c4fc936, 0x7c5bba6a, 0x7c679870, 0x7c736347, 0x7c7f1aed, 
0x7c8abf5f, 0x7c96509d, 0x7ca1cea5, 0x7cad3974, 0x7cb8910a, 0x7cc3d563, 0x7ccf067f, 0x7cda245c, 
0x7ce52ef7, 0x7cf02651, 0x7cfb0a65, 0x7d05db34, 0x7d1098bb, 0x7d1b42f9, 0x7d25d9eb, 0x7d305d91, 
0x7d3acde9, 0x7d452af1, 0x7d4f74a7, 0x7d59ab0a, 0x7d63ce19, 0x7d6dddd2, 0x7d77da32, 0x7d81c33a, 
0x7d8b98e6, 0x7d955b37, 0x7d9f0a29, 0x7da8a5bc, 0x7db22def, 0x7dbba2bf, 0x7dc5042b, 0x7dce5232, 
0x7dd78cd3, 0x7de0b40b, 0x7de9c7da, 0x7df2c83f, 0x7dfbb537, 0x7e048ec1, 0x7e0d54dc, 0x7e160787, 
0x7e1ea6c1, 0x7e273287, 0x7e2faad9, 0x7e380fb5, 0x7e40611b, 0x7e489f08, 0x7e50c97c, 0x7e58e075, 
0x7e60e3f2, 0x7e68d3f2, 0x7e70b073, 0x7e787975, 0x7e802ef6, 0x7e87d0f5, 0x7e8f5f70, 0x7e96da67, 
0x7e9e41d9, 0x7ea595c4, 0x7eacd627, 0x7eb40301, 0x7ebb1c52, 0x7ec22217, 0x7ec9144f, 0x7ecff2fb, 
0x7ed6be18, 0x7edd75a6, 0x7ee419a3, 0x7eeaaa0f, 0x7ef126e9, 0x7ef7902f, 0x7efde5e0, 0x7f0427fc, 
0x7f0a5682, 0x7f107170, 0x7f1678c6, 0x7f1c6c83, 0x7f224ca6, 0x7f28192d, 0x7f2dd219, 0x7f337768, 
0x7f390919, 0x7f3e872c, 0x7f43f19f, 0x7f494872, 0x7f4e8ba4, 0x7f53bb34, 0x7f58d721, 0x7f5ddf6b, 
0x7f62d411, 0x7f67b512, 0x7f6c826d, 0x7f713c21, 0x7f75e22e, 0x7f7a7494, 0x7f7ef350, 0x7f835e64, 
0x7f87b5cd, 0x7f8bf98b, 0x7f90299f, 0x7f944606, 0x7f984ec1, 0x7f9c43ce, 0x7fa0252e, 0x7fa3f2df, 
0x7fa7ace1, 0x7fab5333, 0x7faee5d5, 0x7fb264c7, 0x7fb5d007, 0x7fb92796, 0x7fbc6b72, 0x7fbf9b9b, 
0x7fc2b811, 0x7fc5c0d3, 0x7fc8b5e1, 0x7fcb973b, 0x7fce64df, 0x7fd11ecd, 0x7fd3c506, 0x7fd65788, 
0x7fd8d653, 0x7fdb4167, 0x7fdd98c4, 0x7fdfdc69, 0x7fe20c55, 0x7fe42889, 0x7fe63103, 0x7fe825c5, 
0x7fea06cd, 0x7febd41b, 0x7fed8daf, 0x7fef3388, 0x7ff0c5a7, 0x7ff2440b, 0x7ff3aeb4, 0x7ff505a2, 
0x7ff648d4, 0x7ff7784a, 0x7ff89405, 0x7ff99c03, 0x7ffa9045, 0x7ffb70cb, 0x7ffc3d94, 0x7ffcf6a0, 
0x7ffd9bf0, 0x7ffe2d83, 0x7ffeab59, 0x7fff1572, 0x7fff6bcd, 0x7fffae6c, 0x7fffdd4d, 0x7ffff872, 
};

#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXc2048[2048] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xc2048") =
#else
DATA_TYPE VorbisdecXc2048[2048]=
#endif /* RADIAX && AE && DMA */
{
0x7ffffff6, 0x7ffffce1, 0x7ffff4dc, 0x7fffe7e8, 0x7fffd604, 0x7fffbf31, 0x7fffa36f, 0x7fff82be, 
0x7fff5d1d, 0x7fff328d, 0x7fff030e, 0x7ffece9f, 0x7ffe9542, 0x7ffe56f5, 0x7ffe13b8, 0x7ffdcb8d, 
0x7ffd7e72, 0x7ffd2c68, 0x7ffcd56f, 0x7ffc7987, 0x7ffc18af, 0x7ffbb2e8, 0x7ffb4833, 0x7ffad88e, 
0x7ffa63fa, 0x7ff9ea76, 0x7ff96c04, 0x7ff8e8a3, 0x7ff86053, 0x7ff7d313, 0x7ff740e5, 0x7ff6a9c8, 
0x7ff60dbb, 0x7ff56cc0, 0x7ff4c6d6, 0x7ff41bfd, 0x7ff36c36, 0x7ff2b77f, 0x7ff1fdd9, 0x7ff13f45, 
0x7ff07bc2, 0x7fefb351, 0x7feee5f0, 0x7fee13a1, 0x7fed3c64, 0x7fec6038, 0x7feb7f1d, 0x7fea9914, 
0x7fe9ae1c, 0x7fe8be36, 0x7fe7c961, 0x7fe6cf9e, 0x7fe5d0ed, 0x7fe4cd4d, 0x7fe3c4bf, 0x7fe2b743, 
0x7fe1a4d9, 0x7fe08d81, 0x7fdf713a, 0x7fde5006, 0x7fdd29e3, 0x7fdbfed3, 0x7fdaced4, 0x7fd999e8, 
0x7fd8600e, 0x7fd72146, 0x7fd5dd90, 0x7fd494ed, 0x7fd3475c, 0x7fd1f4dd, 0x7fd09d71, 0x7fcf4117, 
0x7fcddfd0, 0x7fcc799c, 0x7fcb0e7a, 0x7fc99e6b, 0x7fc8296f, 0x7fc6af86, 0x7fc530af, 0x7fc3acec, 
0x7fc2243b, 0x7fc0969e, 0x7fbf0414, 0x7fbd6c9c, 0x7fbbd039, 0x7fba2ee8, 0x7fb888ab, 0x7fb6dd81, 
0x7fb52d6b, 0x7fb37869, 0x7fb1be7a, 0x7fafff9e, 0x7fae3bd7, 0x7fac7323, 0x7faaa584, 0x7fa8d2f8, 
0x7fa6fb80, 0x7fa51f1d, 0x7fa33dcd, 0x7fa15792, 0x7f9f6c6b, 0x7f9d7c59, 0x7f9b875b, 0x7f998d72, 
0x7f978e9d, 0x7f958add, 0x7f938232, 0x7f91749c, 0x7f8f621b, 0x7f8d4aae, 0x7f8b2e57, 0x7f890d15, 
0x7f86e6e9, 0x7f84bbd1, 0x7f828bcf, 0x7f8056e3, 0x7f7e1d0c, 0x7f7bde4b, 0x7f799aa0, 0x7f77520a, 
0x7f75048b, 0x7f72b222, 0x7f705ace, 0x7f6dfe91, 0x7f6b9d6b, 0x7f69375a, 0x7f66cc61, 0x7f645c7d, 
0x7f61e7b1, 0x7f5f6dfb, 0x7f5cef5c, 0x7f5a6bd5, 0x7f57e364, 0x7f55560a, 0x7f52c3c8, 0x7f502c9d, 
0x7f4d9089, 0x7f4aef8d, 0x7f4849a9, 0x7f459edd, 0x7f42ef28, 0x7f403a8b, 0x7f3d8107, 0x7f3ac29b, 
0x7f37ff47, 0x7f35370b, 0x7f3269e8, 0x7f2f97dd, 0x7f2cc0eb, 0x7f29e512, 0x7f270452, 0x7f241eab, 
0x7f21341e, 0x7f1e44a9, 0x7f1b504e, 0x7f18570c, 0x7f1558e4, 0x7f1255d6, 0x7f0f4de2, 0x7f0c4107, 
0x7f092f47, 0x7f0618a1, 0x7f02fd15, 0x7effdca4, 0x7efcb74d, 0x7ef98d11, 0x7ef65def, 0x7ef329e9, 
0x7eeff0fe, 0x7eecb32d, 0x7ee97079, 0x7ee628df, 0x7ee2dc61, 0x7edf8aff, 0x7edc34b9, 0x7ed8d98e, 
0x7ed57980, 0x7ed2148e, 0x7eceaab8, 0x7ecb3bff, 0x7ec7c862, 0x7ec44fe2, 0x7ec0d27f, 0x7ebd5039, 
0x7eb9c910, 0x7eb63d04, 0x7eb2ac15, 0x7eaf1645, 0x7eab7b91, 0x7ea7dbfc, 0x7ea43785, 0x7ea08e2b, 
0x7e9cdff0, 0x7e992cd4, 0x7e9574d6, 0x7e91b7f6, 0x7e8df636, 0x7e8a2f94, 0x7e866411, 0x7e8293ae, 
0x7e7ebe6a, 0x7e7ae446, 0x7e770541, 0x7e73215c, 0x7e6f3897, 0x7e6b4af2, 0x7e67586e, 0x7e63610a, 
0x7e5f64c7, 0x7e5b63a4, 0x7e575da2, 0x7e5352c1, 0x7e4f4302, 0x7e4b2e64, 0x7e4714e7, 0x7e42f68c, 
0x7e3ed353, 0x7e3aab3c, 0x7e367e48, 0x7e324c75, 0x7e2e15c5, 0x7e29da38, 0x7e2599cd, 0x7e215486, 
0x7e1d0a61, 0x7e18bb60, 0x7e146782, 0x7e100ec8, 0x7e0bb132, 0x7e074ec0, 0x7e02e772, 0x7dfe7b48, 
0x7dfa0a43, 0x7df59462, 0x7df119a7, 0x7dec9a10, 0x7de8159e, 0x7de38c52, 0x7ddefe2b, 0x7dda6b2a, 
0x7dd5d34f, 0x7dd1369a, 0x7dcc950b, 0x7dc7eea3, 0x7dc34361, 0x7dbe9346, 0x7db9de52, 0x7db52485, 
0x7db065df, 0x7daba261, 0x7da6da0b, 0x7da20cdc, 0x7d9d3ad6, 0x7d9863f7, 0x7d938841, 0x7d8ea7b4, 
0x7d89c250, 0x7d84d814, 0x7d7fe902, 0x7d7af519, 0x7d75fc59, 0x7d70fec4, 0x7d6bfc58, 0x7d66f517, 
0x7d61e8ff, 0x7d5cd813, 0x7d57c251, 0x7d52a7ba, 0x7d4d884e, 0x7d48640d, 0x7d433af8, 0x7d3e0d0e, 
0x7d38da51, 0x7d33a2bf, 0x7d2e665a, 0x7d292522, 0x7d23df16, 0x7d1e9437, 0x7d194485, 0x7d13f001, 
0x7d0e96aa, 0x7d093880, 0x7d03d585, 0x7cfe6db8, 0x7cf90119, 0x7cf38fa9, 0x7cee1967, 0x7ce89e55, 
0x7ce31e72, 0x7cdd99be, 0x7cd8103a, 0x7cd281e5, 0x7ccceec1, 0x7cc756cd, 0x7cc1ba09, 0x7cbc1877, 
0x7cb67215, 0x7cb0c6e4, 0x7cab16e4, 0x7ca56216, 0x7c9fa87a, 0x7c99ea10, 0x7c9426d8, 0x7c8e5ed3, 
0x7c889200, 0x7c82c060, 0x7c7ce9f4, 0x7c770eba, 0x7c712eb5, 0x7c6b49e3, 0x7c656045, 0x7c5f71db, 
0x7c597ea6, 0x7c5386a6, 0x7c4d89da, 0x7c478844, 0x7c4181e3, 0x7c3b76b8, 0x7c3566c2, 0x7c2f5203, 
0x7c29387a, 0x7c231a28, 0x7c1cf70c, 0x7c16cf28, 0x7c10a27b, 0x7c0a7105, 0x7c043ac7, 0x7bfdffc1, 
0x7bf7bff4, 0x7bf17b5e, 0x7beb3202, 0x7be4e3df, 0x7bde90f4, 0x7bd83944, 0x7bd1dccc, 0x7bcb7b8f, 
0x7bc5158c, 0x7bbeaac4, 0x7bb83b36, 0x7bb1c6e3, 0x7bab4dcc, 0x7ba4cfef, 0x7b9e4d4f, 0x7b97c5ea, 
0x7b9139c2, 0x7b8aa8d6, 0x7b841326, 0x7b7d78b4, 0x7b76d97f, 0x7b703587, 0x7b698ccd, 0x7b62df51, 
0x7b5c2d13, 0x7b557614, 0x7b4eba53, 0x7b47f9d2, 0x7b413490, 0x7b3a6a8d, 0x7b339bca, 0x7b2cc847, 
0x7b25f004, 0x7b1f1302, 0x7b183141, 0x7b114ac1, 0x7b0a5f82, 0x7b036f85, 0x7afc7aca, 0x7af58151, 
0x7aee831a, 0x7ae78026, 0x7ae07876, 0x7ad96c08, 0x7ad25ade, 0x7acb44f8, 0x7ac42a55, 0x7abd0af7, 
0x7ab5e6de, 0x7aaebe0a, 0x7aa7907b, 0x7aa05e31, 0x7a99272d, 0x7a91eb6f, 0x7a8aaaf7, 0x7a8365c6, 
0x7a7c1bdc, 0x7a74cd38, 0x7a6d79dd, 0x7a6621c9, 0x7a5ec4fc, 0x7a576379, 0x7a4ffd3d, 0x7a48924b, 
0x7a4122a1, 0x7a39ae41, 0x7a32352b, 0x7a2ab75f, 0x7a2334dd, 0x7a1bada5, 0x7a1421b8, 0x7a0c9117, 
0x7a04fbc1, 0x79fd61b6, 0x79f5c2f8, 0x79ee1f86, 0x79e67760, 0x79deca87, 0x79d718fc, 0x79cf62be, 
0x79c7a7ce, 0x79bfe82c, 0x79b823d8, 0x79b05ad3, 0x79a88d1d, 0x79a0bab6, 0x7998e39f, 0x799107d8, 
0x79892761, 0x7981423a, 0x79795864, 0x797169df, 0x796976ac, 0x79617eca, 0x7959823b, 0x795180fe, 
0x79497b13, 0x7941707b, 0x79396137, 0x79314d46, 0x792934a9, 0x79211760, 0x7918f56c, 0x7910cecc, 
0x7908a382, 0x7900738d, 0x78f83eee, 0x78f005a5, 0x78e7c7b2, 0x78df8516, 0x78d73dd1, 0x78cef1e4, 
0x78c6a14e, 0x78be4c10, 0x78b5f22a, 0x78ad939d, 0x78a53069, 0x789cc88f, 0x78945c0d, 0x788beae6, 
0x78837519, 0x787afaa7, 0x78727b8f, 0x7869f7d3, 0x78616f72, 0x7858e26e, 0x785050c5, 0x7847ba79, 
0x783f1f8a, 0x78367ff8, 0x782ddbc4, 0x782532ed, 0x781c8575, 0x7813d35b, 0x780b1ca0, 0x78026145, 
0x77f9a148, 0x77f0dcac, 0x77e81370, 0x77df4595, 0x77d6731a, 0x77cd9c01, 0x77c4c04a, 0x77bbdff4, 
0x77b2fb00, 0x77aa1170, 0x77a12342, 0x77983077, 0x778f3910, 0x77863d0d, 0x777d3c6f, 0x77743735, 
0x776b2d60, 0x77621ef1, 0x77590be7, 0x774ff443, 0x7746d806, 0x773db730, 0x773491c0, 0x772b67b9, 
0x77223919, 0x771905e1, 0x770fce12, 0x770691ab, 0x76fd50ae, 0x76f40b1b, 0x76eac0f2, 0x76e17233, 
0x76d81ede, 0x76cec6f5, 0x76c56a77, 0x76bc0965, 0x76b2a3bf, 0x76a93985, 0x769fcab9, 0x76965759, 
0x768cdf67, 0x768362e4, 0x7679e1ce, 0x76705c27, 0x7666d1ef, 0x765d4327, 0x7653afce, 0x764a17e6, 
0x76407b6e, 0x7636da67, 0x762d34d1, 0x76238aad, 0x7619dbfb, 0x761028bb, 0x760670ee, 0x75fcb495, 
0x75f2f3ae, 0x75e92e3c, 0x75df643e, 0x75d595b4, 0x75cbc2a0, 0x75c1eb01, 0x75b80ed8, 0x75ae2e25, 
0x75a448e8, 0x759a5f22, 0x759070d4, 0x75867dfd, 0x757c869f, 0x75728ab9, 0x75688a4b, 0x755e8557, 
0x75547bdd, 0x754a6ddd, 0x75405b57, 0x7536444b, 0x752c28bb, 0x752208a7, 0x7517e40e, 0x750dbaf2, 
0x75038d52, 0x74f95b30, 0x74ef248b, 0x74e4e964, 0x74daa9bb, 0x74d06591, 0x74c61ce6, 0x74bbcfbb, 
0x74b17e0f, 0x74a727e4, 0x749ccd39, 0x74926e10, 0x74880a68, 0x747da242, 0x7473359e, 0x7468c47c, 
0x745e4ede, 0x7453d4c4, 0x7449562d, 0x743ed31b, 0x74344b8d, 0x7429bf84, 0x741f2f01, 0x74149a04, 
0x740a008d, 0x73ff629d, 0x73f4c034, 0x73ea1953, 0x73df6df9, 0x73d4be28, 0x73ca09e0, 0x73bf5121, 
0x73b493ec, 0x73a9d240, 0x739f0c20, 0x73944189, 0x7389727f, 0x737e9f00, 0x7373c70d, 0x7368eaa6, 
0x735e09cd, 0x73532481, 0x73483ac2, 0x733d4c92, 0x733259f1, 0x732762de, 0x731c675b, 0x73116768, 
0x73066306, 0x72fb5a34, 0x72f04cf3, 0x72e53b44, 0x72da2526, 0x72cf0a9c, 0x72c3eba4, 0x72b8c83f, 
0x72ada06f, 0x72a27432, 0x7297438a, 0x728c0e77, 0x7280d4f9, 0x72759712, 0x726a54c1, 0x725f0e06, 
0x7253c2e3, 0x72487357, 0x723d1f63, 0x7231c708, 0x72266a46, 0x721b091d, 0x720fa38e, 0x7204399a, 
0x71f8cb40, 0x71ed5881, 0x71e1e15e, 0x71d665d6, 0x71cae5ec, 0x71bf619e, 0x71b3d8ed, 0x71a84bdb, 
0x719cba66, 0x71912490, 0x71858a5a, 0x7179ebc3, 0x716e48cc, 0x7162a175, 0x7156f5c0, 0x714b45ac, 
0x713f9139, 0x7133d869, 0x71281b3c, 0x711c59b2, 0x711093cb, 0x7104c989, 0x70f8faeb, 0x70ed27f2, 
0x70e1509f, 0x70d574f1, 0x70c994ea, 0x70bdb08a, 0x70b1c7d1, 0x70a5dac0, 0x7099e957, 0x708df396, 
0x7081f97f, 0x7075fb11, 0x7069f84e, 0x705df135, 0x7051e5c7, 0x7045d604, 0x7039c1ed, 0x702da983, 
0x70218cc6, 0x70156bb5, 0x70094653, 0x6ffd1c9f, 0x6ff0ee99, 0x6fe4bc43, 0x6fd8859d, 0x6fcc4aa6, 
0x6fc00b60, 0x6fb3c7cb, 0x6fa77fe8, 0x6f9b33b7, 0x6f8ee338, 0x6f828e6c, 0x6f763554, 0x6f69d7f0, 
0x6f5d7640, 0x6f511044, 0x6f44a5ff, 0x6f38376f, 0x6f2bc495, 0x6f1f4d72, 0x6f12d206, 0x6f065253, 
0x6ef9ce57, 0x6eed4614, 0x6ee0b98a, 0x6ed428ba, 0x6ec793a4, 0x6ebafa49, 0x6eae5ca9, 0x6ea1bac4, 
0x6e95149c, 0x6e886a30, 0x6e7bbb82, 0x6e6f0890, 0x6e62515d, 0x6e5595e9, 0x6e48d633, 0x6e3c123e, 
0x6e2f4a08, 0x6e227d92, 0x6e15acde, 0x6e08d7eb, 0x6dfbfeba, 0x6def214c, 0x6de23fa0, 0x6dd559b9, 
0x6dc86f95, 0x6dbb8135, 0x6dae8e9b, 0x6da197c6, 0x6d949cb7, 0x6d879d6e, 0x6d7a99ed, 0x6d6d9233, 
0x6d608641, 0x6d537617, 0x6d4661b7, 0x6d394920, 0x6d2c2c53, 0x6d1f0b50, 0x6d11e619, 0x6d04bcad, 
0x6cf78f0d, 0x6cea5d3a, 0x6cdd2733, 0x6ccfecfa, 0x6cc2ae90, 0x6cb56bf4, 0x6ca82527, 0x6c9ada29, 
0x6c8d8afc, 0x6c80379f, 0x6c72e013, 0x6c658459, 0x6c582472, 0x6c4ac05d, 0x6c3d581b, 0x6c2febad, 
0x6c227b13, 0x6c15064e, 0x6c078d5e, 0x6bfa1044, 0x6bec8f00, 0x6bdf0993, 0x6bd17ffd, 0x6bc3f23f, 
0x6bb6605a, 0x6ba8ca4e, 0x6b9b301b, 0x6b8d91c2, 0x6b7fef43, 0x6b7248a0, 0x6b649dd8, 0x6b56eeec, 
0x6b493bdd, 0x6b3b84ab, 0x6b2dc956, 0x6b2009e0, 0x6b124648, 0x6b047e90, 0x6af6b2b7, 0x6ae8e2bf, 
0x6adb0ea8, 0x6acd3672, 0x6abf5a1e, 0x6ab179ac, 0x6aa3951d, 0x6a95ac72, 0x6a87bfab, 0x6a79cec8, 
0x6a6bd9cb, 0x6a5de0b3, 0x6a4fe382, 0x6a41e237, 0x6a33dcd4, 0x6a25d358, 0x6a17c5c5, 0x6a09b41a, 
0x69fb9e59, 0x69ed8482, 0x69df6696, 0x69d14494, 0x69c31e7f, 0x69b4f455, 0x69a6c618, 0x699893c9, 
0x698a5d67, 0x697c22f3, 0x696de46f, 0x695fa1da, 0x69515b35, 0x69431080, 0x6934c1bd, 0x69266eeb, 
0x6918180c, 0x6909bd1f, 0x68fb5e25, 0x68ecfb20, 0x68de940f, 0x68d028f2, 0x68c1b9cc, 0x68b3469b, 
0x68a4cf61, 0x6896541f, 0x6887d4d4, 0x68795181, 0x686aca27, 0x685c3ec7, 0x684daf61, 0x683f1bf5, 
0x68308485, 0x6821e910, 0x68134997, 0x6804a61b, 0x67f5fe9d, 0x67e7531c, 0x67d8a39a, 0x67c9f017, 
0x67bb3894, 0x67ac7d11, 0x679dbd8f, 0x678efa0e, 0x6780328f, 0x67716713, 0x67629799, 0x6753c423, 
0x6744ecb2, 0x67361145, 0x672731dd, 0x67184e7c, 0x67096721, 0x66fa7bcd, 0x66eb8c80, 0x66dc993c, 
0x66cda201, 0x66bea6cf, 0x66afa7a7, 0x66a0a489, 0x66919d77, 0x66829270, 0x66738376, 0x66647088, 
0x665559a8, 0x66463ed6, 0x66372012, 0x6627fd5e, 0x6618d6b9, 0x6609ac25, 0x65fa7da2, 0x65eb4b30, 
0x65dc14d0, 0x65ccda83, 0x65bd9c49, 0x65ae5a23, 0x659f1412, 0x658fca15, 0x65807c2f, 0x65712a5e, 
0x6561d4a4, 0x65527b02, 0x65431d77, 0x6533bc06, 0x652456ad, 0x6514ed6e, 0x6505804a, 0x64f60f40, 
0x64e69a52, 0x64d72180, 0x64c7a4cb, 0x64b82433, 0x64a89fba, 0x6499175e, 0x64898b22, 0x6479fb06, 
0x646a670a, 0x645acf2e, 0x644b3375, 0x643b93dd, 0x642bf069, 0x641c4917, 0x640c9dea, 0x63fceee1, 
0x63ed3bfd, 0x63dd853f, 0x63cdcaa8, 0x63be0c37, 0x63ae49ee, 0x639e83cd, 0x638eb9d5, 0x637eec07, 
0x636f1a62, 0x635f44e8, 0x634f6b99, 0x633f8e76, 0x632fad80, 0x631fc8b7, 0x630fe01b, 0x62fff3ae, 
0x62f0036f, 0x62e00f60, 0x62d01781, 0x62c01bd3, 0x62b01c57, 0x62a0190c, 0x629011f4, 0x6280070f, 
0x626ff85e, 0x625fe5e1, 0x624fcf9a, 0x623fb588, 0x622f97ad, 0x621f7608, 0x620f509b, 0x61ff2766, 
0x61eefa6b, 0x61dec9a8, 0x61ce9520, 0x61be5cd2, 0x61ae20bf, 0x619de0e9, 0x618d9d4f, 0x617d55f2, 
0x616d0ad3, 0x615cbbf3, 0x614c6951, 0x613c12f0, 0x612bb8ce, 0x611b5aee, 0x610af94f, 0x60fa93f2, 
0x60ea2ad8, 0x60d9be02, 0x60c94d70, 0x60b8d923, 0x60a8611b, 0x6097e559, 0x608765dd, 0x6076e2a9, 
0x60665bbd, 0x6055d11a, 0x604542bf, 0x6034b0af, 0x60241ae9, 0x6013816e, 0x6002e43f, 0x5ff2435d, 
0x5fe19ec7, 0x5fd0f67f, 0x5fc04a85, 0x5faf9adb, 0x5f9ee780, 0x5f8e3075, 0x5f7d75bb, 0x5f6cb753, 
0x5f5bf53d, 0x5f4b2f7a, 0x5f3a660a, 0x5f2998ee, 0x5f18c827, 0x5f07f3b6, 0x5ef71b9b, 0x5ee63fd6, 
0x5ed56069, 0x5ec47d54, 0x5eb39697, 0x5ea2ac34, 0x5e91be2b, 0x5e80cc7c, 0x5e6fd729, 0x5e5ede32, 
0x5e4de197, 0x5e3ce15a, 0x5e2bdd7a, 0x5e1ad5f9, 0x5e09cad7, 0x5df8bc15, 0x5de7a9b4, 0x5dd693b4, 
0x5dc57a16, 0x5db45cda, 0x5da33c01, 0x5d92178d, 0x5d80ef7c, 0x5d6fc3d1, 0x5d5e948c, 0x5d4d61ad, 
0x5d3c2b35, 0x5d2af125, 0x5d19b37e, 0x5d087240, 0x5cf72d6b, 0x5ce5e501, 0x5cd49903, 0x5cc3496f, 
0x5cb1f649, 0x5ca09f8f, 0x5c8f4544, 0x5c7de767, 0x5c6c85f9, 0x5c5b20fa, 0x5c49b86d, 0x5c384c50, 
0x5c26dca5, 0x5c15696d, 0x5c03f2a8, 0x5bf27857, 0x5be0fa7a, 0x5bcf7912, 0x5bbdf421, 0x5bac6ba6, 
0x5b9adfa2, 0x5b895016, 0x5b77bd02, 0x5b662668, 0x5b548c48, 0x5b42eea2, 0x5b314d78, 0x5b1fa8c9, 
0x5b0e0098, 0x5afc54e3, 0x5aeaa5ad, 0x5ad8f2f5, 0x5ac73cbd, 0x5ab58304, 0x5aa3c5cd, 0x5a920517, 
0x5a8040e3, 0x5a6e7931, 0x5a5cae04, 0x5a4adf5a, 0x5a390d35, 0x5a273796, 0x5a155e7d, 0x5a0381eb, 
0x59f1a1e0, 0x59dfbe5e, 0x59cdd765, 0x59bbecf5, 0x59a9ff10, 0x59980db6, 0x598618e8, 0x597420a6, 
0x596224f1, 0x595025ca, 0x593e2331, 0x592c1d28, 0x591a13af, 0x590806c6, 0x58f5f66e, 0x58e3e2a9, 
0x58d1cb76, 0x58bfb0d7, 0x58ad92cb, 0x589b7155, 0x58894c74, 0x58772429, 0x5864f875, 0x5852c958, 
0x584096d4, 0x582e60e9, 0x581c2798, 0x5809eae1, 0x57f7aac5, 0x57e56744, 0x57d32061, 0x57c0d61a, 
0x57ae8872, 0x579c3768, 0x5789e2fd, 0x57778b32, 0x57653009, 0x5752d180, 0x57406f9a, 0x572e0a56, 
0x571ba1b7, 0x570935bb, 0x56f6c664, 0x56e453b4, 0x56d1dda9, 0x56bf6446, 0x56ace78a, 0x569a6777, 
0x5687e40e, 0x56755d4e, 0x5662d339, 0x565045cf, 0x563db512, 0x562b2101, 0x5618899e, 0x5605eee9, 
0x55f350e3, 0x55e0af8d, 0x55ce0ae7, 0x55bb62f3, 0x55a8b7b0, 0x55960920, 0x55835743, 0x5570a21a, 
0x555de9a6, 0x554b2de7, 0x55386edf, 0x5525ac8d, 0x5512e6f3, 0x55001e12, 0x54ed51e9, 0x54da827a, 
0x54c7afc6, 0x54b4d9cd, 0x54a20090, 0x548f2410, 0x547c444d, 0x54696149, 0x54567b03, 0x5443917d, 
0x5430a4b7, 0x541db4b3, 0x540ac170, 0x53f7caef, 0x53e4d132, 0x53d1d439, 0x53bed405, 0x53abd096, 
0x5398c9ed, 0x5385c00c, 0x5372b2f2, 0x535fa2a0, 0x534c8f17, 0x53397859, 0x53265e65, 0x5313413c, 
0x530020df, 0x52ecfd4f, 0x52d9d68d, 0x52c6ac99, 0x52b37f74, 0x52a04f1f, 0x528d1b9b, 0x5279e4e7, 
0x5266ab06, 0x52536df7, 0x52402dbc, 0x522cea55, 0x5219a3c3, 0x52065a07, 0x51f30d21, 0x51dfbd12, 
0x51cc69db, 0x51b9137d, 0x51a5b9f9, 0x51925d4e, 0x517efd7f, 0x516b9a8b, 0x51583473, 0x5144cb39, 
0x51315edd, 0x511def5f, 0x510a7cc1, 0x50f70703, 0x50e38e25, 0x50d0122a, 0x50bc9311, 0x50a910db, 
0x50958b88, 0x5082031b, 0x506e7793, 0x505ae8f1, 0x50475736, 0x5033c263, 0x50202a78, 0x500c8f77, 
0x4ff8f15f, 0x4fe55032, 0x4fd1abf0, 0x4fbe049b, 0x4faa5a33, 0x4f96acb8, 0x4f82fc2c, 0x4f6f488f, 
0x4f5b91e3, 0x4f47d827, 0x4f341b5c, 0x4f205b84, 0x4f0c989f, 0x4ef8d2ad, 0x4ee509b1, 0x4ed13da9, 
0x4ebd6e98, 0x4ea99c7d, 0x4e95c75b, 0x4e81ef30, 0x4e6e13ff, 0x4e5a35c7, 0x4e46548b, 0x4e32704a, 
0x4e1e8905, 0x4e0a9ebd, 0x4df6b173, 0x4de2c127, 0x4dcecdda, 0x4dbad78e, 0x4da6de43, 0x4d92e1f9, 
0x4d7ee2b1, 0x4d6ae06d, 0x4d56db2d, 0x4d42d2f1, 0x4d2ec7bb, 0x4d1ab98b, 0x4d06a862, 0x4cf29440, 
0x4cde7d28, 0x4cca6318, 0x4cb64613, 0x4ca22619, 0x4c8e032a, 0x4c79dd48, 0x4c65b473, 0x4c5188ac, 
0x4c3d59f3, 0x4c29284b, 0x4c14f3b2, 0x4c00bc2b, 0x4bec81b5, 0x4bd84453, 0x4bc40403, 0x4bafc0c8, 
0x4b9b7aa2, 0x4b873192, 0x4b72e598, 0x4b5e96b6, 0x4b4a44eb, 0x4b35f03a, 0x4b2198a2, 0x4b0d3e25, 
0x4af8e0c3, 0x4ae4807d, 0x4ad01d54, 0x4abbb749, 0x4aa74e5c, 0x4a92e28e, 0x4a7e73e0, 0x4a6a0253, 
0x4a558de8, 0x4a41169f, 0x4a2c9c79, 0x4a181f77, 0x4a039f9a, 0x49ef1ce2, 0x49da9750, 0x49c60ee6, 
0x49b183a3, 0x499cf589, 0x49886499, 0x4973d0d3, 0x495f3a38, 0x494aa0c9, 0x49360486, 0x49216571, 
0x490cc38a, 0x48f81ed2, 0x48e3774a, 0x48ceccf3, 0x48ba1fcd, 0x48a56fd9, 0x4890bd18, 0x487c078b, 
0x48674f33, 0x48529410, 0x483dd623, 0x4829156d, 0x481451ef, 0x47ff8baa, 0x47eac29e, 0x47d5f6cc, 
0x47c12835, 0x47ac56da, 0x479782bc, 0x4782abdb, 0x476dd239, 0x4758f5d5, 0x474416b1, 0x472f34ce, 
0x471a502c, 0x470568cd, 0x46f07eb0, 0x46db91d8, 0x46c6a244, 0x46b1aff5, 0x469cbaed, 0x4687c32c, 
0x4672c8b3, 0x465dcb82, 0x4648cb9b, 0x4633c8fe, 0x461ec3ad, 0x4609bba7, 0x45f4b0ee, 0x45dfa383, 
0x45ca9366, 0x45b58098, 0x45a06b1b, 0x458b52ee, 0x45763813, 0x45611a8a, 0x454bfa54, 0x4536d773, 
0x4521b1e6, 0x450c89af, 0x44f75ecf, 0x44e23145, 0x44cd0114, 0x44b7ce3c, 0x44a298be, 0x448d609b, 
0x447825d2, 0x4462e866, 0x444da858, 0x443865a7, 0x44232054, 0x440dd861, 0x43f88dcf, 0x43e3409d, 
0x43cdf0ce, 0x43b89e62, 0x43a34959, 0x438df1b4, 0x43789775, 0x43633a9c, 0x434ddb29, 0x4338791f, 
0x4323147d, 0x430dad44, 0x42f84376, 0x42e2d713, 0x42cd681b, 0x42b7f690, 0x42a28273, 0x428d0bc4, 
0x42779285, 0x426216b5, 0x424c9856, 0x42371769, 0x422193ee, 0x420c0de6, 0x41f68553, 0x41e0fa35, 
0x41cb6c8c, 0x41b5dc5a, 0x41a049a0, 0x418ab45d, 0x41751c94, 0x415f8245, 0x4149e571, 0x41344618, 
0x411ea43c, 0x4108ffdd, 0x40f358fc, 0x40ddaf9a, 0x40c803b8, 0x40b25557, 0x409ca477, 0x4086f11a, 
0x40713b3f, 0x405b82e9, 0x4045c817, 0x40300acb, 0x401a4b05, 0x400488c7, 0x3feec411, 0x3fd8fce4, 
0x3fc33341, 0x3fad6728, 0x3f97989c, 0x3f81c79b, 0x3f6bf428, 0x3f561e42, 0x3f4045ec, 0x3f2a6b25, 
0x3f148def, 0x3efeae4a, 0x3ee8cc38, 0x3ed2e7b9, 0x3ebd00cd, 0x3ea71777, 0x3e912bb6, 0x3e7b3d8b, 
0x3e654cf8, 0x3e4f59fe, 0x3e39649c, 0x3e236cd4, 0x3e0d72a6, 0x3df77615, 0x3de1771f, 0x3dcb75c7, 
0x3db5720d, 0x3d9f6bf2, 0x3d896377, 0x3d73589d, 0x3d5d4b64, 0x3d473bcd, 0x3d3129da, 0x3d1b158a, 
0x3d04fee0, 0x3ceee5db, 0x3cd8ca7d, 0x3cc2acc6, 0x3cac8cb8, 0x3c966a53, 0x3c804598, 0x3c6a1e87, 
0x3c53f523, 0x3c3dc96b, 0x3c279b61, 0x3c116b04, 0x3bfb3857, 0x3be5035a, 0x3bcecc0e, 0x3bb89274, 
0x3ba2568c, 0x3b8c1857, 0x3b75d7d7, 0x3b5f950c, 0x3b494ff7, 0x3b330899, 0x3b1cbef3, 0x3b067305, 
0x3af024d1, 0x3ad9d457, 0x3ac38198, 0x3aad2c95, 0x3a96d54f, 0x3a807bc7, 0x3a6a1ffd, 0x3a53c1f3, 
0x3a3d61a9, 0x3a26ff21, 0x3a109a5a, 0x39fa3356, 0x39e3ca17, 0x39cd5e9b, 0x39b6f0e6, 0x39a080f6, 
0x398a0ece, 0x39739a6e, 0x395d23d7, 0x3946ab0a, 0x39303008, 0x3919b2d1, 0x39033367, 0x38ecb1ca, 
0x38d62dfb, 0x38bfa7fb, 0x38a91fcb, 0x3892956c, 0x387c08de, 0x38657a23, 0x384ee93b, 0x38385628, 
0x3821c0ea, 0x380b2982, 0x37f48ff0, 0x37ddf437, 0x37c75656, 0x37b0b64e, 0x379a1421, 0x37836fcf, 
0x376cc959, 0x375620c1, 0x373f7606, 0x3728c929, 0x37121a2d, 0x36fb6910, 0x36e4b5d6, 0x36ce007d, 
0x36b74908, 0x36a08f76, 0x3689d3c9, 0x36731602, 0x365c5622, 0x36459429, 0x362ed019, 0x361809f1, 
0x360141b4, 0x35ea7762, 0x35d3aafc, 0x35bcdc82, 0x35a60bf6, 0x358f3959, 0x357864ab, 0x35618ded, 
0x354ab520, 0x3533da46, 0x351cfd5e, 0x35061e6a, 0x34ef3d6b, 0x34d85a62, 0x34c1754e, 0x34aa8e33, 
0x3493a50f, 0x347cb9e4, 0x3465ccb4, 0x344edd7e, 0x3437ec44, 0x3420f907, 0x340a03c7, 0x33f30c85, 
0x33dc1343, 0x33c51801, 0x33ae1ac0, 0x33971b81, 0x33801a45, 0x3369170c, 0x335211d8, 0x333b0aaa, 
0x33240182, 0x330cf661, 0x32f5e948, 0x32deda39, 0x32c7c933, 0x32b0b638, 0x3299a149, 0x32828a67, 
0x326b7192, 0x325456cb, 0x323d3a14, 0x32261b6c, 0x320efad6, 0x31f7d852, 0x31e0b3e0, 0x31c98d83, 
0x31b2653a, 0x319b3b06, 0x31840ee9, 0x316ce0e3, 0x3155b0f5, 0x313e7f21, 0x31274b66, 0x311015c6, 
0x30f8de42, 0x30e1a4db, 0x30ca6991, 0x30b32c66, 0x309bed5a, 0x3084ac6e, 0x306d69a4, 0x305624fb, 
0x303ede76, 0x30279614, 0x30104bd7, 0x2ff8ffc0, 0x2fe1b1cf, 0x2fca6206, 0x2fb31064, 0x2f9bbced, 
0x2f84679f, 0x2f6d107c, 0x2f55b785, 0x2f3e5cbb, 0x2f27001f, 0x2f0fa1b2, 0x2ef84173, 0x2ee0df66, 
0x2ec97b89, 0x2eb215df, 0x2e9aae68, 0x2e834525, 0x2e6bda17, 0x2e546d3f, 0x2e3cfe9e, 0x2e258e34, 
0x2e0e1c03, 0x2df6a80b, 0x2ddf324e, 0x2dc7bacc, 0x2db04186, 0x2d98c67d, 0x2d8149b2, 0x2d69cb26, 
0x2d524ada, 0x2d3ac8ce, 0x2d234504, 0x2d0bbf7d, 0x2cf43839, 0x2cdcaf39, 0x2cc5247e, 0x2cad980a, 
0x2c9609dd, 0x2c7e79f7, 0x2c66e85b, 0x2c4f5508, 0x2c37c000, 0x2c202944, 0x2c0890d4, 0x2bf0f6b1, 
0x2bd95add, 0x2bc1bd58, 0x2baa1e23, 0x2b927d3f, 0x2b7adaae, 0x2b63366f, 0x2b4b9083, 0x2b33e8ed, 
0x2b1c3fac, 0x2b0494c2, 0x2aece82f, 0x2ad539f4, 0x2abd8a13, 0x2aa5d88b, 0x2a8e255f, 0x2a76708f, 
0x2a5eba1c, 0x2a470207, 0x2a2f4850, 0x2a178cf9, 0x29ffd003, 0x29e8116e, 0x29d0513b, 0x29b88f6c, 
0x29a0cc01, 0x298906fb, 0x2971405b, 0x29597823, 0x2941ae52, 0x2929e2ea, 0x291215eb, 0x28fa4758, 
0x28e27730, 0x28caa574, 0x28b2d226, 0x289afd46, 0x288326d5, 0x286b4ed5, 0x28537545, 0x283b9a28, 
0x2823bd7d, 0x280bdf46, 0x27f3ff85, 0x27dc1e38, 0x27c43b63, 0x27ac5705, 0x2794711f, 0x277c89b3, 
0x2764a0c0, 0x274cb64a, 0x2734ca4f, 0x271cdcd1, 0x2704edd2, 0x26ecfd51, 0x26d50b50, 0x26bd17d0, 
0x26a522d1, 0x268d2c55, 0x2675345d, 0x265d3ae9, 0x26453ffa, 0x262d4392, 0x261545b0, 0x25fd4657, 
0x25e54587, 0x25cd4341, 0x25b53f86, 0x259d3a57, 0x258533b5, 0x256d2ba0, 0x2555221a, 0x253d1723, 
0x25250abd, 0x250cfce8, 0x24f4eda6, 0x24dcdcf6, 0x24c4cadb, 0x24acb756, 0x2494a266, 0x247c8c0d, 
0x2464744c, 0x244c5b24, 0x24344095, 0x241c24a1, 0x24040749, 0x23ebe88e, 0x23d3c86f, 0x23bba6f0, 
0x23a3840f, 0x238b5fcf, 0x23733a30, 0x235b1333, 0x2342eada, 0x232ac124, 0x23129613, 0x22fa69a8, 
0x22e23be4, 0x22ca0cc7, 0x22b1dc53, 0x2299aa89, 0x22817769, 0x226942f5, 0x22510d2d, 0x2238d612, 
0x22209da5, 0x220863e8, 0x21f028db, 0x21d7ec7f, 0x21bfaed5, 0x21a76fdd, 0x218f2f9a, 0x2176ee0b, 
0x215eab33, 0x21466710, 0x212e21a6, 0x2115daf4, 0x20fd92fb, 0x20e549bd, 0x20ccff3a, 0x20b4b373, 
0x209c666a, 0x2084181e, 0x206bc892, 0x205377c6, 0x203b25bb, 0x2022d271, 0x200a7deb, 0x1ff22828, 
0x1fd9d12a, 0x1fc178f1, 0x1fa91f80, 0x1f90c4d5, 0x1f7868f3, 0x1f600bdb, 0x1f47ad8d, 0x1f2f4e0a, 
0x1f16ed53, 0x1efe8b6a, 0x1ee6284f, 0x1ecdc402, 0x1eb55e86, 0x1e9cf7db, 0x1e849001, 0x1e6c26fa, 
0x1e53bcc7, 0x1e3b5169, 0x1e22e4e0, 0x1e0a772e, 0x1df20853, 0x1dd99851, 0x1dc12729, 0x1da8b4da, 
0x1d904167, 0x1d77ccd0, 0x1d5f5716, 0x1d46e03a, 0x1d2e683e, 0x1d15ef21, 0x1cfd74e5, 0x1ce4f98c, 
0x1ccc7d15, 0x1cb3ff81, 0x1c9b80d3, 0x1c83010a, 0x1c6a8028, 0x1c51fe2d, 0x1c397b1b, 0x1c20f6f2, 
0x1c0871b4, 0x1befeb60, 0x1bd763fa, 0x1bbedb80, 0x1ba651f5, 0x1b8dc758, 0x1b753bac, 0x1b5caef1, 
0x1b442127, 0x1b2b9251, 0x1b13026e, 0x1afa7180, 0x1ae1df88, 0x1ac94c87, 0x1ab0b87d, 0x1a98236c, 
0x1a7f8d54, 0x1a66f637, 0x1a4e5e15, 0x1a35c4f0, 0x1a1d2ac8, 0x1a048f9e, 0x19ebf374, 0x19d35649, 
0x19bab820, 0x19a218f9, 0x198978d4, 0x1970d7b4, 0x19583599, 0x193f9283, 0x1926ee74, 0x190e496d, 
0x18f5a36f, 0x18dcfc7b, 0x18c45491, 0x18ababb2, 0x189301e0, 0x187a571c, 0x1861ab66, 0x1848febf, 
0x18305129, 0x1817a2a4, 0x17fef331, 0x17e642d1, 0x17cd9185, 0x17b4df4f, 0x179c2c2f, 0x17837825, 
0x176ac333, 0x17520d5b, 0x1739569c, 0x17209ef8, 0x1707e670, 0x16ef2d04, 0x16d672b6, 0x16bdb787, 
0x16a4fb77, 0x168c3e87, 0x167380ba, 0x165ac20e, 0x16420286, 0x16294222, 0x161080e4, 0x15f7becc, 
0x15defbdb, 0x15c63812, 0x15ad7372, 0x1594adfc, 0x157be7b1, 0x15632093, 0x154a58a1, 0x15318fdd, 
0x1518c648, 0x14fffbe2, 0x14e730ad, 0x14ce64ab, 0x14b597da, 0x149cca3e, 0x1483fbd5, 0x146b2ca3, 
0x14525ca7, 0x14398be2, 0x1420ba56, 0x1407e803, 0x13ef14ea, 0x13d6410d, 0x13bd6c6b, 0x13a49707, 
0x138bc0e1, 0x1372e9fb, 0x135a1254, 0x134139ee, 0x132860ca, 0x130f86ea, 0x12f6ac4d, 0x12ddd0f4, 
0x12c4f4e2, 0x12ac1817, 0x12933a93, 0x127a5c57, 0x12617d66, 0x12489dbf, 0x122fbd63, 0x1216dc54, 
0x11fdfa93, 0x11e51820, 0x11cc34fc, 0x11b35129, 0x119a6ca7, 0x11818777, 0x1168a19b, 0x114fbb12, 
0x1136d3df, 0x111dec02, 0x1105037c, 0x10ec1a4e, 0x10d33079, 0x10ba45fe, 0x10a15ade, 0x10886f19, 
0x106f82b2, 0x105695a8, 0x103da7fd, 0x1024b9b2, 0x100bcac7, 0x0ff2db3e, 0x0fd9eb18, 0x0fc0fa55, 
0x0fa808f7, 0x0f8f16fe, 0x0f76246c, 0x0f5d3141, 0x0f443d7e, 0x0f2b4925, 0x0f125436, 0x0ef95eb2, 
0x0ee0689b, 0x0ec771f0, 0x0eae7ab4, 0x0e9582e7, 0x0e7c8a8a, 0x0e63919e, 0x0e4a9824, 0x0e319e1d, 
0x0e18a38a, 0x0dffa86b, 0x0de6acc3, 0x0dcdb091, 0x0db4b3d7, 0x0d9bb696, 0x0d82b8cf, 0x0d69ba82, 
0x0d50bbb1, 0x0d37bc5c, 0x0d1ebc85, 0x0d05bc2d, 0x0cecbb53, 0x0cd3b9fb, 0x0cbab824, 0x0ca1b5cf, 
0x0c88b2fd, 0x0c6fafb0, 0x0c56abe8, 0x0c3da7a6, 0x0c24a2eb, 0x0c0b9db9, 0x0bf29810, 0x0bd991f0, 
0x0bc08b5c, 0x0ba78454, 0x0b8e7cd9, 0x0b7574ec, 0x0b5c6c8d, 0x0b4363bf, 0x0b2a5a81, 0x0b1150d5, 
0x0af846bc, 0x0adf3c37, 0x0ac63146, 0x0aad25eb, 0x0a941a27, 0x0a7b0dfa, 0x0a620166, 0x0a48f46b, 
0x0a2fe70b, 0x0a16d946, 0x09fdcb1e, 0x09e4bc93, 0x09cbada6, 0x09b29e59, 0x09998eac, 0x09807ea1, 
0x09676e37, 0x094e5d71, 0x09354c4f, 0x091c3ad2, 0x090328fb, 0x08ea16cb, 0x08d10443, 0x08b7f164, 
0x089ede2f, 0x0885caa5, 0x086cb6c7, 0x0853a296, 0x083a8e12, 0x0821793e, 0x08086419, 0x07ef4ea4, 
0x07d638e2, 0x07bd22d2, 0x07a40c76, 0x078af5ce, 0x0771dedc, 0x0758c7a0, 0x073fb01c, 0x07269851, 
0x070d803f, 0x06f467e7, 0x06db4f4a, 0x06c2366a, 0x06a91d47, 0x069003e3, 0x0676ea3d, 0x065dd058, 
0x0644b634, 0x062b9bd3, 0x06128134, 0x05f96659, 0x05e04b43, 0x05c72ff4, 0x05ae146b, 0x0594f8aa, 
0x057bdcb3, 0x0562c085, 0x0549a422, 0x0530878a, 0x05176ac0, 0x04fe4dc3, 0x04e53095, 0x04cc1337, 
0x04b2f5a9, 0x0499d7ed, 0x0480ba04, 0x04679bee, 0x044e7dac, 0x04355f40, 0x041c40ab, 0x040321ed, 
0x03ea0307, 0x03d0e3fb, 0x03b7c4c9, 0x039ea573, 0x038585f8, 0x036c665b, 0x0353469c, 0x033a26bd, 
0x032106bd, 0x0307e69f, 0x02eec663, 0x02d5a609, 0x02bc8594, 0x02a36504, 0x028a445a, 0x02712396, 
0x025802bb, 0x023ee1c8, 0x0225c0bf, 0x020c9fa1, 0x01f37e6f, 0x01da5d2a, 0x01c13bd2, 0x01a81a69, 
0x018ef8f0, 0x0175d767, 0x015cb5d0, 0x0143942b, 0x012a727a, 0x011150bd, 0x00f82ef6, 0x00df0d26, 
0x00c5eb4c, 0x00acc96b, 0x0093a784, 0x007a8597, 0x006163a4, 0x004841af, 0x002f1fb6, 0x0015fdbc, 
};

#if defined(RADIAX) && defined(AE) && defined(DMA)
DATA_TYPE VorbisdecXs2048[2048] AE_ALIGN8 AE_GNU_SECTION(".vorbisdec_sdram_data_xs2048") =
#else
DATA_TYPE VorbisdecXs2048[2048]=
#endif /* RADIAX && AE && DMA */
{
0x0003243f, 0x001c463b, 0x00356835, 0x004e8a2c, 0x0067ac21, 0x0080ce12, 0x0099effe, 0x00b311e4, 
0x00cc33c3, 0x00e5559b, 0x00fe7769, 0x0117992e, 0x0130bae7, 0x0149dc96, 0x0162fe37, 0x017c1fcb, 
0x01954150, 0x01ae62c5, 0x01c7842a, 0x01e0a57d, 0x01f9c6be, 0x0212e7eb, 0x022c0904, 0x02452a07, 
0x025e4af4, 0x02776bc9, 0x02908c87, 0x02a9ad2a, 0x02c2cdb4, 0x02dbee22, 0x02f50e74, 0x030e2ea9, 
0x03274ec0, 0x03406eb8, 0x03598e8f, 0x0372ae46, 0x038bcdda, 0x03a4ed4c, 0x03be0c99, 0x03d72bc2, 
0x03f04ac4, 0x040969a0, 0x04228854, 0x043ba6df, 0x0454c541, 0x046de377, 0x04870182, 0x04a01f60, 
0x04b93d11, 0x04d25a93, 0x04eb77e5, 0x05049507, 0x051db1f7, 0x0536ceb5, 0x054feb3f, 0x05690795, 
0x058223b6, 0x059b3fa0, 0x05b45b53, 0x05cd76cd, 0x05e6920e, 0x05ffad15, 0x0618c7e1, 0x0631e271, 
0x064afcc3, 0x066416d8, 0x067d30ad, 0x06964a42, 0x06af6396, 0x06c87ca9, 0x06e19578, 0x06faae03, 
0x0713c64a, 0x072cde4a, 0x0745f604, 0x075f0d76, 0x077824a0, 0x07913b7f, 0x07aa5214, 0x07c3685d, 
0x07dc7e5a, 0x07f59409, 0x080ea969, 0x0827be7a, 0x0840d33b, 0x0859e7aa, 0x0872fbc6, 0x088c0f90, 
0x08a52304, 0x08be3624, 0x08d748ed, 0x08f05b5f, 0x09096d79, 0x09227f39, 0x093b90a0, 0x0954a1ab, 
0x096db25a, 0x0986c2ac, 0x099fd2a0, 0x09b8e236, 0x09d1f16b, 0x09eb003f, 0x0a040eb1, 0x0a1d1cc1, 
0x0a362a6d, 0x0a4f37b3, 0x0a684495, 0x0a81510f, 0x0a9a5d22, 0x0ab368cc, 0x0acc740c, 0x0ae57ee2, 
0x0afe894d, 0x0b17934b, 0x0b309cdb, 0x0b49a5fd, 0x0b62aeaf, 0x0b7bb6f2, 0x0b94bec2, 0x0badc621, 
0x0bc6cd0c, 0x0bdfd383, 0x0bf8d985, 0x0c11df11, 0x0c2ae425, 0x0c43e8c2, 0x0c5cece5, 0x0c75f08f, 
0x0c8ef3bd, 0x0ca7f670, 0x0cc0f8a5, 0x0cd9fa5d, 0x0cf2fb96, 0x0d0bfc4f, 0x0d24fc87, 0x0d3dfc3e, 
0x0d56fb71, 0x0d6ffa22, 0x0d88f84d, 0x0da1f5f3, 0x0dbaf313, 0x0dd3efab, 0x0decebba, 0x0e05e740, 
0x0e1ee23c, 0x0e37dcac, 0x0e50d690, 0x0e69cfe6, 0x0e82c8af, 0x0e9bc0e8, 0x0eb4b891, 0x0ecdafa9, 
0x0ee6a62f, 0x0eff9c21, 0x0f189180, 0x0f318649, 0x0f4a7a7d, 0x0f636e1a, 0x0f7c611f, 0x0f95538b, 
0x0fae455d, 0x0fc73695, 0x0fe02730, 0x0ff91730, 0x10120691, 0x102af554, 0x1043e377, 0x105cd0fa, 
0x1075bddb, 0x108eaa1a, 0x10a795b5, 0x10c080ac, 0x10d96afe, 0x10f254a9, 0x110b3dad, 0x11242609, 
0x113d0dbc, 0x1155f4c4, 0x116edb22, 0x1187c0d3, 0x11a0a5d8, 0x11b98a2e, 0x11d26dd6, 0x11eb50cd, 
0x12043314, 0x121d14a9, 0x1235f58b, 0x124ed5ba, 0x1267b533, 0x128093f7, 0x12997205, 0x12b24f5b, 
0x12cb2bf8, 0x12e407dc, 0x12fce305, 0x1315bd73, 0x132e9725, 0x1347701a, 0x13604850, 0x13791fc6, 
0x1391f67d, 0x13aacc73, 0x13c3a1a6, 0x13dc7616, 0x13f549c3, 0x140e1caa, 0x1426eecb, 0x143fc026, 
0x145890b9, 0x14716082, 0x148a2f82, 0x14a2fdb8, 0x14bbcb22, 0x14d497bf, 0x14ed638e, 0x15062e8f, 
0x151ef8c0, 0x1537c221, 0x15508ab1, 0x1569526e, 0x15821958, 0x159adf6e, 0x15b3a4ae, 0x15cc6918, 
0x15e52cab, 0x15fdef66, 0x1616b148, 0x162f7250, 0x1648327d, 0x1660f1ce, 0x1679b042, 0x16926dd8, 
0x16ab2a90, 0x16c3e667, 0x16dca15f, 0x16f55b74, 0x170e14a7, 0x1726ccf6, 0x173f8461, 0x17583ae7, 
0x1770f086, 0x1789a53d, 0x17a2590d, 0x17bb0bf3, 0x17d3bdee, 0x17ec6eff, 0x18051f24, 0x181dce5b, 
0x18367ca5, 0x184f29ff, 0x1867d66a, 0x188081e4, 0x18992c6b, 0x18b1d601, 0x18ca7ea2, 0x18e3264f, 
0x18fbcd06, 0x191472c6, 0x192d178f, 0x1945bb60, 0x195e5e37, 0x19770014, 0x198fa0f5, 0x19a840da, 
0x19c0dfc2, 0x19d97dac, 0x19f21a96, 0x1a0ab681, 0x1a23516a, 0x1a3beb52, 0x1a548436, 0x1a6d1c17, 
0x1a85b2f3, 0x1a9e48c9, 0x1ab6dd98, 0x1acf7160, 0x1ae8041f, 0x1b0095d5, 0x1b192680, 0x1b31b620, 
0x1b4a44b3, 0x1b62d239, 0x1b7b5eb0, 0x1b93ea19, 0x1bac7471, 0x1bc4fdb8, 0x1bdd85ed, 0x1bf60d0f, 
0x1c0e931d, 0x1c271816, 0x1c3f9bf9, 0x1c581ec6, 0x1c70a07b, 0x1c892117, 0x1ca1a099, 0x1cba1f01, 
0x1cd29c4d, 0x1ceb187d, 0x1d03938f, 0x1d1c0d83, 0x1d348658, 0x1d4cfe0d, 0x1d6574a0, 0x1d7dea11, 
0x1d965e5f, 0x1daed189, 0x1dc7438e, 0x1ddfb46e, 0x1df82426, 0x1e1092b6, 0x1e29001e, 0x1e416c5d, 
0x1e59d770, 0x1e724158, 0x1e8aaa14, 0x1ea311a2, 0x1ebb7802, 0x1ed3dd32, 0x1eec4132, 0x1f04a401, 
0x1f1d059e, 0x1f356608, 0x1f4dc53d, 0x1f66233e, 0x1f7e8009, 0x1f96db9d, 0x1faf35f9, 0x1fc78f1d, 
0x1fdfe707, 0x1ff83db6, 0x2010932a, 0x2028e761, 0x20413a5b, 0x20598c17, 0x2071dc93, 0x208a2bcf, 
0x20a279ca, 0x20bac683, 0x20d311f9, 0x20eb5c2b, 0x2103a518, 0x211becbf, 0x2134331f, 0x214c7838, 
0x2164bc08, 0x217cfe8e, 0x21953fca, 0x21ad7fba, 0x21c5be5e, 0x21ddfbb5, 0x21f637be, 0x220e7277, 
0x2226abe0, 0x223ee3f8, 0x22571abe, 0x226f5032, 0x22878451, 0x229fb71b, 0x22b7e890, 0x22d018ae, 
0x22e84775, 0x230074e3, 0x2318a0f8, 0x2330cbb2, 0x2348f511, 0x23611d13, 0x237943b9, 0x23916900, 
0x23a98ce8, 0x23c1af71, 0x23d9d098, 0x23f1f05e, 0x240a0ec1, 0x24222bc0, 0x243a475a, 0x2452618f, 
0x246a7a5e, 0x248291c5, 0x249aa7c4, 0x24b2bc59, 0x24cacf84, 0x24e2e144, 0x24faf198, 0x25130080, 
0x252b0df9, 0x25431a03, 0x255b249e, 0x25732dc8, 0x258b3580, 0x25a33bc6, 0x25bb4098, 0x25d343f6, 
0x25eb45de, 0x26034651, 0x261b454c, 0x263342cf, 0x264b3ed9, 0x26633969, 0x267b327e, 0x26932a18, 
0x26ab2035, 0x26c314d4, 0x26db07f4, 0x26f2f995, 0x270ae9b6, 0x2722d855, 0x273ac572, 0x2752b10c, 
0x276a9b21, 0x278283b2, 0x279a6abd, 0x27b25041, 0x27ca343d, 0x27e216b0, 0x27f9f79a, 0x2811d6f9, 
0x2829b4cd, 0x28419114, 0x28596bce, 0x287144fa, 0x28891c97, 0x28a0f2a3, 0x28b8c71f, 0x28d09a09, 
0x28e86b5f, 0x29003b23, 0x29180951, 0x292fd5ea, 0x2947a0ec, 0x295f6a57, 0x2977322a, 0x298ef863, 
0x29a6bd02, 0x29be8007, 0x29d6416f, 0x29ee013a, 0x2a05bf67, 0x2a1d7bf6, 0x2a3536e5, 0x2a4cf033, 
0x2a64a7e0, 0x2a7c5deb, 0x2a941252, 0x2aabc515, 0x2ac37633, 0x2adb25aa, 0x2af2d37b, 0x2b0a7fa4, 
0x2b222a24, 0x2b39d2fa, 0x2b517a26, 0x2b691fa6, 0x2b80c37a, 0x2b9865a1, 0x2bb00619, 0x2bc7a4e2, 
0x2bdf41fb, 0x2bf6dd63, 0x2c0e7719, 0x2c260f1c, 0x2c3da56b, 0x2c553a06, 0x2c6ccceb, 0x2c845e1a, 
0x2c9bed91, 0x2cb37b51, 0x2ccb0756, 0x2ce291a2, 0x2cfa1a33, 0x2d11a108, 0x2d292620, 0x2d40a97b, 
0x2d582b17, 0x2d6faaf3, 0x2d87290f, 0x2d9ea569, 0x2db62001, 0x2dcd98d7, 0x2de50fe8, 0x2dfc8534, 
0x2e13f8ba, 0x2e2b6a79, 0x2e42da71, 0x2e5a48a0, 0x2e71b506, 0x2e891fa1, 0x2ea08871, 0x2eb7ef75, 
0x2ecf54ac, 0x2ee6b815, 0x2efe19ae, 0x2f157979, 0x2f2cd772, 0x2f44339a, 0x2f5b8def, 0x2f72e671, 
0x2f8a3d1e, 0x2fa191f7, 0x2fb8e4f9, 0x2fd03624, 0x2fe78577, 0x2ffed2f2, 0x30161e93, 0x302d6859, 
0x3044b044, 0x305bf652, 0x30733a83, 0x308a7cd6, 0x30a1bd4a, 0x30b8fbde, 0x30d03891, 0x30e77362, 
0x30feac51, 0x3115e35c, 0x312d1882, 0x31444bc3, 0x315b7d1e, 0x3172ac92, 0x3189da1e, 0x31a105c1, 
0x31b82f7a, 0x31cf5748, 0x31e67d2b, 0x31fda121, 0x3214c32a, 0x322be345, 0x32430170, 0x325a1dab, 
0x327137f6, 0x3288504e, 0x329f66b4, 0x32b67b26, 0x32cd8da4, 0x32e49e2c, 0x32fbacbe, 0x3312b959, 
0x3329c3fb, 0x3340cca5, 0x3357d355, 0x336ed80a, 0x3385dac4, 0x339cdb81, 0x33b3da40, 0x33cad701, 
0x33e1d1c4, 0x33f8ca86, 0x340fc147, 0x3426b606, 0x343da8c3, 0x3454997c, 0x346b8830, 0x348274e0, 
0x34995f88, 0x34b0482a, 0x34c72ec4, 0x34de1355, 0x34f4f5dc, 0x350bd658, 0x3522b4c9, 0x3539912e, 
0x35506b85, 0x356743ce, 0x357e1a08, 0x3594ee32, 0x35abc04b, 0x35c29052, 0x35d95e47, 0x35f02a28, 
0x3606f3f5, 0x361dbbad, 0x3634814f, 0x364b44da, 0x3662064c, 0x3678c5a7, 0x368f82e7, 0x36a63e0d, 
0x36bcf718, 0x36d3ae06, 0x36ea62d7, 0x3701158a, 0x3717c61f, 0x372e7493, 0x374520e7, 0x375bcb1a, 
0x3772732a, 0x37891917, 0x379fbce0, 0x37b65e84, 0x37ccfe02, 0x37e39b59, 0x37fa3688, 0x3810cf90, 
0x3827666d, 0x383dfb21, 0x38548daa, 0x386b1e06, 0x3881ac36, 0x38983838, 0x38aec20b, 0x38c549af, 
0x38dbcf23, 0x38f25266, 0x3908d376, 0x391f5254, 0x3935cefd, 0x394c4973, 0x3962c1b2, 0x397937bc, 
0x398fab8e, 0x39a61d28, 0x39bc8c89, 0x39d2f9b0, 0x39e9649c, 0x39ffcd4d, 0x3a1633c1, 0x3a2c97f9, 
0x3a42f9f2, 0x3a5959ab, 0x3a6fb726, 0x3a86125f, 0x3a9c6b57, 0x3ab2c20c, 0x3ac9167e, 0x3adf68ac, 
0x3af5b894, 0x3b0c0637, 0x3b225193, 0x3b389aa8, 0x3b4ee173, 0x3b6525f6, 0x3b7b682e, 0x3b91a81c, 
0x3ba7e5bd, 0x3bbe2112, 0x3bd45a19, 0x3bea90d1, 0x3c00c53a, 0x3c16f753, 0x3c2d271b, 0x3c435491, 
0x3c597fb4, 0x3c6fa883, 0x3c85cefe, 0x3c9bf324, 0x3cb214f4, 0x3cc8346c, 0x3cde518d, 0x3cf46c55, 
0x3d0a84c3, 0x3d209ad7, 0x3d36ae8f, 0x3d4cbfeb, 0x3d62ceeb, 0x3d78db8c, 0x3d8ee5cf, 0x3da4edb2, 
0x3dbaf335, 0x3dd0f656, 0x3de6f716, 0x3dfcf572, 0x3e12f16b, 0x3e28eaff, 0x3e3ee22e, 0x3e54d6f6, 
0x3e6ac957, 0x3e80b950, 0x3e96a6e0, 0x3eac9206, 0x3ec27ac2, 0x3ed86113, 0x3eee44f7, 0x3f04266e, 
0x3f1a0577, 0x3f2fe211, 0x3f45bc3c, 0x3f5b93f6, 0x3f71693f, 0x3f873c16, 0x3f9d0c7a, 0x3fb2da6a, 
0x3fc8a5e5, 0x3fde6eeb, 0x3ff4357a, 0x4009f992, 0x401fbb32, 0x40357a59, 0x404b3707, 0x4060f13a, 
0x4076a8f1, 0x408c5e2d, 0x40a210eb, 0x40b7c12b, 0x40cd6eed, 0x40e31a2f, 0x40f8c2f1, 0x410e6931, 
0x41240cef, 0x4139ae2b, 0x414f4ce2, 0x4164e916, 0x417a82c3, 0x419019eb, 0x41a5ae8b, 0x41bb40a3, 
0x41d0d033, 0x41e65d39, 0x41fbe7b5, 0x42116fa5, 0x4226f50a, 0x423c77e1, 0x4251f82b, 0x426775e6, 
0x427cf112, 0x429269ae, 0x42a7dfb8, 0x42bd5331, 0x42d2c417, 0x42e83269, 0x42fd9e28, 0x43130751, 
0x43286de4, 0x433dd1e0, 0x43533344, 0x43689210, 0x437dee43, 0x439347dc, 0x43a89ed9, 0x43bdf33b, 
0x43d34501, 0x43e89429, 0x43fde0b2, 0x44132a9d, 0x442871e8, 0x443db692, 0x4452f89b, 0x44683801, 
0x447d74c4, 0x4492aee3, 0x44a7e65d, 0x44bd1b32, 0x44d24d60, 0x44e77ce7, 0x44fca9c6, 0x4511d3fd, 
0x4526fb89, 0x453c206b, 0x455142a2, 0x4566622c, 0x457b7f0a, 0x45909939, 0x45a5b0bb, 0x45bac58c, 
0x45cfd7ae, 0x45e4e71f, 0x45f9f3dd, 0x460efde9, 0x46240542, 0x463909e7, 0x464e0bd6, 0x46630b0f, 
0x46780792, 0x468d015d, 0x46a1f870, 0x46b6ecca, 0x46cbde6a, 0x46e0cd4f, 0x46f5b979, 0x470aa2e6, 
0x471f8996, 0x47346d89, 0x47494ebc, 0x475e2d30, 0x477308e3, 0x4787e1d6, 0x479cb806, 0x47b18b74, 
0x47c65c1d, 0x47db2a03, 0x47eff523, 0x4804bd7e, 0x48198311, 0x482e45dd, 0x484305e1, 0x4857c31b, 
0x486c7d8c, 0x48813531, 0x4895ea0b, 0x48aa9c19, 0x48bf4b59, 0x48d3f7cc, 0x48e8a170, 0x48fd4844, 
0x4911ec47, 0x49268d7a, 0x493b2bdb, 0x494fc768, 0x49646023, 0x4978f609, 0x498d8919, 0x49a21954, 
0x49b6a6b8, 0x49cb3145, 0x49dfb8f9, 0x49f43dd4, 0x4a08bfd5, 0x4a1d3efc, 0x4a31bb47, 0x4a4634b6, 
0x4a5aab48, 0x4a6f1efc, 0x4a838fd1, 0x4a97fdc7, 0x4aac68dc, 0x4ac0d111, 0x4ad53664, 0x4ae998d4, 
0x4afdf861, 0x4b12550a, 0x4b26aece, 0x4b3b05ac, 0x4b4f59a4, 0x4b63aab4, 0x4b77f8dc, 0x4b8c441c, 
0x4ba08c72, 0x4bb4d1dd, 0x4bc9145d, 0x4bdd53f2, 0x4bf19099, 0x4c05ca53, 0x4c1a011f, 0x4c2e34fb, 
0x4c4265e8, 0x4c5693e4, 0x4c6abeef, 0x4c7ee707, 0x4c930c2d, 0x4ca72e5e, 0x4cbb4d9b, 0x4ccf69e3, 
0x4ce38335, 0x4cf79990, 0x4d0bacf3, 0x4d1fbd5e, 0x4d33cad0, 0x4d47d547, 0x4d5bdcc4, 0x4d6fe146, 
0x4d83e2cb, 0x4d97e153, 0x4dabdcdd, 0x4dbfd569, 0x4dd3caf6, 0x4de7bd82, 0x4dfbad0d, 0x4e0f9997, 
0x4e23831e, 0x4e3769a2, 0x4e4b4d22, 0x4e5f2d9e, 0x4e730b14, 0x4e86e583, 0x4e9abcec, 0x4eae914d, 
0x4ec262a5, 0x4ed630f4, 0x4ee9fc39, 0x4efdc473, 0x4f1189a1, 0x4f254bc3, 0x4f390ad8, 0x4f4cc6df, 
0x4f607fd7, 0x4f7435c0, 0x4f87e899, 0x4f9b9861, 0x4faf4517, 0x4fc2eeba, 0x4fd6954b, 0x4fea38c7, 
0x4ffdd92f, 0x50117681, 0x502510bd, 0x5038a7e2, 0x504c3bef, 0x505fcce4, 0x50735abf, 0x5086e581, 
0x509a6d28, 0x50adf1b3, 0x50c17322, 0x50d4f173, 0x50e86ca8, 0x50fbe4bd, 0x510f59b3, 0x5122cb8a, 
0x51363a3f, 0x5149a5d3, 0x515d0e45, 0x51707393, 0x5183d5be, 0x519734c4, 0x51aa90a5, 0x51bde960, 
0x51d13ef5, 0x51e49162, 0x51f7e0a6, 0x520b2cc2, 0x521e75b3, 0x5231bb7b, 0x5244fe17, 0x52583d87, 
0x526b79ca, 0x527eb2e0, 0x5291e8c8, 0x52a51b81, 0x52b84b0a, 0x52cb7763, 0x52dea08a, 0x52f1c680, 
0x5304e943, 0x531808d3, 0x532b252f, 0x533e3e55, 0x53515447, 0x53646701, 0x53777685, 0x538a82d1, 
0x539d8be5, 0x53b091bf, 0x53c3945f, 0x53d693c5, 0x53e98fef, 0x53fc88dd, 0x540f7e8e, 0x54227102, 
0x54356037, 0x54484c2d, 0x545b34e3, 0x546e1a58, 0x5480fc8c, 0x5493db7f, 0x54a6b72e, 0x54b98f9a, 
0x54cc64c2, 0x54df36a5, 0x54f20542, 0x5504d099, 0x551798a8, 0x552a5d70, 0x553d1ef0, 0x554fdd26, 
0x55629812, 0x55754fb3, 0x55880409, 0x559ab513, 0x55ad62d0, 0x55c00d3f, 0x55d2b460, 0x55e55832, 
0x55f7f8b4, 0x560a95e6, 0x561d2fc6, 0x562fc655, 0x56425991, 0x5654e979, 0x5667760e, 0x5679ff4e, 
0x568c8538, 0x569f07cc, 0x56b18709, 0x56c402ef, 0x56d67b7c, 0x56e8f0b0, 0x56fb628b, 0x570dd10a, 
0x57203c2f, 0x5732a3f8, 0x57450864, 0x57576973, 0x5769c724, 0x577c2176, 0x578e7869, 0x57a0cbfb, 
0x57b31c2d, 0x57c568fd, 0x57d7b26b, 0x57e9f876, 0x57fc3b1d, 0x580e7a60, 0x5820b63e, 0x5832eeb6, 
0x584523c7, 0x58575571, 0x586983b4, 0x587bae8d, 0x588dd5fe, 0x589ffa04, 0x58b21aa0, 0x58c437d1, 
0x58d65195, 0x58e867ed, 0x58fa7ad7, 0x590c8a53, 0x591e9660, 0x59309efd, 0x5942a42a, 0x5954a5e6, 
0x5966a431, 0x59789f09, 0x598a966e, 0x599c8a60, 0x59ae7add, 0x59c067e4, 0x59d25176, 0x59e43792, 
0x59f61a36, 0x5a07f963, 0x5a19d517, 0x5a2bad51, 0x5a3d8212, 0x5a4f5358, 0x5a612123, 0x5a72eb71, 
0x5a84b243, 0x5a967598, 0x5aa8356f, 0x5ab9f1c6, 0x5acbaa9f, 0x5add5ff7, 0x5aef11cf, 0x5b00c025, 
0x5b126af8, 0x5b241249, 0x5b35b617, 0x5b475660, 0x5b58f324, 0x5b6a8c63, 0x5b7c221c, 0x5b8db44d, 
0x5b9f42f7, 0x5bb0ce19, 0x5bc255b2, 0x5bd3d9c1, 0x5be55a46, 0x5bf6d740, 0x5c0850ae, 0x5c19c690, 
0x5c2b38e5, 0x5c3ca7ad, 0x5c4e12e5, 0x5c5f7a8f, 0x5c70deaa, 0x5c823f34, 0x5c939c2c, 0x5ca4f594, 
0x5cb64b68, 0x5cc79daa, 0x5cd8ec58, 0x5cea3772, 0x5cfb7ef7, 0x5d0cc2e6, 0x5d1e033e, 0x5d2f4000, 
0x5d40792a, 0x5d51aebb, 0x5d62e0b4, 0x5d740f12, 0x5d8539d7, 0x5d966100, 0x5da7848e, 0x5db8a480, 
0x5dc9c0d4, 0x5ddad98b, 0x5debeea3, 0x5dfd001d, 0x5e0e0df7, 0x5e1f1830, 0x5e301ec9, 0x5e4121c0, 
0x5e522115, 0x5e631cc7, 0x5e7414d5, 0x5e85093f, 0x5e95fa05, 0x5ea6e724, 0x5eb7d09e, 0x5ec8b671, 
0x5ed9989c, 0x5eea771f, 0x5efb51f9, 0x5f0c292a, 0x5f1cfcb1, 0x5f2dcc8d, 0x5f3e98be, 0x5f4f6143, 
0x5f60261b, 0x5f70e745, 0x5f81a4c2, 0x5f925e90, 0x5fa314af, 0x5fb3c71e, 0x5fc475dc, 0x5fd520ea, 
0x5fe5c845, 0x5ff66bee, 0x60070be4, 0x6017a826, 0x602840b4, 0x6038d58c, 0x604966af, 0x6059f41c, 
0x606a7dd2, 0x607b03d0, 0x608b8616, 0x609c04a3, 0x60ac7f76, 0x60bcf690, 0x60cd69ee, 0x60ddd991, 
0x60ee4579, 0x60feada3, 0x610f1210, 0x611f72c0, 0x612fcfb0, 0x614028e2, 0x61507e54, 0x6160d005, 
0x61711df5, 0x61816824, 0x6191ae90, 0x61a1f139, 0x61b2301e, 0x61c26b40, 0x61d2a29c, 0x61e2d633, 
0x61f30604, 0x6203320e, 0x62135a51, 0x62237ecc, 0x62339f7e, 0x6243bc68, 0x6253d587, 0x6263eadc, 
0x6273fc65, 0x62840a23, 0x62941415, 0x62a41a3a, 0x62b41c91, 0x62c41b1a, 0x62d415d5, 0x62e40cbf, 
0x62f3ffda, 0x6303ef25, 0x6313da9e, 0x6323c245, 0x6333a619, 0x6343861b, 0x63536249, 0x63633aa3, 
0x63730f27, 0x6382dfd6, 0x6392acaf, 0x63a275b2, 0x63b23add, 0x63c1fc30, 0x63d1b9aa, 0x63e1734b, 
0x63f12913, 0x6400db00, 0x64108912, 0x64203348, 0x642fd9a3, 0x643f7c20, 0x644f1ac0, 0x645eb582, 
0x646e4c66, 0x647ddf6a, 0x648d6e8e, 0x649cf9d2, 0x64ac8135, 0x64bc04b7, 0x64cb8456, 0x64db0012, 
0x64ea77eb, 0x64f9ebe0, 0x65095bf0, 0x6518c81b, 0x65283061, 0x653794c0, 0x6546f538, 0x655651c8, 
0x6565aa71, 0x6574ff30, 0x65845006, 0x65939cf3, 0x65a2e5f4, 0x65b22b0b, 0x65c16c36, 0x65d0a975, 
0x65dfe2c6, 0x65ef182b, 0x65fe49a1, 0x660d7729, 0x661ca0c1, 0x662bc66a, 0x663ae822, 0x664a05e9, 
0x66591fbf, 0x666835a2, 0x66774793, 0x66865591, 0x66955f9b, 0x66a465b0, 0x66b367d0, 0x66c265fa, 
0x66d1602f, 0x66e0566c, 0x66ef48b3, 0x66fe3701, 0x670d2157, 0x671c07b4, 0x672aea17, 0x6739c880, 
0x6748a2ee, 0x67577960, 0x67664bd7, 0x67751a51, 0x6783e4cf, 0x6792ab4e, 0x67a16dcf, 0x67b02c52, 
0x67bee6d5, 0x67cd9d58, 0x67dc4fdb, 0x67eafe5d, 0x67f9a8dd, 0x68084f5a, 0x6816f1d6, 0x6825904d, 
0x68342ac1, 0x6842c131, 0x6851539b, 0x685fe200, 0x686e6c5e, 0x687cf2b6, 0x688b7507, 0x6899f350, 
0x68a86d91, 0x68b6e3c8, 0x68c555f6, 0x68d3c41b, 0x68e22e34, 0x68f09442, 0x68fef645, 0x690d543b, 
0x691bae25, 0x692a0401, 0x693855cf, 0x6946a38f, 0x6954ed40, 0x696332e1, 0x69717472, 0x697fb1f2, 
0x698deb61, 0x699c20be, 0x69aa5209, 0x69b87f41, 0x69c6a866, 0x69d4cd77, 0x69e2ee73, 0x69f10b5a, 
0x69ff242b, 0x6a0d38e7, 0x6a1b498c, 0x6a295619, 0x6a375e8f, 0x6a4562ec, 0x6a536331, 0x6a615f5c, 
0x6a6f576d, 0x6a7d4b64, 0x6a8b3b3f, 0x6a992700, 0x6aa70ea4, 0x6ab4f22b, 0x6ac2d195, 0x6ad0ace2, 
0x6ade8410, 0x6aec5720, 0x6afa2611, 0x6b07f0e1, 0x6b15b791, 0x6b237a21, 0x6b31388e, 0x6b3ef2da, 
0x6b4ca904, 0x6b5a5b0a, 0x6b6808ed, 0x6b75b2ac, 0x6b835846, 0x6b90f9bc, 0x6b9e970b, 0x6bac3034, 
0x6bb9c537, 0x6bc75613, 0x6bd4e2c6, 0x6be26b52, 0x6befefb5, 0x6bfd6fee, 0x6c0aebfe, 0x6c1863e3, 
0x6c25d79d, 0x6c33472c, 0x6c40b28f, 0x6c4e19c6, 0x6c5b7cd0, 0x6c68dbac, 0x6c76365b, 0x6c838cdb, 
0x6c90df2c, 0x6c9e2d4d, 0x6cab773e, 0x6cb8bcff, 0x6cc5fe8f, 0x6cd33bed, 0x6ce0751a, 0x6cedaa13, 
0x6cfadada, 0x6d08076d, 0x6d152fcc, 0x6d2253f6, 0x6d2f73eb, 0x6d3c8fab, 0x6d49a734, 0x6d56ba87, 
0x6d63c9a3, 0x6d70d487, 0x6d7ddb33, 0x6d8adda6, 0x6d97dbe0, 0x6da4d5e1, 0x6db1cba7, 0x6dbebd33, 
0x6dcbaa83, 0x6dd89398, 0x6de57871, 0x6df2590d, 0x6dff356c, 0x6e0c0d8e, 0x6e18e171, 0x6e25b115, 
0x6e327c7b, 0x6e3f43a1, 0x6e4c0687, 0x6e58c52c, 0x6e657f90, 0x6e7235b3, 0x6e7ee794, 0x6e8b9532, 
0x6e983e8d, 0x6ea4e3a4, 0x6eb18477, 0x6ebe2106, 0x6ecab950, 0x6ed74d55, 0x6ee3dd13, 0x6ef0688b, 
0x6efcefbd, 0x6f0972a6, 0x6f15f148, 0x6f226ba2, 0x6f2ee1b2, 0x6f3b537a, 0x6f47c0f7, 0x6f542a2a, 
0x6f608f13, 0x6f6cefb0, 0x6f794c01, 0x6f85a407, 0x6f91f7bf, 0x6f9e472b, 0x6faa9248, 0x6fb6d918, 
0x6fc31b99, 0x6fcf59cb, 0x6fdb93ae, 0x6fe7c940, 0x6ff3fa82, 0x70002774, 0x700c5013, 0x70187461, 
0x7024945d, 0x7030b005, 0x703cc75b, 0x7048da5d, 0x7054e90a, 0x7060f363, 0x706cf967, 0x7078fb15, 
0x7084f86d, 0x7090f16e, 0x709ce619, 0x70a8d66c, 0x70b4c267, 0x70c0aa0a, 0x70cc8d54, 0x70d86c45, 
0x70e446dc, 0x70f01d19, 0x70fbeefb, 0x7107bc82, 0x711385ad, 0x711f4a7d, 0x712b0af0, 0x7136c706, 
0x71427ebf, 0x714e321a, 0x7159e116, 0x71658bb4, 0x717131f3, 0x717cd3d2, 0x71887151, 0x71940a6f, 
0x719f9f2d, 0x71ab2f89, 0x71b6bb83, 0x71c2431b, 0x71cdc650, 0x71d94522, 0x71e4bf90, 0x71f0359a, 
0x71fba740, 0x72071480, 0x72127d5c, 0x721de1d1, 0x722941e0, 0x72349d89, 0x723ff4ca, 0x724b47a4, 
0x72569615, 0x7261e01e, 0x726d25bf, 0x727866f6, 0x7283a3c3, 0x728edc26, 0x729a101e, 0x72a53fab, 
0x72b06acd, 0x72bb9183, 0x72c6b3cc, 0x72d1d1a9, 0x72dceb18, 0x72e8001a, 0x72f310ad, 0x72fe1cd2, 
0x73092489, 0x731427cf, 0x731f26a7, 0x732a210d, 0x73351704, 0x73400889, 0x734af59d, 0x7355de3e, 
0x7360c26e, 0x736ba22b, 0x73767d74, 0x7381544a, 0x738c26ac, 0x7396f49a, 0x73a1be13, 0x73ac8316, 
0x73b743a4, 0x73c1ffbc, 0x73ccb75d, 0x73d76a88, 0x73e2193b, 0x73ecc377, 0x73f7693a, 0x74020a85, 
0x740ca756, 0x74173faf, 0x7421d38e, 0x742c62f2, 0x7436eddc, 0x7441744b, 0x744bf63e, 0x745673b6, 
0x7460ecb2, 0x746b6131, 0x7475d132, 0x74803cb7, 0x748aa3be, 0x74950646, 0x749f6450, 0x74a9bddb, 
0x74b412e6, 0x74be6372, 0x74c8af7d, 0x74d2f708, 0x74dd3a11, 0x74e7789a, 0x74f1b2a0, 0x74fbe825, 
0x75061926, 0x751045a5, 0x751a6da0, 0x75249118, 0x752eb00c, 0x7538ca7b, 0x7542e065, 0x754cf1c9, 
0x7556fea8, 0x75610701, 0x756b0ad3, 0x75750a1f, 0x757f04e3, 0x7588fb20, 0x7592ecd4, 0x759cda01, 
0x75a6c2a4, 0x75b0a6be, 0x75ba864f, 0x75c46156, 0x75ce37d2, 0x75d809c4, 0x75e1d72b, 0x75eba006, 
0x75f56455, 0x75ff2418, 0x7608df4f, 0x761295f9, 0x761c4815, 0x7625f5a3, 0x762f9ea4, 0x76394316, 
0x7642e2f9, 0x764c7e4d, 0x76561512, 0x765fa747, 0x766934eb, 0x7672bdfe, 0x767c4281, 0x7685c272, 
0x768f3dd2, 0x7698b49f, 0x76a226da, 0x76ab9481, 0x76b4fd96, 0x76be6217, 0x76c7c204, 0x76d11d5d, 
0x76da7421, 0x76e3c650, 0x76ed13ea, 0x76f65cee, 0x76ffa15c, 0x7708e133, 0x77121c74, 0x771b531d, 
0x7724852f, 0x772db2a9, 0x7736db8b, 0x773fffd4, 0x77491f84, 0x77523a9b, 0x775b5118, 0x776462fb, 
0x776d7044, 0x777678f2, 0x777f7d05, 0x77887c7d, 0x77917759, 0x779a6d99, 0x77a35f3c, 0x77ac4c43, 
0x77b534ac, 0x77be1878, 0x77c6f7a6, 0x77cfd236, 0x77d8a828, 0x77e1797b, 0x77ea462e, 0x77f30e42, 
0x77fbd1b6, 0x7804908a, 0x780d4abe, 0x78160051, 0x781eb142, 0x78275d92, 0x78300540, 0x7838a84c, 
0x784146b5, 0x7849e07b, 0x7852759e, 0x785b061e, 0x786391fa, 0x786c1932, 0x78749bc5, 0x787d19b3, 
0x788592fc, 0x788e07a0, 0x7896779d, 0x789ee2f5, 0x78a749a6, 0x78afabb0, 0x78b80913, 0x78c061cf, 
0x78c8b5e3, 0x78d1054f, 0x78d95012, 0x78e1962d, 0x78e9d79f, 0x78f21467, 0x78fa4c86, 0x79027ffa, 
0x790aaec5, 0x7912d8e4, 0x791afe59, 0x79231f22, 0x792b3b40, 0x793352b2, 0x793b6578, 0x79437391, 
0x794b7cfe, 0x795381bd, 0x795b81cf, 0x79637d33, 0x796b73e9, 0x797365f1, 0x797b534a, 0x79833bf4, 
0x798b1fef, 0x7992ff3a, 0x799ad9d5, 0x79a2afc1, 0x79aa80fb, 0x79b24d85, 0x79ba155e, 0x79c1d885, 
0x79c996fb, 0x79d150be, 0x79d905d0, 0x79e0b62e, 0x79e861da, 0x79f008d3, 0x79f7ab18, 0x79ff48aa, 
0x7a06e187, 0x7a0e75b0, 0x7a160524, 0x7a1d8fe4, 0x7a2515ee, 0x7a2c9743, 0x7a3413e2, 0x7a3b8bca, 
0x7a42fefd, 0x7a4a6d78, 0x7a51d73d, 0x7a593c4b, 0x7a609ca1, 0x7a67f83f, 0x7a6f4f25, 0x7a76a153, 
0x7a7deec8, 0x7a853784, 0x7a8c7b87, 0x7a93bad0, 0x7a9af55f, 0x7aa22b35, 0x7aa95c50, 0x7ab088b0, 
0x7ab7b056, 0x7abed341, 0x7ac5f170, 0x7acd0ae3, 0x7ad41f9a, 0x7adb2f95, 0x7ae23ad4, 0x7ae94155, 
0x7af0431a, 0x7af74021, 0x7afe386a, 0x7b052bf6, 0x7b0c1ac4, 0x7b1304d3, 0x7b19ea23, 0x7b20cab5, 
0x7b27a687, 0x7b2e7d9a, 0x7b354fed, 0x7b3c1d80, 0x7b42e652, 0x7b49aa64, 0x7b5069b6, 0x7b572446, 
0x7b5dda15, 0x7b648b22, 0x7b6b376e, 0x7b71def7, 0x7b7881be, 0x7b7f1fc3, 0x7b85b904, 0x7b8c4d83, 
0x7b92dd3e, 0x7b996836, 0x7b9fee69, 0x7ba66fd9, 0x7bacec84, 0x7bb3646a, 0x7bb9d78c, 0x7bc045e9, 
0x7bc6af80, 0x7bcd1451, 0x7bd3745d, 0x7bd9cfa2, 0x7be02621, 0x7be677da, 0x7becc4cc, 0x7bf30cf6, 
0x7bf9505a, 0x7bff8ef5, 0x7c05c8c9, 0x7c0bfdd5, 0x7c122e19, 0x7c185994, 0x7c1e8046, 0x7c24a22f, 
0x7c2abf4f, 0x7c30d7a6, 0x7c36eb33, 0x7c3cf9f5, 0x7c4303ee, 0x7c49091c, 0x7c4f0980, 0x7c550519, 
0x7c5afbe6, 0x7c60ede9, 0x7c66db1f, 0x7c6cc38a, 0x7c72a729, 0x7c7885fc, 0x7c7e6002, 0x7c84353c, 
0x7c8a05a8, 0x7c8fd148, 0x7c95981a, 0x7c9b5a1e, 0x7ca11755, 0x7ca6cfbd, 0x7cac8358, 0x7cb23223, 
0x7cb7dc20, 0x7cbd814f, 0x7cc321ae, 0x7cc8bd3d, 0x7cce53fe, 0x7cd3e5ee, 0x7cd9730e, 0x7cdefb5e, 
0x7ce47ede, 0x7ce9fd8d, 0x7cef776b, 0x7cf4ec79, 0x7cfa5cb4, 0x7cffc81f, 0x7d052eb8, 0x7d0a907e, 
0x7d0fed73, 0x7d154595, 0x7d1a98e5, 0x7d1fe762, 0x7d25310d, 0x7d2a75e4, 0x7d2fb5e7, 0x7d34f118, 
0x7d3a2774, 0x7d3f58fd, 0x7d4485b1, 0x7d49ad91, 0x7d4ed09d, 0x7d53eed3, 0x7d590835, 0x7d5e1cc2, 
0x7d632c79, 0x7d68375b, 0x7d6d3d67, 0x7d723e9d, 0x7d773afd, 0x7d7c3287, 0x7d81253a, 0x7d861317, 
0x7d8afc1d, 0x7d8fe04c, 0x7d94bfa3, 0x7d999a23, 0x7d9e6fcb, 0x7da3409c, 0x7da80c95, 0x7dacd3b5, 
0x7db195fd, 0x7db6536d, 0x7dbb0c03, 0x7dbfbfc1, 0x7dc46ea6, 0x7dc918b1, 0x7dcdbde3, 0x7dd25e3c, 
0x7dd6f9ba, 0x7ddb905f, 0x7de02229, 0x7de4af1a, 0x7de9372f, 0x7dedba6a, 0x7df238ca, 0x7df6b24f, 
0x7dfb26f9, 0x7dff96c7, 0x7e0401ba, 0x7e0867d1, 0x7e0cc90c, 0x7e11256c, 0x7e157cee, 0x7e19cf95, 
0x7e1e1d5f, 0x7e22664c, 0x7e26aa5d, 0x7e2ae990, 0x7e2f23e6, 0x7e33595e, 0x7e3789fa, 0x7e3bb5b7, 
0x7e3fdc97, 0x7e43fe98, 0x7e481bbb, 0x7e4c3400, 0x7e504767, 0x7e5455ef, 0x7e585f97, 0x7e5c6461, 
0x7e60644c, 0x7e645f58, 0x7e685584, 0x7e6c46d1, 0x7e70333d, 0x7e741aca, 0x7e77fd77, 0x7e7bdb44, 
0x7e7fb430, 0x7e83883c, 0x7e875767, 0x7e8b21b1, 0x7e8ee71b, 0x7e92a7a3, 0x7e96634a, 0x7e9a1a10, 
0x7e9dcbf4, 0x7ea178f7, 0x7ea52118, 0x7ea8c457, 0x7eac62b3, 0x7eaffc2e, 0x7eb390c6, 0x7eb7207c, 
0x7ebaab4f, 0x7ebe313f, 0x7ec1b24d, 0x7ec52e77, 0x7ec8a5bf, 0x7ecc1822, 0x7ecf85a3, 0x7ed2ee40, 
0x7ed651f9, 0x7ed9b0ce, 0x7edd0ac0, 0x7ee05fcd, 0x7ee3aff6, 0x7ee6fb3b, 0x7eea419b, 0x7eed8317, 
0x7ef0bfae, 0x7ef3f760, 0x7ef72a2d, 0x7efa5815, 0x7efd8118, 0x7f00a535, 0x7f03c46d, 0x7f06dec0, 
0x7f09f42d, 0x7f0d04b3, 0x7f101054, 0x7f13170f, 0x7f1618e4, 0x7f1915d2, 0x7f1c0dda, 0x7f1f00fc, 
0x7f21ef37, 0x7f24d88b, 0x7f27bcf8, 0x7f2a9c7e, 0x7f2d771e, 0x7f304cd6, 0x7f331da6, 0x7f35e990, 
0x7f38b091, 0x7f3b72ab, 0x7f3e2fde, 0x7f40e828, 0x7f439b8b, 0x7f464a06, 0x7f48f398, 0x7f4b9842, 
0x7f4e3804, 0x7f50d2dd, 0x7f5368ce, 0x7f55f9d6, 0x7f5885f6, 0x7f5b0d2c, 0x7f5d8f7a, 0x7f600cdf, 
0x7f62855a, 0x7f64f8ec, 0x7f676795, 0x7f69d154, 0x7f6c362a, 0x7f6e9617, 0x7f70f119, 0x7f734732, 
0x7f759861, 0x7f77e4a6, 0x7f7a2c01, 0x7f7c6e71, 0x7f7eabf8, 0x7f80e494, 0x7f831846, 0x7f85470d, 
0x7f8770ea, 0x7f8995dc, 0x7f8bb5e3, 0x7f8dd0ff, 0x7f8fe731, 0x7f91f878, 0x7f9404d3, 0x7f960c43, 
0x7f980ec8, 0x7f9a0c62, 0x7f9c0511, 0x7f9df8d4, 0x7f9fe7ab, 0x7fa1d197, 0x7fa3b697, 0x7fa596ac, 
0x7fa771d4, 0x7fa94811, 0x7fab1962, 0x7face5c6, 0x7faead3f, 0x7fb06fcb, 0x7fb22d6c, 0x7fb3e61f, 
0x7fb599e7, 0x7fb748c2, 0x7fb8f2b0, 0x7fba97b2, 0x7fbc37c8, 0x7fbdd2f0, 0x7fbf692c, 0x7fc0fa7b, 
0x7fc286de, 0x7fc40e53, 0x7fc590db, 0x7fc70e76, 0x7fc88724, 0x7fc9fae5, 0x7fcb69b9, 0x7fccd39f, 
0x7fce3898, 0x7fcf98a4, 0x7fd0f3c2, 0x7fd249f3, 0x7fd39b36, 0x7fd4e78c, 0x7fd62ef4, 0x7fd7716e, 
0x7fd8aefa, 0x7fd9e799, 0x7fdb1b4a, 0x7fdc4a0d, 0x7fdd73e2, 0x7fde98c9, 0x7fdfb8c2, 0x7fe0d3cd, 
0x7fe1e9ea, 0x7fe2fb19, 0x7fe40759, 0x7fe50eac, 0x7fe61110, 0x7fe70e85, 0x7fe8070d, 0x7fe8faa6, 
0x7fe9e950, 0x7fead30c, 0x7febb7da, 0x7fec97b9, 0x7fed72aa, 0x7fee48ac, 0x7fef19bf, 0x7fefe5e4, 
0x7ff0ad19, 0x7ff16f61, 0x7ff22cb9, 0x7ff2e523, 0x7ff3989e, 0x7ff4472a, 0x7ff4f0c7, 0x7ff59576, 
0x7ff63535, 0x7ff6d005, 0x7ff765e7, 0x7ff7f6da, 0x7ff882dd, 0x7ff909f2, 0x7ff98c17, 0x7ffa094e, 
0x7ffa8195, 0x7ffaf4ed, 0x7ffb6356, 0x7ffbccd0, 0x7ffc315b, 0x7ffc90f7, 0x7ffceba4, 0x7ffd4161, 
0x7ffd922f, 0x7ffdde0e, 0x7ffe24fe, 0x7ffe66fe, 0x7ffea40f, 0x7ffedc31, 0x7fff0f64, 0x7fff3da8, 
0x7fff66fc, 0x7fff8b61, 0x7fffaad6, 0x7fffc55c, 0x7fffdaf3, 0x7fffeb9b, 0x7ffff753, 0x7ffffe1c, 
};


DATA_TYPE FFTbuf[2048] = {0};


extern unsigned short br2048[];


void pre_twiddle_b(Float *data, Float *fftbuf, int N)
{
	
    int i;
    register Float *pFFTr = &fftbuf[0];
    register Float *pFFTi = &fftbuf[N/4];
	//    register Float *pcos = (N==2048) ? xc512: xc64;
	//    register Float *psin = (N==2048) ? xs512: xs64;
	register Float *pcos;
    register Float *psin;	
    register Float *pXr = &data[0];
    register Float *pXi = &data[N/2-1];
	
	if(N==8192)
	{
		pcos = VorbisdecXc2048;
		psin = VorbisdecXs2048;			
	}
	else if(N==4096)
	{
		pcos = VorbisdecXc1024;
		psin = VorbisdecXs1024;			
	}	
	else if(N==2048)
	{
		pcos = VorbisdecXc512;
		psin = VorbisdecXs512;	
	}else if(N==1024)
	{
		pcos = VorbisdecXc256;
		psin = VorbisdecXs256;			

	}else if(N==512)
	{
		pcos = VorbisdecXc128;
		psin = VorbisdecXs128;			
	}
	else if(N==256)
	{
		pcos = VorbisdecXc64;
		psin = VorbisdecXs64;			
	}
	else if(N==128)
	{
		pcos = VorbisdecXc32;
		psin = VorbisdecXs32;			
	}
	else if(N==64)
	{
		pcos = VorbisdecXc16;
		psin = VorbisdecXs16;			
	}
	
    /* calculate pre-twiddled IFFT input */
    for (i = 0; i < N/4; i++)
    {
		*pFFTr++ = MULT31(-*pXr, *pcos  ) - MULT31(*pXi, *psin  );
		*pFFTi++ = MULT31( *pXi, *pcos++) - MULT31(*pXr, *psin++);
		pXr += 2;
		pXi -= 2;
    }
}

void post_twiddle_2(Float *data, Float *fftbuf, int N)
{
	
    int i;
	int s;
	
	
	register Float *xcp;
    register Float *xsp;	
    register Float *fpr = &fftbuf[0];
    register Float *fpi = &fftbuf[N/4];	
    
    register Float *dp0 = &data[N/2 -1];
    register Float *dp1 = &data[0];
    register Float *dp2 = &data[N/4];
    register Float *dp3 = &data[N/4-1];

	if(N==8192)
	{
		xcp = VorbisdecXc2048;
		xsp = VorbisdecXs2048;			
	}else if(N==4096)
	{
		xcp = VorbisdecXc1024;
		xsp = VorbisdecXs1024;			
	}else if(N==2048)
	{
		xcp = VorbisdecXc512;
		xsp = VorbisdecXs512;	
	}else if(N==1024)
	{
		xcp = VorbisdecXc256;
		xsp = VorbisdecXs256;			
		
	}else if(N==512)
	{
		xcp = VorbisdecXc128;
		xsp = VorbisdecXs128;			
	}else if(N==256)
	{
		xcp = VorbisdecXc64;
		xsp = VorbisdecXs64;			
	}else if(N==128)
	{
		xcp = VorbisdecXc32;
		xsp = VorbisdecXs32;			
	}
	else if(N==64)
	{
		xcp = VorbisdecXc16;
		xsp = VorbisdecXs16;			
	}
	
	if( N == 8192) s = 0;	
	else if( N == 4096) s = 1;
	else if( N == 2048) s = 2;
	else if( N == 1024) s = 3;
	else if( N == 512 ) s = 4;
    else if( N == 256 ) s = 5;    
    else if( N == 128 ) s = 6;
    else if( N == 64 ) s = 7;
	
	
	
    for (i = 0; i < N/8; i++)
    {
		register int j;	/* do bit reversed reordering */	
		register int j0,k;	/* do bit reversed reordering */	
		register Float tempr;
		register Float tempi;
		
#ifndef GNU_TOOL
		j = br2048[i<<s];
#else
		j = radiax_bitrev_vorbis(i<<s);
#endif
		
		tempr = MULT31(fpr[j], *xcp  ) - MULT31(fpi[j], *xsp  );		
		tempi = MULT31(fpi[j], *xcp++) + MULT31(fpr[j], *xsp++);
		
		*dp0 =  tempr; dp0 -= 2;
		*dp3 = -tempi; dp3 -= 2;
		
    }
	
    for (; i < N/4; i++)
    {
		//	register int j = br512[i<<s];	/* do bit reversed reordering */
		//	register Float tempr = MULT31(fpr[j], *xcp  ) - MULT31(fpi[j], *xsp  );
		//	register Float tempi = MULT31(fpi[j], *xcp++) + MULT31(fpr[j], *xsp++);
		register int j,k,j0;	/* do bit reversed reordering */
		register Float tempr;
		register Float tempi;		
#ifndef GNU_TOOL
		j = br2048[i<<s];
#else
		j = radiax_bitrev_vorbis(i<<s);
#endif		
		
		tempr = MULT31(fpr[j], *xcp  ) - MULT31(fpi[j], *xsp  );
		
		tempi = MULT31(fpi[j], *xcp++) + MULT31(fpr[j], *xsp++);
		
		
		*dp1 = -tempr; dp1 += 2;
		*dp2 =  tempi; dp2 += 2;	
		
    }
    
}

// imdct vs imdct2 /////////////////////////
/*
/*         |________|________|________|________|
/*         |        |        |        |        |
/*         -r2   -i1 i1    r2 i2    r1  r1    i2
/*		 
/*         |________|________|________|________|
/*         |        |        |        |        |
/*         -r2   -i1 i2    r1 
/*		 
/**/
///////////////////////////////////////////



int nyim = 0;

void imdct2(int n, DATA_TYPE *in, DATA_TYPE *out){
    int i;
    DATA_TYPE *copy;
	
	
	
    pre_twiddle_b(in, FFTbuf, n);	
	
    ifft_b(&FFTbuf[0], n/4);	
	

    post_twiddle_2(out, FFTbuf, n);


	{
		/*
		long f,k = 0;
		fprintf(fpny,"\n%x----------- imdct start -----%x\n",nyim,n);
		
		//	  fprintf(fpny,"n = %d\n",n);
		for(f = 0 ;f < n/2; f++)
		{
			//		  fprintf(fpny,"pcm[%d]   %d\n",f,pcm[f]);		
			fprintf(fpny,"  0x%08x",out[f]);
			
			
			if( k%8 == 7 )
				fprintf(fpny,"\n");
			
			k++;
		}		
			fprintf(fpny,"----------- imdct end -------------------\n");
		nyim++;
		//*/
	}


	
	///*
	for(i=0;i<n/4;i=i+2)
	{
		out[n-1-i] = out[n/4+i];//i2
		out[n/2+i] = out[n/4+i];//i2
		
		out[n/4*3-1-i] = out[n/2-1-i];//r1
		out[n/4*3+i] = out[n/2-1-i];//r1
		
		out[n/2-1-i] = -out[i];//-r2
		out[n/4+i] = -out[n/4-1-i];//-i2
		
		
	}
	//*/
}
