/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE OggVorbis 'TREMOR' CODEC SOURCE CODE.   *
 *                                                                  *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis 'TREMOR' SOURCE CODE IS (C) COPYRIGHT 1994-2002    *
 * BY THE Xiph.Org FOUNDATION http://www.xiph.org/                  *
 *                                                                  *
 ********************************************************************

 function: window functions

 ********************************************************************/

#include <stdlib.h>
#include <math.h>
#include "os.h"
#include "misc.h"
#include "window.h"
#include "window_lookup.h"
#include <stdio.h>
extern FILE *fpny;

const void *_vorbis_window(int type, int left){

  switch(type){
  case 0:

    switch(left){
    case 32:
      return vwin64;
    case 64:
      return vwin128;
    case 128:
      return vwin256;
    case 256:
      return vwin512;
    case 512:
      return vwin1024;
    case 1024:
      return vwin2048;
    case 2048:
      return vwin4096;
    case 4096:
      return vwin8192;
    default:
      return(0);
    }
    break;
  default:
    return(0);
  }
}

void _vorbis_apply_window(ogg_int32_t *d,const void *window_p[2],
			  long *blocksizes,
			  int lW,int W,int nW){
  
  LOOKUP_T *window[2]={window_p[0],window_p[1]};
  long n=blocksizes[W];
  long ln=blocksizes[lW];
  long rn=blocksizes[nW];

  long leftbegin=n/4-ln/4;
  long leftend=leftbegin+ln/2;

  long rightbegin=n/2+n/4-rn/4;
  long rightend=rightbegin+rn/2;
  
  int i,p;


  for(i=0;i<leftbegin;i++)
    d[i]=0;

  for(p=0;i<leftend;i++,p++)
  {
    d[i]=MULT31(d[i],window[lW][p]);	
  }
  

  for(i=rightbegin,p=rn/2-1;i<rightend;i++,p--)
    d[i]=MULT31(d[i],window[nW][p]);

  for(;i<n;i++)
    d[i]=0;
}

//VORBISDEC_apply_window_front_4096 copy form high-level
//but it can't work,because the source code's window only mult,
//but this function has add and mult, so give up
int VORBISDEC_apply_window_front_4096(ogg_int32_t *d,const void *window_p[2], short *blocksizes, int lW, int W, int nW,
									  vorbis_dsp_state *vd, int ch){
    	
    ogg_int32_t *pcm1, *pcm2,*pcm3;
    ogg_int32_t *w1, *w2;
	
    int i, j, p;
    int samples = 0;
    int nn = blocksizes[W]/2;
    int n0 = blocksizes[0]/2;
    int n1 = blocksizes[1]/2;
    int prevCenter = vd->centerW ? 0 : n1;
	

    ogg_int32_t *pcm = (ogg_int32_t*)(vd->pcm[ch]+prevCenter);

	
	w1 = (ogg_int32_t*)window_p[lW];
    pcm1 = (ogg_int32_t*)(vd->pcm[ch]+prevCenter);
	pcm3 = pcm1;
	
  //  vd->pcmret[ch] = vd->pcm[ch]+prevCenter;
	
    if( vd->lW == vd->W ){
		/* large/large or small/small */
		pcm2 = pcm1+nn-1;
		w2 = w1+nn-1;
		for( i = 0; i < (nn>>1); i++){
			*pcm1++ += MULT31(d[i], *w1++);
			*pcm2-- += MULT31(-d[i], *w2--);
		}
		samples = nn;
    }else if( vd->lW){
		/* large/small */
		pcm1 += ((n1>>1) - (n0>>1));
		pcm2 = pcm1 + n0 -1;
		w2 = w1 + n0 -1;
		for( p = 0; p < n0>>1; p++){
			*pcm1++ += MULT31(d[p], *w1++);
			*pcm2-- += MULT31(-d[p], *w2--);
		}
		samples = (n0+n1)>>1;
		//	pcm += ((n1>>1)-(n0>>1));
    }else{
		/* small/large */
		pcm2 = pcm1 + n0-1;
		w2 = w1+n0-1;
		for( p = 0, i = n1/2-n0/2; p < n0/2; p++, i++){
			*pcm1++ += MULT31(d[i], *w1++);
			*pcm2-- += MULT31(-d[i], *w2--);
		}
		//pcm1 = ((ogg_int32_t *)&__start_vorbisdec_dmem_data_vorbisdsppcm_4096) + n0;
		pcm1 = pcm3;
		for( i = n1/2 - n0/2 -1; i >= 0; i--)
			*pcm1++ = -d[i];
		samples = (n0+n1)>>1;
    }
    for( i = 0; i < samples; i++){
		int r, x;
		r = pcm[i]>>9;
		x = r;
		r -= ((x<=32767)-1)&(x-32767);
		r -= ((x>=-32768)-1)&(x+32768);
		pcm[i] = r<<9;
    }
	    
    return samples;
}


	
int VORBISDEC_apply_window_rear_4096(ogg_int32_t *d, const void *window_p[2], short *blocksizes, int lW, int W, int nW,
									 vorbis_dsp_state *vd, int ch){ 
    
	
    ogg_int32_t *pcm1, *pcm2,*pcm3;
    ogg_int32_t *w1, *w2;
	
    int i, j, p;
    int nn = blocksizes[W]/2;
    int n1 = blocksizes[1]/2;
    int rn = blocksizes[nW];
	int prevCenter = vd->centerW ? 0 : n1;

    
	if( lW != nW )		
		w1 = (ogg_int32_t*)window_p[lW];
	else		
		w1 = (ogg_int32_t*)window_p[nW];
    pcm1 = (ogg_int32_t*)(vd->pcm[ch]+prevCenter);
	pcm3 = pcm1;
    d -= nn/2;
    for( i = nn; i < nn+nn/2-rn/4; i++)
		*pcm1++ = d[i];
    pcm2 = (pcm3) + nn/2 + rn/4 -1;
    w2 = w1 + rn/2 -1;
    for( p = rn/2-1; p >= rn/4; i++, p--){
		*pcm1++ = MULT31(d[i], *w2--);
		*pcm2-- = MULT31(d[i], *w1++);
    }
	
    
}

int VORBISDEC_apply_window(ogg_int32_t *d,  void *window_p[2], short *blocksizes, int lW, int W, int nW,
									 vorbis_dsp_state *vd, int ch){ 
	


    long rn=blocksizes[nW];

    int i,p;


    int samples = 0;
    int nn = blocksizes[W]/2;
    int n0 = blocksizes[0]/2;
    int n1 = blocksizes[1]/2;
    int j;

    ogg_int32_t *pcm;
    ogg_int32_t *pcm1, *pcm2;
    ogg_int32_t *w1, *w2;
    int thisCenter, prevCenter;
    if( vd->centerW ){
	thisCenter = n1;
	prevCenter = 0;
    }else{
	thisCenter = 0;
	prevCenter = n1;
    }

/* when the size of window change, this block is always "large" */
/* the front half block, multiply and add */
    pcm = vd->pcm[ch]+prevCenter;
    pcm1 = vd->pcm[ch]+prevCenter;
    vd->pcmret[ch] = vd->pcm[ch]+prevCenter;
    w1 = (ogg_int32_t*)window_p[lW];
    if( vd->lW == vd->W ){
	/* large/large or small/small */
	pcm2 = pcm1+nn-1;
	w2 = w1+nn-1;
	for( i = 0; i < (nn>>1); i++){
	    *pcm1++ += MULT31(d[i], *w1++);
	    *pcm2-- += MULT31(-d[i], *w2--);
	}
	samples = nn;
    }else if( vd->lW ){
	/* large/small */
	pcm += (n1>>1);
	pcm1 += (n1>>1) - (n0>>1);
	pcm2 = pcm1 + n0 -1;
	w2 = w1 + n0 -1; 
	for( p = 0; p < n0>>1; p++){
	    *pcm1++ += MULT31(d[p], *w1++);
	    *pcm2-- += MULT31(-d[p], *w2--);
	}
	samples = (n0+n1)>>1;
    }else{
	/* small/large */
	pcm2 = pcm1 + n0 -1;
	w2 = w1+ n0 -1;
	for( p = 0, i = n1/2-n0/2; p < n0/2; p++, i++){
	    *pcm1++ += MULT31(d[i], *w1++);
	    *pcm2-- += MULT31(-d[i], *w2--);
	}
	pcm1 = vd->pcm[ch]+prevCenter+n0;
	for( i = n1/2-n0/2-1, p = n0; i >= 0; i--, p++)
	    *pcm1++ = -d[i];
	samples = (n0+n1)>>1;
    }
#if 1
    pcm1 = vd->pcm+prevCenter;
    for( i = 0; i < samples; i++){
	int r, x;
	r = pcm1[i]>>9;
	x = r;
	r -= ((x<=32767)-1)&(x-32767);
	r -= ((x>=-32768)-1)&(x+32768);
	pcm1[i] = r<<9;
    }
#endif
/* the rear half block */
    pcm = vd->pcm[ch]+thisCenter;
    pcm1 = vd->pcm[ch]+thisCenter;
    w1 = (ogg_int32_t*)window_p[nW];
    d -= nn/2;
    for( i = nn; i < nn+nn/2-rn/4; i++)
	*pcm1++ = d[i];
    pcm2 = vd->pcm[ch]+thisCenter+nn/2-1+rn/4;
    w2 = w1 + rn/2 -1;
    for( p = rn/2-1; p >= rn/4; i++, p--){
	*pcm1++ = MULT31(d[i], *w2--);
	*pcm2-- = MULT31(d[i], *w1++);
    }


    return samples;

}
