//  MiscHelpManager.m



//  vSigX



//



//  Created by Allan Hoeltje on Tue Oct 5 2004.



//  Copyright (c) 2004 WholeCheese.com. All rights reserved.



//



//  Gleaned from MiscHelpManager by Don Yacktman from the book



//	"Cocoa Programming" copyright 2003 by Sams Publishing.







#import "MiscHelpManager.h"



#import <Carbon/Carbon.h>











@interface MiscHelpManager (PrivateMethods)







-(void)_registerBook;







-(OSStatus)_goToAnchorNamed: (CFStringRef)anchorName onPage: (CFStringRef)pagePath;



-(OSStatus)_goToAnchorNamed: (CFStringRef)anchorName;







-(void)_reportError: (OSStatus)err



		 forMethodNamed: (NSString *)methodName



					 withData: (NSString *)data;



@end











@implementation MiscHelpManager







+(id)sharedHelpManager



{



	static MiscHelpManager *sharedHelpManager = nil;



	



	if (sharedHelpManager == nil)



	{



		sharedHelpManager = [[MiscHelpManager alloc] init];



		[sharedHelpManager _registerBook];



	}



	



	return sharedHelpManager;



}











//	Register our application's Help Book.



-(void)_registerBook



{



	OSStatus err = fnfErr;







	//	Get our application's main bundle from Core Foundation



	CFBundleRef myAppsBundle = CFBundleGetMainBundle();



	if (myAppsBundle != NULL) 



	{



		//	retrieve the URL to our bundle



		CFURLRef myBundleURL = CFBundleCopyBundleURL(myAppsBundle);



		if (myBundleURL != nil) 



		{



			//	Convert the URL to a file or directory object.



			FSRef myBundleRef;



			if (CFURLGetFSRef(myBundleURL, &myBundleRef)) 



			{



				// register our application's help book



				err = AHRegisterHelpBook(&myBundleRef);



			}







			CFRelease(myBundleURL);



		}



	}







	if (err != noErr) 



	{



		[self _reportError:  err forMethodNamed:  @"registerBook" withData:  @""];



	}



}







-(void)goToUserHelpCenter



{



	OSStatus err = AHGotoMainTOC(kAHTOCTypeUser);



	if (err != noErr)



	{



		[self _reportError: err forMethodNamed: @"goToUserHelpCenter" withData: @""];



	}



}







-(void)goToDeveloperHelpCenter



{



	OSStatus err = AHGotoMainTOC(kAHTOCTypeDeveloper);



	if (err != noErr) 



	{



		[self _reportError:  err forMethodNamed:  @"goToDeveloperHelpCenter" withData:  @""];



	}



}







-(void)goToTableOfContents



{



	OSStatus err = [self _goToAnchorNamed:  NULL onPage:  NULL];



	if (err != noErr) 



	{



		[self _reportError:  err forMethodNamed:  @"goToTableOfContents" withData: @""];



	}



}







-(void)goToPage: (NSString *)pagePath



{



	OSStatus err = [self _goToAnchorNamed: NULL onPage: (CFStringRef)pagePath];



	if (err != noErr) 



	{



		[self _reportError: err forMethodNamed: @"goToPage: " withData: pagePath];



	}



}







-(void)goToAnchorNamed: (NSString *)anchorName



{



	OSStatus err = [self _goToAnchorNamed: (CFStringRef)anchorName];



	if (err != noErr)



	{



		[self _reportError: err forMethodNamed: @"goToAnchorNamed: " withData: anchorName];



	}



}







-(void)goToAnchorNamed: (NSString *)anchorName onPage: (NSString *)pagePath



{



	OSStatus err = [self _goToAnchorNamed: (CFStringRef)anchorName onPage: (CFStringRef)pagePath];



	if (err != noErr) 



	{



		[self _reportError: err forMethodNamed: @"goToAnchorNamed: onPage: " withData: 



			[NSString stringWithFormat: @"%@: %@", pagePath, anchorName]];



	}



}







//--------------------------------------------------------------------------------



//	Private Parts...



//--------------------------------------------------------------------------------







-(OSStatus)_goToAnchorNamed: (CFStringRef)anchorName onPage: (CFStringRef)pagePath



{



	OSStatus err = fnfErr;



	// If pagePath is NULL, goes to main TOC



	// If anchorName is NULL, goes to top of page



	



	//	Get our application's main bundle from Core Foundation



	CFBundleRef myAppsBundle = CFBundleGetMainBundle();



	if (myAppsBundle != NULL) 



	{



		//	get the help book's name



		CFTypeRef myBookName = CFBundleGetValueForInfoDictionaryKey(



					myAppsBundle, CFSTR("CFBundleHelpBookName"));



		if (myBookName != NULL) 



		{



			//	verify the data type returned



			if (CFGetTypeID(myBookName) == CFStringGetTypeID()) 



			{



				//	load the HTML page.



				err = AHGotoPage(myBookName, pagePath, anchorName);



			}



			else



			{



				err = paramErr;



			}



		}



	}







	return err;



}







-(OSStatus)_goToAnchorNamed: (CFStringRef)anchorName



{



	OSStatus err = fnfErr;



	



	//	Get our application's main bundle from Core Foundation



	CFBundleRef myAppsBundle = CFBundleGetMainBundle();



	if (myAppsBundle != NULL) 



	{



		// get the help book's name



		//	get the help book's name



		CFTypeRef myBookName = CFBundleGetValueForInfoDictionaryKey(



					myAppsBundle, CFSTR("CFBundleHelpBookName"));



		if (myBookName != NULL) 



		{



			//	verify the data type returned



			if (CFGetTypeID(myBookName) == CFStringGetTypeID()) 



			{



				// go to the page



				err = AHLookupAnchor(myBookName, anchorName);



			}



			else



			{



				err = paramErr;



			}



		}



	}







	return err;



}







-(void)_reportError: (OSStatus)err



		 forMethodNamed: (NSString *)methodName



					 withData: (NSString *)data



{



	if (err != noErr)



	{



		if (err == fnfErr) 



		{



			NSLog(@"IXHelpManager %@: File not found.  (\"%@\")", methodName, data);



		} 



		else 



		if (err == paramErr) 



		{



			NSLog(@"IXHelpManager %@: Invalid parameter.  (\"%@\")", methodName, data);



		} 



		else 



		{



			NSLog(@"IXHelpManager %@: Unknown error %d.  (\"%@\")", methodName, err, data);



		}



	}



}







@end



